/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import javax.swing.UIManager;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.TextUtilities;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.AddAbbrevDialog;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.textarea.JEditTextArea;
import org.gjt.sp.util.Log;

public class Abbrevs {
    public static final String ENCODING = "UTF8";
    private static boolean loaded;
    private static boolean abbrevsChanged;
    private static long abbrevsModTime;
    private static boolean expandOnInput;
    private static Hashtable<String, String> globalAbbrevs;
    private static Hashtable<String, Hashtable<String, String>> modes;
    private static Vector<String> m_pp;

    public static boolean getExpandOnInput() {
        return expandOnInput;
    }

    public static void setExpandOnInput(boolean bl) {
        expandOnInput = bl;
    }

    public static boolean expandAbbrev(View view, boolean bl) {
        int n;
        String string;
        int n2;
        Buffer buffer = view.getBuffer();
        JEditTextArea jEditTextArea = view.getTextArea();
        if (!buffer.isEditable()) {
            UIManager.getLookAndFeel().provideErrorFeedback(null);
            return false;
        }
        int n3 = jEditTextArea.getCaretLine();
        int n4 = buffer.getLineStartOffset(n3);
        int n5 = jEditTextArea.getCaretPosition();
        String string2 = buffer.getLineText(n3);
        if (string2.length() == 0) {
            if (bl) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            }
            return false;
        }
        int n6 = n5 - n4;
        if (n6 == 0) {
            if (bl) {
                UIManager.getLookAndFeel().provideErrorFeedback(null);
            }
            return false;
        }
        m_pp.removeAllElements();
        if (string2.charAt(n6 - 1) == '#') {
            n2 = string2.indexOf(35);
            n2 = TextUtilities.findWordStart(string2, n2, buffer.getStringProperty("noWordSep") + "#");
            string = string2.substring(n2, n6 - 1);
            int n7 = 0;
            for (n = 0; n < string.length(); ++n) {
                if (string.charAt(n) != '#') continue;
                m_pp.addElement(string.substring(n7, n));
                n7 = n + 1;
            }
            m_pp.addElement(string.substring(n7));
            string = m_pp.elementAt(0);
            m_pp.removeElementAt(0);
        } else {
            n2 = TextUtilities.findWordStart(string2, n6 - 1, buffer.getStringProperty("noWordSep"));
            string = string2.substring(n2, n6);
        }
        Expansion expansion = Abbrevs.expandAbbrev(buffer.getMode().getName(), string, buffer.getBooleanProperty("noTabs") ? buffer.getTabSize() : 0, m_pp);
        if (expansion == null) {
            if (bl) {
                new AddAbbrevDialog(view, string);
            }
            return false;
        }
        buffer.remove(n4 + n2, n6 - n2);
        n = buffer.insertIndented(n4 + n2, expansion.text);
        int n8 = Abbrevs.countNewlines(expansion.text, expansion.caretPosition);
        if (expansion.caretPosition != -1) {
            jEditTextArea.setCaretPosition(n4 + n2 + expansion.caretPosition + n8 * n);
        }
        if (expansion.posParamCount != m_pp.size()) {
            view.getStatus().setMessageAndClear(jEdit.getProperty("view.status.incomplete-abbrev", new Integer[]{m_pp.size(), expansion.posParamCount}));
        }
        return true;
    }

    public static Hashtable<String, String> getGlobalAbbrevs() {
        if (!loaded) {
            Abbrevs.load();
        }
        return globalAbbrevs;
    }

    public static void setGlobalAbbrevs(Hashtable<String, String> hashtable) {
        abbrevsChanged = true;
        globalAbbrevs = hashtable;
    }

    public static Hashtable<String, Hashtable<String, String>> getModeAbbrevs() {
        if (!loaded) {
            Abbrevs.load();
        }
        return modes;
    }

    public static void setModeAbbrevs(Hashtable<String, Hashtable<String, String>> hashtable) {
        abbrevsChanged = true;
        modes = hashtable;
    }

    public static void addGlobalAbbrev(String string, String string2) {
        if (!loaded) {
            Abbrevs.load();
        }
        globalAbbrevs.put(string, string2);
        abbrevsChanged = true;
    }

    public static void addModeAbbrev(String string, String string2, String string3) {
        Hashtable<String, String> hashtable;
        if (!loaded) {
            Abbrevs.load();
        }
        if ((hashtable = modes.get(string)) == null) {
            hashtable = new Hashtable();
            modes.put(string, hashtable);
        }
        hashtable.put(string2, string3);
        abbrevsChanged = true;
    }

    static void save() {
        jEdit.setBooleanProperty("view.expandOnInput", expandOnInput);
        String string = jEdit.getSettingsDirectory();
        if (abbrevsChanged && string != null) {
            File file = new File(MiscUtilities.constructPath(string, "#abbrevs#save#"));
            File file2 = new File(MiscUtilities.constructPath(string, "abbrevs"));
            if (file2.exists() && file2.lastModified() != abbrevsModTime) {
                Log.log(7, Abbrevs.class, file2 + " changed on disk; will not save abbrevs");
            } else {
                jEdit.backupSettingsFile(file2);
                try {
                    Abbrevs.saveAbbrevs(new OutputStreamWriter((OutputStream)new FileOutputStream(file), ENCODING));
                    file2.delete();
                    file.renameTo(file2);
                }
                catch (Exception exception) {
                    Log.log(9, Abbrevs.class, "Error while saving " + file);
                    Log.log(9, Abbrevs.class, exception);
                }
                abbrevsModTime = file2.lastModified();
            }
        }
    }

    private Abbrevs() {
    }

    private static void load() {
        globalAbbrevs = new Hashtable();
        modes = new Hashtable();
        String string = jEdit.getSettingsDirectory();
        if (string != null) {
            File file = new File(MiscUtilities.constructPath(string, "abbrevs"));
            abbrevsModTime = file.lastModified();
            try {
                Abbrevs.loadAbbrevs(new InputStreamReader((InputStream)new FileInputStream(file), ENCODING));
                loaded = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (Exception exception) {
                Log.log(9, Abbrevs.class, "Error while loading " + file);
                Log.log(9, Abbrevs.class, exception);
            }
        }
        if (!loaded) {
            try {
                Abbrevs.loadAbbrevs(new InputStreamReader(Abbrevs.class.getResourceAsStream("default.abbrevs"), ENCODING));
            }
            catch (Exception exception) {
                Log.log(9, Abbrevs.class, "Error while loading default.abbrevs");
                Log.log(9, Abbrevs.class, exception);
            }
            loaded = true;
        }
    }

    private static int countNewlines(String string, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != '\n') continue;
            ++n2;
        }
        return n2;
    }

    private static Expansion expandAbbrev(String string, String string2, int n, Vector<String> vector) {
        m_pp = vector;
        if (!loaded) {
            Abbrevs.load();
        }
        String string3 = null;
        Hashtable<String, String> hashtable = modes.get(string);
        if (hashtable != null) {
            string3 = hashtable.get(string2);
        }
        if (string3 == null) {
            string3 = globalAbbrevs.get(string2);
        }
        if (string3 == null) {
            return null;
        }
        return new Expansion(string3, n, m_pp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadAbbrevs(Reader reader) throws Exception {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String string;
            Hashtable<String, String> hashtable = globalAbbrevs;
            while ((string = bufferedReader.readLine()) != null) {
                int n = string.indexOf(124);
                if (string.length() == 0) continue;
                if (string.startsWith("[") && n == -1) {
                    if (string.equals("[global]")) {
                        hashtable = globalAbbrevs;
                        continue;
                    }
                    String string2 = string.substring(1, string.length() - 1);
                    hashtable = modes.get(string2);
                    if (hashtable != null) continue;
                    hashtable = new Hashtable();
                    modes.put(string2, hashtable);
                    continue;
                }
                if (n == -1) continue;
                hashtable.put(string.substring(0, n), string.substring(n + 1));
            }
        }
    }

    private static void saveAbbrevs(Writer writer) throws Exception {
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        String string = System.getProperty("line.separator");
        bufferedWriter.write("[global]");
        bufferedWriter.write(string);
        Abbrevs.saveAbbrevs(bufferedWriter, globalAbbrevs);
        Enumeration<String> enumeration = modes.keys();
        Enumeration<Hashtable<String, String>> enumeration2 = modes.elements();
        while (enumeration.hasMoreElements()) {
            bufferedWriter.write(91);
            bufferedWriter.write(enumeration.nextElement());
            bufferedWriter.write(93);
            bufferedWriter.write(string);
            Abbrevs.saveAbbrevs(bufferedWriter, enumeration2.nextElement());
        }
        bufferedWriter.close();
    }

    private static void saveAbbrevs(Writer writer, Hashtable<String, String> hashtable) throws Exception {
        String string = System.getProperty("line.separator");
        Enumeration<String> enumeration = hashtable.keys();
        Enumeration<String> enumeration2 = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            writer.write(string2);
            writer.write(124);
            writer.write(enumeration2.nextElement());
            writer.write(string);
        }
    }

    static {
        m_pp = new Vector();
        expandOnInput = jEdit.getBooleanProperty("view.expandOnInput");
    }

    static class Expansion {
        String text;
        int caretPosition = -1;
        int lineCount;
        int posParamCount;

        Expansion(String string, int n, List<String> list) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                int n2;
                char c = string.charAt(i);
                if (bl) {
                    bl = false;
                    if (c == '|') {
                        this.caretPosition = stringBuilder.length();
                        continue;
                    }
                    if (c == 'n') {
                        stringBuilder.append('\n');
                        ++this.lineCount;
                        continue;
                    }
                    if (c == 't') {
                        if (n == 0) {
                            stringBuilder.append('\t');
                            continue;
                        }
                        for (n2 = 0; n2 < n; ++n2) {
                            stringBuilder.append(' ');
                        }
                        continue;
                    }
                    stringBuilder.append(c);
                    continue;
                }
                if (c == '\\') {
                    bl = true;
                    continue;
                }
                if (c == '$') {
                    if (i != string.length() - 1) {
                        c = string.charAt(i + 1);
                        if (Character.isDigit(c) && c != '0') {
                            ++i;
                            n2 = c - 48;
                            this.posParamCount = Math.max(n2, this.posParamCount);
                            if (n2 > list.size()) continue;
                            stringBuilder.append(list.get(n2 - 1));
                            continue;
                        }
                        stringBuilder.append('$');
                        continue;
                    }
                    stringBuilder.append('$');
                    continue;
                }
                stringBuilder.append(c);
            }
            this.text = stringBuilder.toString();
        }
    }
}

