/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit;

import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.SettingsXML;
import org.gjt.sp.jedit.SplitConfigParser;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.io.VFS;
import org.gjt.sp.jedit.io.VFSFile;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.gjt.sp.util.XMLUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class PerspectiveManager {
    private static final String PERSPECTIVE_FILENAME = "perspective";
    private static boolean dirty;
    private static boolean enabled;
    private static SettingsXML perspectiveXML;

    public static boolean isPerspectiveDirty() {
        return dirty;
    }

    public static void setPerspectiveDirty(boolean bl) {
        dirty = bl;
    }

    public static boolean isPerspectiveEnabled() {
        return enabled;
    }

    public static void setPerspectiveEnabled(boolean bl) {
        enabled = bl;
    }

    public static View loadPerspective(boolean bl) {
        if (perspectiveXML == null) {
            return null;
        }
        if (!perspectiveXML.fileExists()) {
            return null;
        }
        Log.log(3, PerspectiveManager.class, "Loading " + perspectiveXML);
        PerspectiveHandler perspectiveHandler = new PerspectiveHandler(bl);
        try {
            perspectiveXML.load(perspectiveHandler);
        }
        catch (IOException iOException) {
            Log.log(9, PerspectiveManager.class, iOException);
        }
        return perspectiveHandler.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void savePerspective(boolean bl) {
        if (!PerspectiveManager.isPerspectiveEnabled() || !jEdit.isStartupDone()) {
            return;
        }
        if (perspectiveXML == null) {
            return;
        }
        if (jEdit.getBufferCount() == 0) {
            return;
        }
        BufferManager bufferManager = jEdit.getBufferManager();
        Collection collection = bufferManager.getBuffers().stream().filter(buffer -> !buffer.isNewFile() || buffer.isUntitled()).collect(Collectors.toList());
        if (!bl) {
            Log.log(3, PerspectiveManager.class, "Saving " + perspectiveXML);
        }
        String string = System.getProperty("line.separator");
        SettingsXML.Saver saver = null;
        try {
            saver = perspectiveXML.openSaver();
            saver.writeXMLDeclaration();
            saver.write("<!DOCTYPE PERSPECTIVE SYSTEM \"perspective.dtd\">");
            saver.write(string);
            saver.write("<PERSPECTIVE>");
            saver.write(string);
            for (Buffer buffer2 : collection) {
                saver.write("<BUFFER AUTORELOAD=\"");
                saver.write(buffer2.getAutoReload() ? "TRUE" : "FALSE");
                saver.write("\" AUTORELOAD_DIALOG=\"");
                saver.write(buffer2.getAutoReloadDialog() ? "TRUE" : "FALSE");
                saver.write("\" UNTITLED=\"");
                saver.write(buffer2.isUntitled() ? "TRUE" : "FALSE");
                saver.write("\">");
                saver.write(XMLUtilities.charsToEntities(buffer2.getPath(), false));
                saver.write("</BUFFER>");
                saver.write(string);
            }
            View[] viewArray = jEdit.getViewManager().getViews().toArray(new View[0]);
            for (int i = 0; i < viewArray.length; ++i) {
                Object object;
                Object object2 = viewArray[i];
                if (object2 == jEdit.getActiveView() && i != viewArray.length - 1) {
                    viewArray[i] = object = viewArray[viewArray.length - 1];
                    viewArray[viewArray.length - 1] = object2;
                    object2 = object;
                }
                object = viewArray[i].getViewConfig();
                saver.write("<VIEW PLAIN=\"");
                saver.write(((View.ViewConfig)object).plainView ? "TRUE" : "FALSE");
                saver.write("\">");
                saver.write(string);
                if (((View.ViewConfig)object).title != null) {
                    saver.write(string);
                    saver.write("<TITLE>");
                    saver.write(XMLUtilities.charsToEntities(((View.ViewConfig)object).title, false));
                    saver.write("</TITLE>");
                    saver.write(string);
                }
                saver.write("<PANES>");
                saver.write(string);
                saver.write(XMLUtilities.charsToEntities(((View.ViewConfig)object).splitConfig, false));
                saver.write(string);
                saver.write("</PANES>");
                saver.write(string);
                saver.write("<GEOMETRY X=\"");
                saver.write(String.valueOf(((View.ViewConfig)object).x));
                saver.write("\" Y=\"");
                saver.write(String.valueOf(((View.ViewConfig)object).y));
                saver.write("\" WIDTH=\"");
                saver.write(String.valueOf(((View.ViewConfig)object).width));
                saver.write("\" HEIGHT=\"");
                saver.write(String.valueOf(((View.ViewConfig)object).height));
                saver.write("\" EXT_STATE=\"");
                saver.write(String.valueOf(((View.ViewConfig)object).extState));
                saver.write("\" />");
                saver.write(string);
                if (((View.ViewConfig)object).docking != null) {
                    ((View.ViewConfig)object).docking.saveLayout(PERSPECTIVE_FILENAME, i);
                }
                saver.write("</VIEW>");
                saver.write(string);
            }
            saver.write("</PERSPECTIVE>");
            saver.write(string);
            saver.finish();
        }
        catch (IOException iOException) {
            Log.log(9, PerspectiveManager.class, "Error saving " + perspectiveXML);
            Log.log(9, PerspectiveManager.class, iOException);
        }
        finally {
            IOUtilities.closeQuietly(saver);
        }
    }

    static {
        enabled = true;
        String string = jEdit.getSettingsDirectory();
        if (string != null) {
            perspectiveXML = new SettingsXML(string, PERSPECTIVE_FILENAME);
        }
    }

    private static class PerspectiveHandler
    extends DefaultHandler {
        View view;
        private StringBuilder charData;
        View.ViewConfig config;
        boolean restoreFiles;
        boolean restoreSplits;
        String autoReload;
        String autoReloadDialog;
        String untitled;

        PerspectiveHandler(boolean bl) {
            this.restoreFiles = bl;
            this.restoreSplits = jEdit.getBooleanProperty("restore.splits", true);
            this.config = new View.ViewConfig();
            this.charData = new StringBuilder();
            this.config.docking = View.getDockingFrameworkProvider().createDockingLayout();
        }

        @Override
        public InputSource resolveEntity(String string, String string2) {
            return XMLUtilities.findEntity(string2, "perspective.dtd", this.getClass());
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            this.charData.setLength(0);
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string4 = attributes.getQName(i);
                String string5 = attributes.getValue(i);
                this.attribute(string4, string5);
            }
        }

        private void attribute(String string, String string2) {
            if (string.equals("X")) {
                this.config.x = Integer.parseInt(string2);
            } else if (string.equals("Y")) {
                this.config.y = Integer.parseInt(string2);
            } else if (string.equals("WIDTH")) {
                this.config.width = Integer.parseInt(string2);
            } else if (string.equals("HEIGHT")) {
                this.config.height = Integer.parseInt(string2);
            } else if (string.equals("EXT_STATE")) {
                this.config.extState = Integer.parseInt(string2);
            } else if (string.equals("PLAIN")) {
                this.config.plainView = "TRUE".equals(string2);
            } else if (string.equals("AUTORELOAD")) {
                this.autoReload = string2;
            } else if (string.equals("AUTORELOAD_DIALOG")) {
                this.autoReloadDialog = string2;
            } else if (string.equals("UNTITLED")) {
                this.untitled = string2;
            }
        }

        public static boolean skipRemote(String string) {
            String string2;
            if (jEdit.getBooleanProperty("restore.remote")) {
                return false;
            }
            return MiscUtilities.isURL(string) && !(string2 = MiscUtilities.getProtocolOfURL(string)).equals("file");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endElement(String string, String string2, String string3) {
            if (string3.equals("BUFFER")) {
                String string4 = this.charData.toString();
                if (this.restoreFiles && !PerspectiveHandler.skipRemote(string4)) {
                    boolean bl = false;
                    VFS vFS = VFSManager.getVFSForPath(string4);
                    Object object = vFS.createVFSSession(string4, this.view);
                    try {
                        VFSFile vFSFile = vFS._getFile(object, string4, this.view);
                        bl = vFSFile != null;
                    }
                    catch (IOException iOException) {
                        Log.log(9, this, iOException);
                    }
                    finally {
                        try {
                            vFS._endVFSSession(object, this.view);
                        }
                        catch (IOException iOException) {
                            Log.log(9, this, iOException);
                        }
                    }
                    boolean bl2 = !bl && "TRUE".equals(this.untitled);
                    Buffer buffer = jEdit.openTemporary(null, null, string4, bl2, null, bl2);
                    if (buffer != null) {
                        if (this.autoReload != null) {
                            buffer.setAutoReload("TRUE".equals(this.autoReload));
                        }
                        if (this.autoReloadDialog != null) {
                            buffer.setAutoReloadDialog("TRUE".equals(this.autoReloadDialog));
                        }
                        if (this.untitled != null) {
                            buffer.setUntitled(bl2);
                        }
                        jEdit.commitTemporary(buffer);
                    }
                }
            } else if (string3.equals("PANES")) {
                SplitConfigParser splitConfigParser = new SplitConfigParser(this.charData.toString());
                splitConfigParser.setIncludeSplits(this.restoreSplits);
                splitConfigParser.setIncludeFiles(this.restoreFiles);
                splitConfigParser.setIncludeRemoteFiles(jEdit.getBooleanProperty("restore.remote"));
                this.config.splitConfig = splitConfigParser.parse();
            } else if (string3.equals("VIEW")) {
                if (this.config.docking != null) {
                    this.config.docking.loadLayout(PerspectiveManager.PERSPECTIVE_FILENAME, jEdit.getViewCount());
                }
                this.view = jEdit.newView(this.view, null, this.config);
                this.config = new View.ViewConfig();
                this.config.docking = View.getDockingFrameworkProvider().createDockingLayout();
            } else if (string3.equals("TITLE")) {
                this.config.title = this.charData.toString();
            }
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            this.charData.append(cArray, n, n2);
        }
    }
}

