/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.options;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import org.gjt.sp.jedit.AbstractOptionPane;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.GUIUtilities;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.Mode;
import org.gjt.sp.jedit.buffer.FoldHandler;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.util.StandardUtilities;

public class BufferOptionPane
extends AbstractOptionPane {
    private JComboBox<String> encoding;
    private JComboBox<String> lineSeparator;
    private JCheckBox gzipped;
    private Mode[] modes;
    private JComboBox<Mode> mode;
    private JComboBox<String> folding;
    private JComboBox<String> wrap;
    private JComboBox<String> maxLineLen;
    private JComboBox<String> tabSize;
    private JComboBox<String> indentSize;
    private JComboBox<String> checkModStatus;
    private JCheckBox noTabs;
    private Buffer buffer;
    private JCheckBox elasticTabstops;
    private JComboBox<String> autoIndent;
    private JCheckBox locked;

    public BufferOptionPane() {
        super("Buffer Options");
        this.init();
    }

    @Override
    protected void _init() {
        this.buffer = jEdit.getActiveView().getBuffer();
        String string = this.buffer.getName();
        this.setName("Buffer: " + string);
        this.addComponent(GUIUtilities.createMultilineLabel(jEdit.getProperty("buffer-options.caption")));
        this.addSeparator("buffer-options.loading-saving");
        String[] stringArray = new String[]{jEdit.getProperty("lineSep.unix"), jEdit.getProperty("lineSep.windows"), jEdit.getProperty("lineSep.mac")};
        this.lineSeparator = new JComboBox<String>(stringArray);
        String string2 = this.buffer.getStringProperty("lineSeparator");
        if (string2 == null) {
            string2 = System.getProperty("line.separator");
        }
        if ("\n".equals(string2)) {
            this.lineSeparator.setSelectedIndex(0);
        } else if ("\r\n".equals(string2)) {
            this.lineSeparator.setSelectedIndex(1);
        } else if ("\r".equals(string2)) {
            this.lineSeparator.setSelectedIndex(2);
        }
        this.addComponent(jEdit.getProperty("buffer-options.lineSeparator"), this.lineSeparator);
        String[] stringArray2 = MiscUtilities.getEncodings(true);
        Arrays.sort(stringArray2, new StandardUtilities.StringCompare(true));
        this.encoding = new JComboBox<String>(stringArray2);
        this.encoding.setEditable(true);
        this.encoding.setSelectedItem(this.buffer.getStringProperty("encoding"));
        this.addComponent(jEdit.getProperty("buffer-options.encoding"), this.encoding);
        this.gzipped = new JCheckBox(jEdit.getProperty("buffer-options.gzipped"));
        this.gzipped.setSelected(this.buffer.getBooleanProperty("gzipped"));
        this.addComponent(this.gzipped);
        String[] stringArray3 = new String[]{jEdit.getProperty("options.general.checkModStatus.nothing"), jEdit.getProperty("options.general.checkModStatus.prompt"), jEdit.getProperty("options.general.checkModStatus.reload"), jEdit.getProperty("options.general.checkModStatus.silentReload")};
        this.checkModStatus = new JComboBox<String>(stringArray3);
        if (this.buffer.getAutoReload()) {
            if (this.buffer.getAutoReloadDialog()) {
                this.checkModStatus.setSelectedIndex(2);
            } else {
                this.checkModStatus.setSelectedIndex(3);
            }
        } else if (this.buffer.getAutoReloadDialog()) {
            this.checkModStatus.setSelectedIndex(1);
        } else {
            this.checkModStatus.setSelectedIndex(0);
        }
        this.addComponent(jEdit.getProperty("options.general.checkModStatus"), this.checkModStatus);
        this.addSeparator("buffer-options.editing");
        this.modes = jEdit.getModes();
        Arrays.sort(this.modes, new StandardUtilities.StringCompare(true));
        this.mode = new JComboBox<Mode>(this.modes);
        this.mode.setSelectedItem(this.buffer.getMode());
        ActionHandler actionHandler = new ActionHandler();
        this.mode.addActionListener(actionHandler);
        this.addComponent(jEdit.getProperty("buffer-options.mode"), this.mode);
        String[] stringArray4 = FoldHandler.getFoldModes();
        this.folding = new JComboBox<String>(stringArray4);
        this.folding.setSelectedItem(this.buffer.getStringProperty("folding"));
        this.addComponent(jEdit.getProperty("options.editing.folding"), this.folding);
        String[] stringArray5 = new String[]{"none", "simple", "full"};
        this.autoIndent = new JComboBox<String>(stringArray5);
        this.autoIndent.setSelectedItem(this.buffer.getStringProperty("autoIndent"));
        this.addComponent(jEdit.getProperty("options.editing.autoIndent"), this.autoIndent);
        String[] stringArray6 = new String[]{"none", "soft", "hard"};
        this.wrap = new JComboBox<String>(stringArray6);
        this.wrap.setSelectedItem(this.buffer.getStringProperty("wrap"));
        this.addComponent(jEdit.getProperty("options.editing.wrap"), this.wrap);
        String[] stringArray7 = new String[]{"0", "72", "76", "80"};
        this.maxLineLen = new JComboBox<String>(stringArray7);
        this.maxLineLen.setEditable(true);
        this.maxLineLen.setSelectedItem(this.buffer.getStringProperty("maxLineLen"));
        this.addComponent(jEdit.getProperty("options.editing.maxLineLen"), this.maxLineLen);
        String[] stringArray8 = new String[]{"2", "4", "8"};
        this.tabSize = new JComboBox<String>(stringArray8);
        this.tabSize.setEditable(true);
        this.tabSize.setSelectedItem(this.buffer.getStringProperty("tabSize"));
        this.addComponent(jEdit.getProperty("options.editing.tabSize"), this.tabSize);
        this.indentSize = new JComboBox<String>(stringArray8);
        this.indentSize.setEditable(true);
        this.indentSize.setSelectedItem(this.buffer.getStringProperty("indentSize"));
        this.addComponent(jEdit.getProperty("options.editing.indentSize"), this.indentSize);
        this.noTabs = new JCheckBox(jEdit.getProperty("options.editing.noTabs"));
        this.noTabs.setSelected(this.buffer.getBooleanProperty("noTabs"));
        this.addComponent(this.noTabs);
        this.elasticTabstops = new JCheckBox(jEdit.getProperty("options.editing.elasticTabstops"));
        this.elasticTabstops.setToolTipText(jEdit.getProperty("options.editing.elasticTabstops.tooltip"));
        this.elasticTabstops.setSelected(this.buffer.getBooleanProperty("elasticTabstops"));
        this.addComponent(this.elasticTabstops);
        this.locked = new JCheckBox(jEdit.getProperty("buffer-options.locked"));
        this.locked.setSelected(this.buffer.getBooleanProperty("locked"));
        this.addComponent(this.locked);
    }

    @Override
    protected void _save() {
        boolean bl;
        boolean bl2;
        String string;
        int n = this.lineSeparator.getSelectedIndex();
        if (n == 0) {
            string = "\n";
        } else if (n == 1) {
            string = "\r\n";
        } else if (n == 2) {
            string = "\r";
        } else {
            throw new InternalError();
        }
        String string2 = this.buffer.getStringProperty("lineSeparator");
        if (string2 == null) {
            string2 = System.getProperty("line.separator");
        }
        if (!string2.equals(string)) {
            this.buffer.setStringProperty("lineSeparator", string);
            this.buffer.setDirty(true);
        }
        String string3 = (String)this.encoding.getSelectedItem();
        String string4 = this.buffer.getStringProperty("encoding");
        if (!string4.equals(string3)) {
            this.buffer.setStringProperty("encoding", string3);
            this.buffer.setDirty(true);
            this.buffer.setBooleanProperty("encodingAutodetect", false);
        }
        if ((bl2 = this.gzipped.isSelected()) != (bl = this.buffer.getBooleanProperty("gzipped"))) {
            this.buffer.setBooleanProperty("gzipped", bl2);
            this.buffer.setDirty(true);
        }
        this.buffer.setStringProperty("folding", (String)this.folding.getSelectedItem());
        this.buffer.setStringProperty("wrap", (String)this.wrap.getSelectedItem());
        try {
            this.buffer.setProperty("maxLineLen", Integer.valueOf(this.maxLineLen.getSelectedItem().toString()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.buffer.setProperty("tabSize", Integer.valueOf(this.tabSize.getSelectedItem().toString()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.buffer.setProperty("indentSize", Integer.valueOf(this.indentSize.getSelectedItem().toString()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.buffer.setBooleanProperty("noTabs", this.noTabs.isSelected());
        this.buffer.setBooleanProperty("elasticTabstops", this.elasticTabstops.isSelected());
        this.buffer.setStringProperty("autoIndent", (String)this.autoIndent.getSelectedItem());
        this.buffer.setBooleanProperty("locked", this.locked.isSelected());
        n = this.mode.getSelectedIndex();
        this.buffer.setMode(this.modes[n]);
        switch (this.checkModStatus.getSelectedIndex()) {
            case 0: {
                this.buffer.setAutoReloadDialog(false);
                this.buffer.setAutoReload(false);
                break;
            }
            case 1: {
                this.buffer.setAutoReloadDialog(true);
                this.buffer.setAutoReload(false);
                break;
            }
            case 2: {
                this.buffer.setAutoReloadDialog(true);
                this.buffer.setAutoReload(true);
                break;
            }
            case 3: {
                this.buffer.setAutoReloadDialog(false);
                this.buffer.setAutoReload(true);
            }
        }
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == BufferOptionPane.this.mode) {
                Mode mode = (Mode)BufferOptionPane.this.mode.getSelectedItem();
                BufferOptionPane.this.folding.setSelectedItem(mode.getProperty("folding"));
                BufferOptionPane.this.wrap.setSelectedItem(mode.getProperty("wrap"));
                BufferOptionPane.this.maxLineLen.setSelectedItem(mode.getProperty("maxLineLen"));
                BufferOptionPane.this.tabSize.setSelectedItem(mode.getProperty("tabSize"));
                BufferOptionPane.this.indentSize.setSelectedItem(mode.getProperty("indentSize"));
                BufferOptionPane.this.noTabs.setSelected(mode.getBooleanProperty("noTabs"));
                BufferOptionPane.this.elasticTabstops.setSelected(mode.getBooleanProperty("elasticTabstops"));
            }
        }
    }
}

