/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.syntax;

import java.util.ArrayList;
import javax.swing.text.Segment;
import org.gjt.sp.jedit.syntax.SyntaxUtilities;

public class KeywordMap {
    private final int mapLength;
    private final Keyword[] map;
    private boolean ignoreCase;
    private StringBuilder noWordSep;

    public KeywordMap(boolean bl) {
        this(bl, 52);
        this.ignoreCase = bl;
        this.noWordSep = new StringBuilder();
    }

    public KeywordMap(boolean bl, int n) {
        this.mapLength = n;
        this.ignoreCase = bl;
        this.map = new Keyword[n];
    }

    public byte lookup(Segment segment, int n, int n2) {
        if (n2 == 0) {
            return 0;
        }
        Keyword keyword = this.map[this.getSegmentMapKey(segment, n, n2)];
        while (keyword != null) {
            if (n2 != keyword.keyword.length) {
                keyword = keyword.next;
                continue;
            }
            if (SyntaxUtilities.regionMatches(this.ignoreCase, segment, n, keyword.keyword)) {
                return keyword.id;
            }
            keyword = keyword.next;
        }
        return 0;
    }

    public void add(String string, byte by) {
        this.add(string.toCharArray(), by);
    }

    public void add(char[] cArray, byte by) {
        int n = this.getStringMapKey(cArray);
        block0: for (char c : cArray) {
            if (Character.isLetterOrDigit(c)) continue;
            for (int i = 0; i < this.noWordSep.length(); ++i) {
                if (this.noWordSep.charAt(i) == c) continue block0;
            }
            this.noWordSep.append(c);
        }
        this.map[n] = new Keyword(cArray, by, this.map[n]);
    }

    public String getNonAlphaNumericChars() {
        return this.noWordSep.toString();
    }

    public String[] getKeywords() {
        ArrayList<String> arrayList = new ArrayList<String>(100);
        Object[] objectArray = this.map;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Keyword keyword;
            Keyword keyword2 = keyword = objectArray[i];
            while (keyword2 != null) {
                arrayList.add(new String(keyword2.keyword));
                keyword2 = keyword2.next;
            }
        }
        objectArray = new String[arrayList.size()];
        arrayList.toArray(objectArray);
        return objectArray;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean bl) {
        this.ignoreCase = bl;
    }

    public void add(KeywordMap keywordMap) {
        for (int i = 0; i < keywordMap.map.length; ++i) {
            Keyword keyword = keywordMap.map[i];
            while (keyword != null) {
                this.add(keyword.keyword, keyword.id);
                keyword = keyword.next;
            }
        }
    }

    private int getStringMapKey(char[] cArray) {
        return (Character.toUpperCase(cArray[0]) + Character.toUpperCase(cArray[cArray.length - 1])) % this.mapLength;
    }

    protected int getSegmentMapKey(Segment segment, int n, int n2) {
        return (Character.toUpperCase(segment.array[n]) + Character.toUpperCase(segment.array[n + n2 - 1])) % this.mapLength;
    }

    private static class Keyword {
        public char[] keyword;
        public byte id;
        public Keyword next;

        Keyword(char[] cArray, byte by, Keyword keyword) {
            this.keyword = cArray;
            this.id = by;
            this.next = keyword;
        }
    }
}

