/*
 * Decompiled with CFR 0.152.
 */
package org.jedit.keymap;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.util.IOUtilities;
import org.gjt.sp.util.Log;
import org.jedit.keymap.Keymap;
import org.jedit.keymap.KeymapManagerImpl;

class KeymapImpl
implements Keymap {
    protected Properties props;
    protected final String name;
    private final File file;
    private boolean modified;

    KeymapImpl(String string, File file) {
        this.name = string;
        this.file = file;
        this.loadProperties();
    }

    protected InputStream getInputStream() {
        return Keymap.class.getResourceAsStream(this.name + "_keys.props");
    }

    private void loadProperties() {
        this.props = new Properties();
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(this.file));){
            this.props.load(bufferedInputStream);
        }
        catch (IOException iOException) {
            Log.log(9, this, "Unable to load properties", iOException);
        }
    }

    @Override
    public String getShortcut(String string) {
        String string2 = this.props.getProperty(string);
        return string2;
    }

    @Override
    public void setShortcut(String string, String string2) {
        if (string2 == null || string2.isEmpty()) {
            if (this.props.containsKey(string)) {
                this.modified = true;
                this.props.remove(string);
            }
            return;
        }
        String string3 = this.props.getProperty(string);
        if (!string2.equals(string3)) {
            this.modified = true;
            this.props.setProperty(string, string2);
        }
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Keymap)) {
            return false;
        }
        Keymap keymap = (Keymap)object;
        return this.name.equals(keymap.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save() {
        if (this.modified) {
            this.modified = false;
            File file = KeymapManagerImpl.getUserKeymapFile(this.name);
            file.getParentFile().mkdirs();
            BufferedOutputStream bufferedOutputStream = null;
            try {
                bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                MiscUtilities.storeProperties(this.props, bufferedOutputStream, "jEdit's keymap " + this.name);
            }
            catch (IOException iOException) {
                try {
                    Log.log(9, this, "Unable to save properties", iOException);
                }
                catch (Throwable throwable) {
                    IOUtilities.closeQuietly(bufferedOutputStream);
                    throw throwable;
                }
                IOUtilities.closeQuietly(bufferedOutputStream);
            }
            IOUtilities.closeQuietly(bufferedOutputStream);
        }
    }
}

