/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.impl.projectlevelman.AllVcses;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsAbstractSetting {
    protected final String myDisplayName;
    private final Collection<String> myApplicable = new HashSet<String>();

    protected VcsAbstractSetting(String displayName) {
        this.myDisplayName = displayName;
    }

    public String getDisplayName() {
        return this.myDisplayName;
    }

    public void addApplicableVcs(AbstractVcs vcs) {
        if (vcs != null) {
            this.myApplicable.add(vcs.getName());
        }
    }

    public boolean isApplicableTo(Collection<? extends AbstractVcs> vcs) {
        for (AbstractVcs abstractVcs : vcs) {
            if (!this.myApplicable.contains(abstractVcs.getName())) continue;
            return true;
        }
        return false;
    }

    public List<AbstractVcs> getApplicableVcses(@NotNull Project project) {
        if (project == null) {
            VcsAbstractSetting.$$$reportNull$$$0(0);
        }
        return ContainerUtil.mapNotNull(this.myApplicable, name -> AllVcses.getInstance(project).getByName(name));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/vcs/VcsAbstractSetting", "getApplicableVcses"));
    }
}

