/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.zip;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.zip.JBZipEntry;
import com.intellij.util.io.zip.JBZipFile;
import com.intellij.util.io.zip.ZipShort;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ReorderJarsMain {
    private ReorderJarsMain() {
    }

    public static void main(String[] args) {
        try {
            String orderTxtPath = args[0];
            String jarsPath = args[1];
            String destinationPath = args[2];
            String libPath = args.length > 3 ? args[3] : null;
            Map<String, List<String>> toReorder = ReorderJarsMain.getOrder(new File(orderTxtPath));
            Set<Object> ignoredJars = libPath == null ? Collections.emptySet() : ReorderJarsMain.loadIgnoredJars(libPath);
            for (String jarUrl : toReorder.keySet()) {
                if (ignoredJars.contains(StringUtil.trimStart(jarUrl, "/lib/")) || jarUrl.startsWith("/lib/ant")) {
                    System.out.println("Ignored jar: " + jarUrl);
                    continue;
                }
                File jarFile = new File(jarsPath, jarUrl);
                if (!jarFile.isFile()) {
                    System.out.println("Cannot find jar: " + jarUrl);
                    continue;
                }
                System.out.println("Reorder jar: " + jarUrl);
                JBZipFile zipFile = new JBZipFile(jarFile);
                List<JBZipEntry> entries = zipFile.getEntries();
                List<String> orderedEntries = toReorder.get(jarUrl);
                assert (orderedEntries.size() <= Short.MAX_VALUE) : jarUrl;
                entries.sort((o1, o2) -> {
                    if ("META-INF/plugin.xml".equals(o2.getName())) {
                        return Integer.MAX_VALUE;
                    }
                    if ("META-INF/plugin.xml".equals(o1.getName())) {
                        return -2147483647;
                    }
                    if (orderedEntries.contains(o1.getName())) {
                        return orderedEntries.contains(o2.getName()) ? orderedEntries.indexOf(o1.getName()) - orderedEntries.indexOf(o2.getName()) : -1;
                    }
                    return orderedEntries.contains(o2.getName()) ? 1 : 0;
                });
                File tempJarFile = FileUtil.createTempFile("__reorder__", "__reorder__", true);
                JBZipFile file = new JBZipFile(tempJarFile);
                JBZipEntry sizeEntry = file.getOrCreateEntry("META-INF/jb/$$size$$");
                sizeEntry.setData(ZipShort.getBytes(orderedEntries.size()));
                for (JBZipEntry entry : entries) {
                    JBZipEntry zipEntry = file.getOrCreateEntry(entry.getName());
                    zipEntry.setData(entry.getData());
                }
                file.close();
                File resultJarFile = new File(destinationPath, jarUrl);
                File resultDir = resultJarFile.getParentFile();
                if (!resultDir.isDirectory() && !resultDir.mkdirs()) {
                    throw new IOException("Cannot create: " + resultDir);
                }
                try {
                    FileUtil.rename(tempJarFile, resultJarFile);
                }
                catch (Exception e) {
                    FileUtil.delete(resultJarFile);
                    throw e;
                }
                FileUtil.delete(tempJarFile);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static Set<String> loadIgnoredJars(String libPath) throws IOException {
        File ignoredJarsFile = new File(libPath, "required_for_dist.txt");
        HashSet<String> ignoredJars = new HashSet<String>();
        ContainerUtil.addAll(ignoredJars, FileUtil.loadFile(ignoredJarsFile).split("\r\n"));
        return ignoredJars;
    }

    private static Map<String, List<String>> getOrder(File loadingFile) throws IOException {
        String[] lines;
        HashMap<String, List<String>> entriesOrder = new HashMap<String, List<String>>();
        for (String line : lines = FileUtil.loadFile(loadingFile).split("\n")) {
            int i = (line = line.trim()).indexOf(":");
            if (i == -1) continue;
            String entry = line.substring(0, i);
            String jarUrl = line.substring(i + 1);
            ArrayList<String> entries = (ArrayList<String>)entriesOrder.get(jarUrl);
            if (entries == null) {
                entries = new ArrayList<String>();
                entriesOrder.put(jarUrl, entries);
            }
            entries.add(entry);
        }
        return entriesOrder;
    }
}

