/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.CharsetToolkit;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TargetedCommandLineBuilder
extends UserDataHolderBase {
    @NotNull
    private TargetValue<String> myExePath;
    @NotNull
    private TargetValue<String> myWorkingDirectory;
    @NotNull
    private TargetValue<String> myInputFilePath;
    @NotNull
    private Charset myCharset;
    @NotNull
    private final List<TargetValue<String>> myParameters;
    @NotNull
    private final Map<String, TargetValue<String>> myEnvironment;
    @NotNull
    private final Set<File> myFilesToDeleteOnTermination;
    @NotNull
    private final TargetEnvironmentRequest myRequest;

    public TargetedCommandLineBuilder(@NotNull TargetEnvironmentRequest request) {
        if (request == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(0);
        }
        this.myExePath = TargetValue.empty();
        this.myWorkingDirectory = TargetValue.empty();
        this.myInputFilePath = TargetValue.empty();
        this.myCharset = CharsetToolkit.getDefaultSystemCharset();
        this.myParameters = new ArrayList<TargetValue<String>>();
        this.myEnvironment = new HashMap<String, TargetValue<String>>();
        this.myFilesToDeleteOnTermination = new HashSet<File>();
        this.myRequest = request;
    }

    @NotNull
    public TargetEnvironmentRequest getRequest() {
        TargetEnvironmentRequest targetEnvironmentRequest = this.myRequest;
        if (targetEnvironmentRequest == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(1);
        }
        return targetEnvironmentRequest;
    }

    @NotNull
    public TargetedCommandLine build() {
        return new TargetedCommandLine(this.myExePath, this.myWorkingDirectory, this.myInputFilePath, this.myCharset, new ArrayList<TargetValue<String>>(this.myParameters), new HashMap<String, TargetValue<String>>(this.myEnvironment));
    }

    public void setCharset(@NotNull Charset charset) {
        if (charset == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(2);
        }
        this.myCharset = charset;
    }

    public void setExePath(@NotNull TargetValue<String> exePath) {
        if (exePath == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(3);
        }
        this.myExePath = exePath;
    }

    public void setExePath(@NotNull String exePath) {
        if (exePath == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(4);
        }
        this.myExePath = TargetValue.fixed(exePath);
    }

    public void setWorkingDirectory(@NotNull TargetValue<String> workingDirectory) {
        if (workingDirectory == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(5);
        }
        this.myWorkingDirectory = workingDirectory;
    }

    public void addParameter(@NotNull TargetValue<String> parameter) {
        if (parameter == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(6);
        }
        this.myParameters.add(parameter);
    }

    public void addParameter(@NotNull String parameter) {
        if (parameter == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(7);
        }
        this.myParameters.add(TargetValue.fixed(parameter));
    }

    public void addParameters(@NotNull List<String> parametersList) {
        if (parametersList == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(8);
        }
        for (String parameter : parametersList) {
            this.addParameter(parameter);
        }
    }

    public void addParameters(String ... parametersList) {
        if (parametersList == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(9);
        }
        for (String parameter : parametersList) {
            this.addParameter(parameter);
        }
    }

    public void addParameterAt(int index, @NotNull String parameter) {
        if (parameter == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(10);
        }
        this.addParameterAt(index, TargetValue.fixed(parameter));
    }

    public void addParameterAt(int index, @NotNull TargetValue<String> parameter) {
        if (parameter == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(11);
        }
        this.myParameters.add(index, parameter);
    }

    public void addEnvironmentVariable(@NotNull String name, @Nullable TargetValue<String> value) {
        if (name == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(12);
        }
        if (value != null) {
            this.myEnvironment.put(name, value);
        } else {
            this.myEnvironment.remove(name);
        }
    }

    public void addEnvironmentVariable(@NotNull String name, @Nullable String value) {
        if (name == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(13);
        }
        this.addEnvironmentVariable(name, value != null ? TargetValue.fixed(value) : null);
    }

    public void removeEnvironmentVariable(@NotNull String name) {
        if (name == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(14);
        }
        this.myEnvironment.remove(name);
    }

    public void addFileToDeleteOnTermination(@NotNull File file) {
        if (file == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(15);
        }
        this.myFilesToDeleteOnTermination.add(file);
    }

    public void setInputFile(@NotNull TargetValue<String> inputFilePath) {
        if (inputFilePath == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(16);
        }
        this.myInputFilePath = inputFilePath;
    }

    @NotNull
    public Set<File> getFilesToDeleteOnTermination() {
        Set<File> set = this.myFilesToDeleteOnTermination;
        if (set == null) {
            TargetedCommandLineBuilder.$$$reportNull$$$0(17);
        }
        return set;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/target/TargetedCommandLineBuilder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDirectory";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersList";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputFilePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/target/TargetedCommandLineBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRequest";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesToDeleteOnTermination";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 17: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setCharset";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setExePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setWorkingDirectory";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addParameter";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addParameters";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addParameterAt";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addEnvironmentVariable";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "removeEnvironmentVariable";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addFileToDeleteOnTermination";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setInputFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

