/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerImpl;
import com.intellij.codeInsight.daemon.impl.IntentionsUI;
import com.intellij.codeInsight.daemon.impl.ShowIntentionsPass;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionDelegate;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CachedIntentions;
import com.intellij.codeInsight.intention.impl.IntentionHintComponent;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewEditor;
import com.intellij.codeInsight.intention.impl.preview.IntentionPreviewUnsupportedOperationException;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.featureStatistics.FeatureUsageTrackerImpl;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.internal.statistic.IntentionsCollector;
import com.intellij.lang.LangBundle;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.util.PairProcessor;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowIntentionActionsHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(2);
        }
        this.invoke(project, editor, file2, false);
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, boolean showFeedbackOnEmptyMenu) {
        LookupEx lookup2;
        if (project == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(5);
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        if (editor instanceof EditorWindow) {
            editor = ((EditorWindow)editor).getDelegate();
            file2 = InjectedLanguageManager.getInstance((Project)file2.getProject()).getTopLevelFile((PsiElement)file2);
        }
        if ((lookup2 = LookupManager.getActiveLookup(editor)) != null) {
            lookup2.showElementActions(null);
            return;
        }
        if (!LightEdit.owns((Project)project)) {
            DaemonCodeAnalyzerImpl codeAnalyzer = (DaemonCodeAnalyzerImpl)DaemonCodeAnalyzer.getInstance((Project)project);
            ShowIntentionActionsHandler.letAutoImportComplete(editor, file2, codeAnalyzer);
        }
        IntentionsUI.getInstance(project).hide();
        if (HintManagerImpl.getInstanceImpl().performCurrentQuestionAction()) {
            return;
        }
        TemplateState state = TemplateManagerImpl.getTemplateState(editor);
        if (state != null && !state.isFinished()) {
            return;
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        this.showIntentionHint(project, editor, file2, ShowIntentionActionsHandler.calcIntentions(project, editor, file2), showFeedbackOnEmptyMenu);
    }

    protected void showIntentionHint(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2, @NotNull ShowIntentionsPass.IntentionsInfo intentions, boolean showFeedbackOnEmptyMenu) {
        if (project == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(6);
        }
        if (editor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(7);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(8);
        }
        if (intentions == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(9);
        }
        if (!intentions.isEmpty()) {
            editor.getScrollingModel().runActionOnScrollingFinished(() -> {
                CachedIntentions cachedIntentions = CachedIntentions.createAndUpdateActions(project, file2, editor, intentions);
                IntentionHintComponent.showIntentionHint(project, file2, editor, true, cachedIntentions);
            });
        } else if (showFeedbackOnEmptyMenu) {
            HintManager.getInstance().showInformationHint(editor, LangBundle.message((String)"hint.text.no.context.actions.available.at.this.location", (Object[])new Object[0]));
        }
    }

    @NotNull
    @ApiStatus.Internal
    public static ShowIntentionsPass.IntentionsInfo calcIntentions(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(11);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(12);
        }
        ShowIntentionsPass.IntentionsInfo intentions = (ShowIntentionsPass.IntentionsInfo)ActionUtil.underModalProgress((Project)project, (String)CodeInsightBundle.message((String)"progress.title.searching.for.context.actions", (Object[])new Object[0]), () -> ShowIntentionsPass.getActionsToShow(editor, file2, false));
        ShowIntentionsPass.getActionsToShowSync(editor, file2, intentions);
        ShowIntentionsPass.IntentionsInfo intentionsInfo = intentions;
        if (intentionsInfo == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(13);
        }
        return intentionsInfo;
    }

    private static void letAutoImportComplete(@NotNull Editor editor, @NotNull PsiFile file2, DaemonCodeAnalyzerImpl codeAnalyzer) {
        if (editor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(14);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(15);
        }
        CommandProcessor.getInstance().runUndoTransparentAction(() -> codeAnalyzer.autoImportReferenceAtCursor(editor, file2));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public static boolean availableFor(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull IntentionAction action2) {
        if (psiFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(16);
        }
        if (editor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(17);
        }
        if (action2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(18);
        }
        if (!psiFile.isValid()) {
            return false;
        }
        try {
            Project project = psiFile.getProject();
            action2 = IntentionActionDelegate.unwrap((IntentionAction)action2);
            if (LightEdit.owns((Project)project) && !(action2 instanceof LightEditCompatible)) {
                return false;
            }
            if (action2 instanceof SuppressIntentionActionFromFix) {
                ThreeState shouldBeAppliedToInjectionHost = ((SuppressIntentionActionFromFix)action2).isShouldBeAppliedToInjectionHost();
                if (editor instanceof EditorWindow && shouldBeAppliedToInjectionHost == ThreeState.YES) {
                    return false;
                }
                if (!(editor instanceof EditorWindow) && shouldBeAppliedToInjectionHost == ThreeState.NO) {
                    return false;
                }
            }
            if (action2 instanceof PsiElementBaseIntentionAction) {
                PsiElementBaseIntentionAction psiAction = (PsiElementBaseIntentionAction)action2;
                if (!psiAction.checkFile(psiFile)) {
                    return false;
                }
                PsiElement leaf = psiFile.findElementAt(editor.getCaretModel().getOffset());
                if (leaf == null || !psiAction.isAvailable(project, editor, leaf)) {
                    return false;
                }
            } else if (!action2.isAvailable(project, editor, psiFile)) {
                return false;
            }
        }
        catch (IndexNotReadyException e) {
            return false;
        }
        catch (IntentionPreviewUnsupportedOperationException e) {
            return false;
        }
        return true;
    }

    @Nullable
    public static Pair<PsiFile, Editor> chooseBetweenHostAndInjected(@NotNull PsiFile hostFile, @NotNull Editor hostEditor, @Nullable PsiFile injectedFile, @NotNull PairProcessor<? super PsiFile, ? super Editor> predicate) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(19);
        }
        if (hostEditor == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(20);
        }
        if (predicate == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(21);
        }
        try {
            Editor editorToApply = null;
            PsiFile fileToApply = null;
            Editor injectedEditor = null;
            if (injectedFile != null && !(hostEditor instanceof IntentionPreviewEditor) && predicate.process((Object)injectedFile, (Object)(injectedEditor = InjectedLanguageUtil.getInjectedEditorForInjectedFile(hostEditor, injectedFile)))) {
                editorToApply = injectedEditor;
                fileToApply = injectedFile;
            }
            if (editorToApply == null && hostEditor != injectedEditor && predicate.process((Object)hostFile, (Object)hostEditor)) {
                editorToApply = hostEditor;
                fileToApply = hostFile;
            }
            if (editorToApply == null) {
                return null;
            }
            return Pair.create(fileToApply, editorToApply);
        }
        catch (IntentionPreviewUnsupportedOperationException e) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw e;
            }
            return null;
        }
    }

    public static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull IntentionAction action2, @NotNull String commandName) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(22);
        }
        if (action2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(23);
        }
        if (commandName == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(24);
        }
        Project project = hostFile.getProject();
        return ShowIntentionActionsHandler.chooseActionAndInvoke(hostFile, hostEditor, action2, commandName, project);
    }

    static boolean chooseActionAndInvoke(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull IntentionAction action2, @NotNull String commandName, @NotNull Project project) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(25);
        }
        if (action2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(26);
        }
        if (commandName == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(27);
        }
        if (project == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(28);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.quickFix");
        ((FeatureUsageTrackerImpl)FeatureUsageTracker.getInstance()).getFixesStats().registerInvocation();
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        Pair<PsiFile, Editor> pair = ShowIntentionActionsHandler.chooseFileForAction(hostFile, hostEditor, action2);
        if (pair == null) {
            return false;
        }
        CommandProcessor.getInstance().executeCommand(project, () -> ShowIntentionActionsHandler.invokeIntention(action2, (Editor)pair.second, (PsiFile)pair.first), commandName, null);
        ShowIntentionActionsHandler.checkPsiTextConsistency(hostFile);
        return true;
    }

    private static void checkPsiTextConsistency(@NotNull PsiFile hostFile) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(29);
        }
        if ((Registry.is((String)"ide.check.stub.text.consistency") || ApplicationManager.getApplication().isUnitTestMode() && !ApplicationInfoImpl.isInStressTest()) && hostFile.isValid()) {
            StubTextInconsistencyException.checkStubTextConsistency(hostFile);
        }
    }

    private static void invokeIntention(@NotNull IntentionAction action2, @Nullable Editor editor, @NotNull PsiFile file2) {
        if (action2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(30);
        }
        if (file2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(31);
        }
        IntentionsCollector.record(file2.getProject(), action2, file2.getLanguage());
        PsiElement elementToMakeWritable = action2.getElementToMakeWritable(file2);
        if (elementToMakeWritable != null && !FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{elementToMakeWritable})) {
            return;
        }
        if (action2.startInWriteAction()) {
            WriteAction.run(() -> action2.invoke(file2.getProject(), editor, file2));
        } else {
            action2.invoke(file2.getProject(), editor, file2);
        }
    }

    @Nullable
    public static Pair<PsiFile, Editor> chooseFileForAction(@NotNull PsiFile hostFile, @Nullable Editor hostEditor, @NotNull IntentionAction action2) {
        if (hostFile == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(32);
        }
        if (action2 == null) {
            ShowIntentionActionsHandler.$$$reportNull$$$0(33);
        }
        if (hostEditor == null) {
            return Pair.create((Object)hostFile, null);
        }
        PsiFile injectedFile = InjectedLanguageUtil.findInjectedPsiNoCommit(hostFile, hostEditor.getCaretModel().getOffset());
        return ShowIntentionActionsHandler.chooseBetweenHostAndInjected(hostFile, hostEditor, injectedFile, (PairProcessor<? super PsiFile, ? super Editor>)((PairProcessor)(psiFile, editor) -> ShowIntentionActionsHandler.availableFor(psiFile, editor, action2)));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 11: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 12: 
            case 15: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "intentions";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 18: 
            case 23: 
            case 26: 
            case 30: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 19: 
            case 22: 
            case 25: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostFile";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hostEditor";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
            case 24: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/intention/impl/ShowIntentionActionsHandler";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "calcIntentions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showIntentionHint";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "calcIntentions";
                break;
            }
            case 13: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "letAutoImportComplete";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "availableFor";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "chooseBetweenHostAndInjected";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "chooseActionAndInvoke";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiTextConsistency";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "invokeIntention";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "chooseFileForAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

