/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.LangBundle;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.lang.documentation.ExternalDocumentationHandler;
import com.intellij.lang.documentation.ExternalDocumentationProvider;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalJavaDocAction
extends AnAction {
    public ExternalJavaDocAction() {
        this.setInjectedContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement originalElement;
        DataContext dataContext;
        Project project;
        if (e == null) {
            ExternalJavaDocAction.$$$reportNull$$$0(0);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext = e.getDataContext())) == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiElement element2 = ExternalJavaDocAction.getElement(dataContext, editor, originalElement = ExternalJavaDocAction.getOriginalElement(dataContext, editor));
        if (element2 == null) {
            Messages.showMessageDialog((Project)project, (String)IdeBundle.message((String)"message.please.select.element.for.javadoc", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.no.element.selected", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            return;
        }
        ExternalJavaDocAction.showExternalJavadoc(element2, originalElement, null, dataContext);
    }

    public static void showExternalJavadoc(PsiElement element2, PsiElement originalElement, String docUrl, DataContext dataContext) {
        DocumentationProvider provider = DocumentationManager.getProviderFromElement(element2);
        if (provider instanceof ExternalDocumentationHandler && ((ExternalDocumentationHandler)provider).handleExternal(element2, originalElement)) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.javadoc.external");
        Project project = (Project)dataContext.getData(CommonDataKeys.PROJECT);
        Component contextComponent = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            List<String> urls = StringUtil.isEmptyOrSpaces((String)docUrl) ? (List<String>)ReadAction.compute(() -> provider.getUrlFor(element2, originalElement)) : Collections.singletonList(docUrl);
            if (provider instanceof ExternalDocumentationProvider && urls != null && urls.size() > 1) {
                for (String url : urls) {
                    List<String> thisUrlList = Collections.singletonList(url);
                    String doc = ((ExternalDocumentationProvider)provider).fetchExternalDocumentation(project, element2, thisUrlList, false);
                    if (doc == null) continue;
                    urls = thisUrlList;
                    break;
                }
            }
            List<String> finalUrls = urls;
            ApplicationManager.getApplication().invokeLater(() -> {
                if (ContainerUtil.isEmpty((Collection)finalUrls)) {
                    ExternalDocumentationProvider externalDocumentationProvider;
                    if (element2 != null && provider instanceof ExternalDocumentationProvider && (externalDocumentationProvider = (ExternalDocumentationProvider)provider).canPromptToConfigureDocumentation(element2)) {
                        externalDocumentationProvider.promptToConfigureDocumentation(element2);
                    }
                } else if (finalUrls.size() == 1) {
                    BrowserUtil.browse((String)((String)finalUrls.get(0)));
                } else {
                    JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>(LangBundle.message((String)"popup.title.choose.external.documentation.root", (Object[])new Object[0]), ArrayUtilRt.toStringArray((Collection)finalUrls)){

                        public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                            BrowserUtil.browse((String)selectedValue);
                            return FINAL_CHOICE;
                        }
                    }).showInBestPositionFor(DataManager.getInstance().getDataContext(contextComponent));
                }
            }, ModalityState.NON_MODAL);
        });
    }

    @Nullable
    private static PsiElement getOriginalElement(@NotNull DataContext dataContext, @Nullable Editor editor) {
        PsiFile file2;
        if (dataContext == null) {
            ExternalJavaDocAction.$$$reportNull$$$0(1);
        }
        return (file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext)) != null && editor != null ? file2.findElementAt(editor.getCaretModel().getOffset()) : null;
    }

    @Nullable
    private static PsiElement getElement(@NotNull DataContext dataContext, @Nullable Editor editor, @Nullable PsiElement originalElement) {
        if (dataContext == null) {
            ExternalJavaDocAction.$$$reportNull$$$0(2);
        }
        return editor == null || originalElement == null ? (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext) : DocumentationManager.getInstance(originalElement.getProject()).findTargetElement(editor, originalElement.getContainingFile(), originalElement);
    }

    public void update(@NotNull AnActionEvent event) {
        boolean enabled;
        PsiElement originalElement;
        Editor editor;
        if (event == null) {
            ExternalJavaDocAction.$$$reportNull$$$0(3);
        }
        Presentation presentation2 = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        PsiElement element2 = ExternalJavaDocAction.getElement(dataContext, editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext), originalElement = ExternalJavaDocAction.getOriginalElement(dataContext, editor));
        DocumentationProvider provider = DocumentationManager.getProviderFromElement(element2);
        if (provider instanceof ExternalDocumentationProvider) {
            ExternalDocumentationProvider edProvider = (ExternalDocumentationProvider)provider;
            enabled = CompositeDocumentationProvider.hasUrlsFor((DocumentationProvider)provider, (PsiElement)element2, (PsiElement)originalElement) || edProvider.canPromptToConfigureDocumentation(element2);
        } else {
            List urls = provider.getUrlFor(element2, originalElement);
            enabled = urls != null && !urls.isEmpty();
        }
        presentation2.setEnabled(enabled);
        if (editor != null) {
            if (ActionPlaces.isMainMenuOrActionSearch((String)event.getPlace())) {
                presentation2.setVisible(true);
            } else {
                presentation2.setVisible(enabled);
            }
        } else {
            presentation2.setVisible(true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/ExternalJavaDocAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getOriginalElement";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

