/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.plugins;

import com.intellij.ide.plugins.DisabledPluginsState;
import com.intellij.ide.plugins.DynamicPlugins;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginDescriptorLoader;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public final class PluginEnabler {
    private static final Logger LOG = Logger.getInstance(PluginEnabler.class);

    public static boolean enablePlugins(@Nullable Project project, Collection<IdeaPluginDescriptor> plugins, boolean enable) {
        return PluginEnabler.updatePluginEnabledState(project, enable ? plugins : Collections.emptyList(), enable ? Collections.emptyList() : plugins, null);
    }

    public static boolean updatePluginEnabledState(@Nullable Project project, Collection<IdeaPluginDescriptor> pluginsToEnable, Collection<IdeaPluginDescriptor> pluginsToDisable, @Nullable JComponent parentComponent) {
        List<IdeaPluginDescriptorImpl> pluginDescriptorsToEnable = PluginEnabler.loadFullDescriptors(pluginsToEnable);
        List<IdeaPluginDescriptorImpl> pluginDescriptorsToDisable = PluginEnabler.loadFullDescriptors(pluginsToDisable);
        Set<PluginId> disabledIds = DisabledPluginsState.getDisabledIds();
        for (PluginDescriptor pluginDescriptor : pluginsToEnable) {
            pluginDescriptor.setEnabled(true);
            disabledIds.remove(pluginDescriptor.getPluginId());
        }
        for (PluginDescriptor pluginDescriptor : pluginsToDisable) {
            if (!PluginManagerCore.getLoadedPlugins().contains(pluginDescriptor)) {
                pluginDescriptorsToDisable.removeIf(plugin -> plugin.getPluginId().equals(descriptor2.getPluginId()));
            }
            pluginDescriptor.setEnabled(false);
            disabledIds.add(pluginDescriptor.getPluginId());
        }
        try {
            DisabledPluginsState.saveDisabledPlugins(disabledIds, false);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
        if (DynamicPlugins.allowLoadUnloadAllWithoutRestart(pluginDescriptorsToDisable) && DynamicPlugins.allowLoadUnloadAllWithoutRestart(pluginDescriptorsToEnable)) {
            boolean bl;
            List<IdeaPluginDescriptorImpl> sortedDescriptorsToDisable = PluginManagerCore.getPluginsSortedByDependency(pluginDescriptorsToDisable, true);
            Collections.reverse(sortedDescriptorsToDisable);
            boolean bl2 = false;
            for (IdeaPluginDescriptorImpl descriptor3 : sortedDescriptorsToDisable) {
                if (DynamicPlugins.unloadPluginWithProgress(project, parentComponent, descriptor3, new DynamicPlugins.UnloadPluginOptions().withDisable(true))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                boolean bl3;
                List<IdeaPluginDescriptorImpl> sortedDescriptorsToEnable = PluginManagerCore.getPluginsSortedByDependency(pluginDescriptorsToEnable, true);
                for (IdeaPluginDescriptor ideaPluginDescriptor : sortedDescriptorsToEnable) {
                    if (DynamicPlugins.loadPlugin((IdeaPluginDescriptorImpl)ideaPluginDescriptor)) continue;
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    return true;
                }
            }
        }
        InstalledPluginsState.getInstance().setRestartRequired(true);
        return false;
    }

    private static List<IdeaPluginDescriptorImpl> loadFullDescriptors(Collection<IdeaPluginDescriptor> pluginsToEnable) {
        ArrayList<IdeaPluginDescriptorImpl> result2 = new ArrayList<IdeaPluginDescriptorImpl>();
        for (IdeaPluginDescriptor descriptor2 : pluginsToEnable) {
            if (!(descriptor2 instanceof IdeaPluginDescriptorImpl)) continue;
            result2.add(PluginDescriptorLoader.loadFullDescriptor((IdeaPluginDescriptorImpl)descriptor2));
        }
        return result2;
    }
}

