/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;

public final class Launcher {
    private Launcher() {
    }

    public static void main(String[] args) throws InterruptedException {
        String javaVmExecutablePath = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        String classpath = System.getProperty("java.class.path");
        try {
            Process process2 = Runtime.getRuntime().exec("cmd " + javaVmExecutablePath + " -cp " + classpath + " com.intellij.idea.Main");
            new Thread((Runnable)new Redirector(process2.getErrorStream(), System.err), "Redirector err").start();
            new Thread((Runnable)new Redirector(process2.getInputStream(), System.out), "Redirector out").start();
            process2.waitFor();
        }
        catch (IOException e) {
            System.out.println("Can't launch java VM executable: " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("Launcher exited");
    }

    private static class Redirector
    implements Runnable {
        private final InputStream myInput;
        private final PrintStream myOutput;

        Redirector(InputStream input, PrintStream output) {
            this.myInput = input;
            this.myOutput = output;
        }

        @Override
        public void run() {
            InputStreamReader reader = new InputStreamReader(this.myInput, StandardCharsets.UTF_8);
            while (true) {
                int ch = 0;
                try {
                    ch = ((Reader)reader).read();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (ch == -1) break;
                this.myOutput.print((char)ch);
            }
        }
    }
}

