/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.collectors.fus;

import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.internal.statistic.utils.EventRateThrottleResult;
import com.intellij.internal.statistic.utils.EventsRateWindowThrottle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;

public class TypingEventsLogger
implements AnActionListener {
    public static final String GROUP_ID = "editor.typing";
    public static final EventsRateWindowThrottle ourThrottle = new EventsRateWindowThrottle(2000, 3600000L, System.currentTimeMillis());

    public void beforeEditorTyping(char c, @NotNull DataContext dataContext) {
        EventRateThrottleResult result2;
        if (dataContext == null) {
            TypingEventsLogger.$$$reportNull$$$0(0);
        }
        if ((result2 = ourThrottle.tryPass(System.currentTimeMillis())) == EventRateThrottleResult.ACCEPT) {
            TypingEventsLogger.logTypingEvent(dataContext, "typed");
        } else if (result2 == EventRateThrottleResult.DENY_AND_REPORT) {
            TypingEventsLogger.logTypingEvent(dataContext, "too.many.events");
        }
    }

    private static void logTypingEvent(@NotNull DataContext dataContext, @NotNull String eventId) {
        if (dataContext == null) {
            TypingEventsLogger.$$$reportNull$$$0(1);
        }
        if (eventId == null) {
            TypingEventsLogger.$$$reportNull$$$0(2);
        }
        Project project = (Project)PlatformDataKeys.PROJECT_CONTEXT.getData(dataContext);
        FUCounterUsageLogger.getInstance().logEvent(project, GROUP_ID, eventId);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "eventId";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/statistic/collectors/fus/TypingEventsLogger";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "beforeEditorTyping";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "logTypingEvent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

