/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.largeFilesEditor.search;

import com.intellij.largeFilesEditor.editor.LargeFileEditor;
import com.intellij.largeFilesEditor.search.SearchResult;
import com.intellij.largeFilesEditor.search.searchResultsPanel.RangeSearchCallback;
import com.intellij.largeFilesEditor.search.searchTask.FileDataProviderForSearch;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;

public class RangeSearchCallbackImpl
implements RangeSearchCallback {
    private static final Logger LOG = Logger.getInstance(RangeSearchCallbackImpl.class);

    @Override
    public FileDataProviderForSearch getFileDataProviderForSearch(boolean createIfNotExists, Project project, VirtualFile virtualFile) {
        LargeFileEditor largeFileEditor = RangeSearchCallbackImpl.getLargeFileEditor(createIfNotExists, project, virtualFile);
        return largeFileEditor == null ? null : largeFileEditor.getFileDataProviderForSearch();
    }

    @Override
    public void showResultInEditor(SearchResult searchResult, Project project, VirtualFile virtualFile) {
        LargeFileEditor largeFileEditor = RangeSearchCallbackImpl.getLargeFileEditor(true, project, virtualFile);
        if (largeFileEditor == null) {
            Messages.showWarningDialog((String)EditorBundle.message((String)"large.file.editor.message.cant.show.file.in.the.editor", (Object[])new Object[0]), (String)EditorBundle.message((String)"large.file.editor.title.show.match.problem", (Object[])new Object[0]));
            LOG.info("[Large File Editor Subsystem] Can't get LargeFileEditor for showing search result. FilePath=" + virtualFile.getPath());
            return;
        }
        largeFileEditor.showSearchResult(searchResult);
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        fileEditorManager.openFile(virtualFile, false, true);
        fileEditorManager.setSelectedEditor(virtualFile, "LargeFileEditorProvider");
    }

    private static LargeFileEditor getLargeFileEditor(boolean createIfNotExists, Project project, VirtualFile virtualFile) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (createIfNotExists) {
            FileEditor[] fileEditors;
            for (FileEditor fileEditor : fileEditors = fileEditorManager.openFile(virtualFile, false, true)) {
                if (!(fileEditor instanceof LargeFileEditor)) continue;
                return (LargeFileEditor)fileEditor;
            }
        } else {
            FileEditor[] existedFileEditors;
            for (FileEditor fileEditor : existedFileEditors = fileEditorManager.getEditors(virtualFile)) {
                if (!(fileEditor instanceof LargeFileEditor)) continue;
                return (LargeFileEditor)fileEditor;
            }
        }
        return null;
    }
}

