/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm.impl.status.widget;

import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.ide.lightEdit.LightEditCompatible;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.StatusBarWidgetFactory;
import com.intellij.openapi.wm.StatusBarWidgetProvider;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetProviderToFactoryAdapter;
import com.intellij.openapi.wm.impl.status.widget.StatusBarWidgetSettings;
import com.intellij.util.ui.UIUtil;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class StatusBarWidgetsManager
extends SimpleModificationTracker
implements Disposable {
    @NotNull
    private static final Logger LOG = Logger.getInstance(StatusBar.class);
    private final Map<StatusBarWidgetFactory, StatusBarWidget> myWidgetFactories;
    private final Map<String, StatusBarWidgetFactory> myWidgetIdsMap;
    private final Project myProject;

    public StatusBarWidgetsManager(@NotNull Project project) {
        if (project == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(0);
        }
        this.myWidgetFactories = new LinkedHashMap<StatusBarWidgetFactory, StatusBarWidget>();
        this.myWidgetIdsMap = new HashMap<String, StatusBarWidgetFactory>();
        this.myProject = project;
        StatusBarWidgetFactory.EP_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<StatusBarWidgetFactory>(){

            public void extensionAdded(@NotNull StatusBarWidgetFactory factory2, @NotNull PluginDescriptor pluginDescriptor) {
                if (factory2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(1);
                }
                StatusBarWidgetsManager.this.addWidgetFactory(factory2);
            }

            public void extensionRemoved(@NotNull StatusBarWidgetFactory factory2, @NotNull PluginDescriptor pluginDescriptor) {
                if (factory2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(3);
                }
                StatusBarWidgetsManager.this.removeWidgetFactory(factory2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "factory";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsManager$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, (Disposable)this);
        StatusBarWidgetProvider.EP_NAME.getPoint().addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<StatusBarWidgetProvider>(){

            public void extensionAdded(@NotNull StatusBarWidgetProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                if (provider == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(1);
                }
                StatusBarWidgetsManager.this.addWidgetFactory(new StatusBarWidgetProviderToFactoryAdapter(StatusBarWidgetsManager.this.myProject, provider));
            }

            public void extensionRemoved(@NotNull StatusBarWidgetProvider provider, @NotNull PluginDescriptor pluginDescriptor) {
                if (provider == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (pluginDescriptor == null) {
                    2.$$$reportNull$$$0(3);
                }
                StatusBarWidgetsManager.this.removeWidgetFactory(new StatusBarWidgetProviderToFactoryAdapter(StatusBarWidgetsManager.this.myProject, provider));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "provider";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "pluginDescriptor";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsManager$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionAdded";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "extensionRemoved";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }, true, (Disposable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateAllWidgets() {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            for (StatusBarWidgetFactory factory2 : this.myWidgetFactories.keySet()) {
                this.updateWidget(factory2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiStatus.Internal
    public void disableAllWidgets() {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            for (StatusBarWidgetFactory factory2 : this.myWidgetFactories.keySet()) {
                this.disableWidget(factory2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateWidget(@NotNull Class<? extends StatusBarWidgetFactory> factoryExtension) {
        if (factoryExtension == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(1);
        }
        StatusBarWidgetFactory factory2 = (StatusBarWidgetFactory)StatusBarWidgetFactory.EP_NAME.findExtension(factoryExtension);
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            if (factory2 == null || !this.myWidgetFactories.containsKey(factory2)) {
                LOG.info("Factory is not registered as `com.intellij.statusBarWidgetFactory` extension: " + factoryExtension.getName());
                return;
            }
            this.updateWidget(factory2);
        }
    }

    public void updateWidget(@NotNull StatusBarWidgetFactory factory2) {
        if (factory2 == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(2);
        }
        if (factory2.isAvailable(this.myProject) && (!factory2.isConfigurable() || ((StatusBarWidgetSettings)((Object)ServiceManager.getService(StatusBarWidgetSettings.class))).isEnabled(factory2))) {
            this.enableWidget(factory2);
        } else {
            this.disableWidget(factory2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasWidgetCreated(@Nullable StatusBarWidgetFactory factory2) {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            return this.myWidgetFactories.get(factory2) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            this.myWidgetFactories.forEach((factory2, createdWidget) -> this.disableWidget((StatusBarWidgetFactory)factory2));
            this.myWidgetFactories.clear();
        }
    }

    @Nullable
    public StatusBarWidgetFactory findWidgetFactory(@NotNull String widgetId) {
        if (widgetId == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(3);
        }
        return this.myWidgetIdsMap.get(widgetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public Set<StatusBarWidgetFactory> getWidgetFactories() {
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        // MONITORENTER : map2
        Set<StatusBarWidgetFactory> set = this.myWidgetFactories.keySet();
        // MONITOREXIT : map2
        if (set != null) return set;
        StatusBarWidgetsManager.$$$reportNull$$$0(4);
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableWidget(@NotNull StatusBarWidgetFactory factory2) {
        if (factory2 == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(5);
        }
        List availableFactories = StatusBarWidgetFactory.EP_NAME.getExtensionList();
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            if (!this.myWidgetFactories.containsKey(factory2)) {
                LOG.error("Factory is not registered as `com.intellij.statusBarWidgetFactory` extension: " + factory2.getId());
                return;
            }
            StatusBarWidget createdWidget = this.myWidgetFactories.get(factory2);
            if (createdWidget != null) {
                return;
            }
            StatusBarWidget widget = factory2.createWidget(this.myProject);
            this.myWidgetFactories.put(factory2, widget);
            this.myWidgetIdsMap.put(widget.ID(), factory2);
            String anchor2 = this.getAnchor(factory2, availableFactories);
            UIUtil.invokeLaterIfNeeded(() -> {
                if (!this.myProject.isDisposed()) {
                    StatusBar statusBar = WindowManager.getInstance().getStatusBar(this.myProject);
                    if (statusBar == null) {
                        LOG.error("Cannot add a widget for project without root status bar: " + factory2.getId());
                        return;
                    }
                    statusBar.addWidget(widget, anchor2, (Disposable)this);
                }
            });
        }
    }

    @NotNull
    private String getAnchor(@NotNull StatusBarWidgetFactory factory2, @NotNull List<StatusBarWidgetFactory> availableFactories) {
        StatusBarWidget widget;
        int i2;
        if (factory2 == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(6);
        }
        if (availableFactories == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(7);
        }
        if (factory2 instanceof StatusBarWidgetProviderToFactoryAdapter) {
            String string = ((StatusBarWidgetProviderToFactoryAdapter)factory2).getAnchor();
            if (string == null) {
                StatusBarWidgetsManager.$$$reportNull$$$0(8);
            }
            return string;
        }
        int indexOf2 = availableFactories.indexOf(factory2);
        for (i2 = indexOf2 + 1; i2 < availableFactories.size(); ++i2) {
            StatusBarWidgetFactory nextFactory = availableFactories.get(i2);
            widget = this.myWidgetFactories.get(nextFactory);
            if (widget == null) continue;
            String string = StatusBar.Anchors.before((String)widget.ID());
            if (string == null) {
                StatusBarWidgetsManager.$$$reportNull$$$0(9);
            }
            return string;
        }
        for (i2 = indexOf2 - 1; i2 >= 0; --i2) {
            StatusBarWidgetFactory prevFactory = availableFactories.get(i2);
            widget = this.myWidgetFactories.get(prevFactory);
            if (widget == null) continue;
            String string = StatusBar.Anchors.after((String)widget.ID());
            if (string == null) {
                StatusBarWidgetsManager.$$$reportNull$$$0(10);
            }
            return string;
        }
        String string = StatusBar.Anchors.DEFAULT_ANCHOR;
        if (string == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(11);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableWidget(@NotNull StatusBarWidgetFactory factory2) {
        if (factory2 == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(12);
        }
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            StatusBarWidget createdWidget = this.myWidgetFactories.put(factory2, null);
            if (createdWidget != null) {
                this.myWidgetIdsMap.remove(createdWidget.ID());
                factory2.disposeWidget(createdWidget);
                UIUtil.invokeLaterIfNeeded(() -> {
                    StatusBar statusBar;
                    if (!this.myProject.isDisposed() && (statusBar = WindowManager.getInstance().getStatusBar(this.myProject)) != null) {
                        statusBar.removeWidget(createdWidget.ID());
                    }
                });
            }
        }
    }

    public boolean canBeEnabledOnStatusBar(@NotNull StatusBarWidgetFactory factory2, @NotNull StatusBar statusBar) {
        if (factory2 == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(13);
        }
        if (statusBar == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(14);
        }
        return factory2.isAvailable(this.myProject) && factory2.isConfigurable() && factory2.canBeEnabledOn(statusBar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addWidgetFactory(@NotNull StatusBarWidgetFactory factory2) {
        if (factory2 == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(15);
        }
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            if (LightEdit.owns((Project)this.myProject) && !(factory2 instanceof LightEditCompatible)) {
                return;
            }
            if (this.myWidgetFactories.containsKey(factory2)) {
                LOG.error("Factory has been added already: " + factory2.getId());
                return;
            }
            this.myWidgetFactories.put(factory2, null);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (!this.myProject.isDisposed()) {
                    this.updateWidget(factory2);
                }
            });
            this.incModificationCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWidgetFactory(@NotNull StatusBarWidgetFactory factory2) {
        if (factory2 == null) {
            StatusBarWidgetsManager.$$$reportNull$$$0(16);
        }
        Map<StatusBarWidgetFactory, StatusBarWidget> map2 = this.myWidgetFactories;
        synchronized (map2) {
            this.disableWidget(factory2);
            this.myWidgetFactories.remove(factory2);
            this.incModificationCount();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factoryExtension";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 12: 
            case 13: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widgetId";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsManager";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "availableFactories";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statusBar";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/wm/impl/status/widget/StatusBarWidgetsManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getWidgetFactories";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnchor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateWidget";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findWidgetFactory";
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "enableWidget";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getAnchor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "disableWidget";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "canBeEnabledOnStatusBar";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addWidgetFactory";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "removeWidgetFactory";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

