/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.dvcs.repo.VcsRepositoryMappingListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.containers.ContainerUtil;
import git4idea.conflicts.GitConflictsView;
import git4idea.merge.GitDefaultMergeDialogCustomizer;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitStagingAreaHolder;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class GitConflictsToolWindowManager
implements Disposable {
    public static final String TAB_NAME = "Conflicts";
    @NotNull
    private final Project myProject;
    private final AtomicBoolean myRefreshScheduled;
    @Nullable
    private Content myContent;

    public GitConflictsToolWindowManager(@NotNull Project project) {
        if (project == null) {
            GitConflictsToolWindowManager.$$$reportNull$$$0(0);
        }
        this.myRefreshScheduled = new AtomicBoolean();
        this.myProject = project;
    }

    private void scheduleUpdate() {
        if (this.myRefreshScheduled.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> this.updateToolWindow(), c -> Disposer.isDisposed((Disposable)this));
        }
    }

    private void updateToolWindow() {
        this.myRefreshScheduled.set(false);
        boolean hasConflicts = ContainerUtil.exists(GitRepositoryManager.getInstance(this.myProject).getRepositories(), repo -> !repo.getStagingAreaHolder().getAllConflicts().isEmpty());
        if (hasConflicts && this.myContent == null) {
            GitDefaultMergeDialogCustomizer mergeDialogCustomizer = new GitDefaultMergeDialogCustomizer(this.myProject);
            GitConflictsView panel2 = new GitConflictsView(this.myProject, mergeDialogCustomizer);
            this.myContent = ContentFactory.SERVICE.getInstance().createContent(panel2.getComponent(), TAB_NAME, false);
            this.myContent.putUserData(ChangesViewContentManager.ORDER_WEIGHT_KEY, (Object)(ChangesViewContentManager.TabOrderWeight.REPOSITORY.getWeight() + 1));
            this.myContent.setCloseable(false);
            this.myContent.setPreferredFocusedComponent(() -> panel2.getPreferredFocusableComponent());
            Disposer.register((Disposable)this.myContent, (Disposable)panel2);
            ChangesViewContentManager.getInstance((Project)this.myProject).addContent(this.myContent);
        }
        if (!hasConflicts && this.myContent != null) {
            ChangesViewContentManager.getInstance((Project)this.myProject).removeContent(this.myContent);
            this.myContent = null;
        }
    }

    public void dispose() {
        if (this.myContent != null) {
            ChangesViewContentManager.getInstance((Project)this.myProject).removeContent(this.myContent);
            this.myContent = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/conflicts/GitConflictsToolWindowManager", "<init>"));
    }

    public static class MyRepositoryListener
    implements VcsRepositoryMappingListener {
        private final Project myProject;

        public MyRepositoryListener(@NotNull Project project) {
            if (project == null) {
                MyRepositoryListener.$$$reportNull$$$0(0);
            }
            this.myProject = project;
        }

        public void mappingChanged() {
            if (!Registry.is((String)"git.merge.conflicts.toolwindow")) {
                return;
            }
            GitConflictsToolWindowManager service = (GitConflictsToolWindowManager)this.myProject.getService(GitConflictsToolWindowManager.class);
            service.scheduleUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/conflicts/GitConflictsToolWindowManager$MyRepositoryListener", "<init>"));
        }
    }

    public static class MyStagingAreaListener
    implements GitStagingAreaHolder.StagingAreaListener {
        @Override
        public void stagingAreaChanged(@NotNull GitRepository repository) {
            if (repository == null) {
                MyStagingAreaListener.$$$reportNull$$$0(0);
            }
            if (!Registry.is((String)"git.merge.conflicts.toolwindow")) {
                return;
            }
            Project project = repository.getProject();
            GitConflictsToolWindowManager service = (GitConflictsToolWindowManager)project.getService(GitConflictsToolWindowManager.class);
            service.scheduleUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/conflicts/GitConflictsToolWindowManager$MyStagingAreaListener", "stagingAreaChanged"));
        }
    }
}

