/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.controlpanel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sourceforge.jnlp.config.DeploymentConfiguration;
import net.sourceforge.jnlp.config.PathsAndFiles;
import net.sourceforge.jnlp.controlpanel.ComboItem;
import net.sourceforge.jnlp.controlpanel.NamedBorderPanel;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.LogConfig;

public class DebuggingPanel
extends NamedBorderPanel
implements ItemListener {
    public static String[] properties = new String[]{"deployment.log", "deployment.log.headers", "deployment.log.file", "deployment.log.file.legacylog", "deployment.log.file.clientapp", "deployment.log.stdstreams", "deployment.log.system"};
    private final DeploymentConfiguration config;

    public DebuggingPanel(DeploymentConfiguration config) {
        super(Translator.R("CPHeadDebugging"), new GridBagLayout());
        this.config = config;
        this.addComponents();
    }

    private void fileLoggingAct(JCheckBox source, JCheckBox ... targets) {
        if (source.isSelected()) {
            for (JCheckBox target : targets) {
                target.setEnabled(true);
            }
        } else {
            for (JCheckBox target : targets) {
                target.setEnabled(false);
            }
        }
    }

    private void addComponents() {
        GridBagConstraints c = new GridBagConstraints();
        JLabel debuggingDescription = new JLabel("<html>" + Translator.R("CPDebuggingDescription") + "<hr /><br /></html>");
        JLabel logsDestinationTitle = new JLabel(Translator.R("CPFilesLogsDestDir") + ": ");
        final JTextField logsDestination = new JTextField(PathsAndFiles.LOG_DIR.getFullPath(this.config));
        logsDestination.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.save();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.save();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.save();
            }

            private void save() {
                PathsAndFiles.LOG_DIR.setValue(logsDestination.getText(), DebuggingPanel.this.config);
            }
        });
        JButton logsDestinationReset = new JButton(Translator.R("CPFilesLogsDestDirResert"));
        logsDestinationReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                logsDestination.setText(PathsAndFiles.LOG_DIR.getDefaultFullPath());
            }
        });
        final JCheckBox[] debuggingOptions = new JCheckBox[]{new JCheckBox(Translator.R("DPEnableLogging")), new JCheckBox(Translator.R("DPEnableHeaders")), new JCheckBox(Translator.R("DPEnableFile")), new JCheckBox(Translator.R("DPEnableLegacyFileLog")), new JCheckBox(Translator.R("DPEnableClientAppFileLogging")), new JCheckBox(Translator.R("DPEnableStds")), new JCheckBox(Translator.R("DPEnableSyslog"))};
        debuggingOptions[2].addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DebuggingPanel.this.fileLoggingAct(debuggingOptions[2], new JCheckBox[]{debuggingOptions[3], debuggingOptions[4]});
            }
        });
        String[] hints = new String[]{Translator.R("DPEnableLoggingHint"), Translator.R("DPEnableHeadersHint"), Translator.R("DPEnableFileHint", LogConfig.getLogConfig().getIcedteaLogDir()), Translator.R("DPEnableLegacyFileLogHint"), Translator.R("DPEnableClientAppFileLoggingHint"), Translator.R("DPEnableStdsHint"), Translator.R("DPEnableSyslogHint")};
        ComboItem[] javaConsoleItems = new ComboItem[]{new ComboItem(Translator.R("DPDisable"), "DISABLE"), new ComboItem(Translator.R("DPHide"), "HIDE"), new ComboItem(Translator.R("DPShow"), "SHOW"), new ComboItem(Translator.R("DPShowPluginOnly"), "SHOW_PLUGIN_ONLY"), new ComboItem(Translator.R("DPShowJavawsOnly"), "SHOW_JAVAWS_ONLY")};
        JLabel consoleLabel = new JLabel(Translator.R("DPJavaConsole"));
        JComboBox<ComboItem> consoleComboBox = new JComboBox<ComboItem>();
        consoleComboBox.setActionCommand("deployment.console.startup.mode");
        JPanel consolePanel = new JPanel();
        consolePanel.setLayout(new FlowLayout(3));
        consolePanel.add(consoleLabel);
        consolePanel.add(consoleComboBox);
        c.fill = 1;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        this.add((Component)debuggingDescription, c);
        for (int i = 0; i < properties.length; ++i) {
            String s = this.config.getProperty(properties[i]);
            ++c.gridy;
            if (i == 2) {
                JLabel space = new JLabel("<html>" + Translator.R("CPDebuggingPossibilites") + ":</html>");
                this.add((Component)space, c);
                ++c.gridy;
            }
            if (i == 3 || i == 4) {
                ++c.gridx;
                if (i == 4) {
                    --c.gridy;
                }
            } else {
                c.gridx = 0;
            }
            debuggingOptions[i].setSelected(Boolean.parseBoolean(s));
            debuggingOptions[i].setActionCommand(properties[i]);
            debuggingOptions[i].setToolTipText(hints[i]);
            debuggingOptions[i].addItemListener(this);
            this.add((Component)debuggingOptions[i], c);
            if (i != 2) continue;
            ++c.gridx;
            JPanel resetTitlePanel = new JPanel(new BorderLayout(10, 0));
            resetTitlePanel.add((Component)logsDestinationReset, "Before");
            resetTitlePanel.add((Component)logsDestinationTitle, "After");
            this.add((Component)resetTitlePanel, c);
            ++c.gridx;
            this.add((Component)logsDestination, c);
            c.gridx -= 2;
        }
        for (int j = 0; j < javaConsoleItems.length; ++j) {
            consoleComboBox.addItem(javaConsoleItems[j]);
            if (!this.config.getProperty("deployment.console.startup.mode").equals(javaConsoleItems[j].getValue())) continue;
            consoleComboBox.setSelectedIndex(j);
        }
        ++c.gridy;
        consoleComboBox.addItemListener(this);
        this.add((Component)consolePanel, c);
        Component filler = Box.createRigidArea(new Dimension(1, 1));
        ++c.gridy;
        c.weighty = 1.0;
        this.add(filler, c);
        this.fileLoggingAct(debuggingOptions[2], debuggingOptions[3], debuggingOptions[4]);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object o = e.getSource();
        if (o instanceof JCheckBox) {
            JCheckBox jcb = (JCheckBox)o;
            this.config.setProperty(jcb.getActionCommand(), String.valueOf(jcb.isSelected()));
        } else if (o instanceof JComboBox) {
            JComboBox jcb = (JComboBox)o;
            ComboItem c = (ComboItem)e.getItem();
            this.config.setProperty(jcb.getActionCommand(), c.getValue());
        }
    }
}

