/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.security.policyeditor;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.sourceforge.jnlp.security.policyeditor.PolicyEditorPermissions;
import net.sourceforge.jnlp.security.policyeditor.PolicyIdentifier;
import sun.security.provider.PolicyParser;

public class PolicyEntry
implements Serializable,
Transferable {
    public static final DataFlavor POLICY_ENTRY_DATA_FLAVOR = new DataFlavor(PolicyEntry.class, "PolicyEntry");
    private final PolicyIdentifier policyIdentifier;
    private final Set<PolicyEditorPermissions> permissions = new HashSet<PolicyEditorPermissions>();
    private final Set<PolicyParser.PermissionEntry> customPermissions = new HashSet<PolicyParser.PermissionEntry>();

    private PolicyEntry(Builder builder) {
        this.policyIdentifier = new PolicyIdentifier(builder.signedBy, builder.principals, builder.codebase);
        this.permissions.addAll(builder.permissions);
        this.permissions.remove(null);
        this.customPermissions.addAll(builder.customPermissions);
        this.customPermissions.remove(null);
    }

    public PolicyIdentifier getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public Set<PolicyEditorPermissions> getPermissions() {
        return this.permissions;
    }

    public Set<PolicyParser.PermissionEntry> getCustomPermissions() {
        return this.customPermissions;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{POLICY_ENTRY_DATA_FLAVOR};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return Objects.equals(POLICY_ENTRY_DATA_FLAVOR, dataFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!Arrays.asList(this.getTransferDataFlavors()).contains(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this;
    }

    public static class Builder {
        private String signedBy;
        private String codebase;
        private final Set<PolicyEditorPermissions> permissions = EnumSet.noneOf(PolicyEditorPermissions.class);
        private final Set<PolicyParser.PermissionEntry> customPermissions = new HashSet<PolicyParser.PermissionEntry>();
        private final Set<PolicyParser.PrincipalEntry> principals = new HashSet<PolicyParser.PrincipalEntry>();

        public Builder signedBy(String signedBy) {
            this.signedBy = signedBy;
            return this;
        }

        public Builder principals(Collection<PolicyParser.PrincipalEntry> principals) {
            this.principals.addAll(principals);
            return this;
        }

        public Builder codebase(String codebase) {
            this.codebase = codebase;
            return this;
        }

        public Builder identifier(PolicyIdentifier identifier) {
            return this.signedBy(identifier.getSignedBy()).codebase(identifier.getCodebase()).principals(identifier.getPrincipals());
        }

        public Builder permissions(Collection<PolicyEditorPermissions> permissions) {
            this.permissions.addAll(permissions);
            return this;
        }

        public Builder customPermissions(Collection<? extends PolicyParser.PermissionEntry> customPermissions) {
            this.customPermissions.addAll(customPermissions);
            return this;
        }

        public PolicyEntry build() {
            return new PolicyEntry(this);
        }
    }
}

