/*
 * Decompiled with CFR 0.152.
 */
package java2d.demos.Images;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java2d.Surface;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.plugins.jpeg.JPEGImageWriteParam;
import javax.imageio.stream.ImageOutputStream;

public class JPEGFlip
extends Surface {
    private static Image img;

    public JPEGFlip() {
        this.setBackground(Color.WHITE);
        img = this.getImage("duke.png");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(int w, int h, Graphics2D g2) {
        int hh = h / 2;
        BufferedImage bi = new BufferedImage(w, hh, 1);
        Graphics2D big = bi.createGraphics();
        big.setRenderingHints(g2.getRenderingHints());
        big.setBackground(this.getBackground());
        big.clearRect(0, 0, w, hh);
        big.setColor(Color.GREEN.darker());
        GeneralPath p = new GeneralPath(1);
        p.moveTo((float)(-w) / 2.0f, (float)(-hh) / 8.0f);
        p.lineTo((float)w / 2.0f, (float)(-hh) / 8.0f);
        p.lineTo((float)(-w) / 4.0f, (float)hh / 2.0f);
        p.lineTo(0.0f, (float)(-hh) / 2.0f);
        p.lineTo((float)w / 4.0f, (float)hh / 2.0f);
        p.closePath();
        big.translate(w / 2, hh / 2);
        big.fill(p);
        float scale = 0.09f;
        int iw = (int)(scale * (float)w);
        int ih = img.getHeight(null) * iw / img.getWidth(null);
        big.drawImage(img, -iw / 2, -ih / 2, iw, ih, this);
        g2.drawImage((Image)bi, 0, 0, this);
        g2.setFont(new Font("Dialog", 0, 10));
        g2.setColor(Color.BLACK);
        g2.drawString("BufferedImage", 4, 12);
        BufferedImage bi1 = null;
        ImageOutputStream ios = null;
        ByteArrayOutputStream out = null;
        ByteArrayInputStream in = null;
        try {
            out = new ByteArrayOutputStream();
            ios = ImageIO.createImageOutputStream(out);
            ImageWriter encoder = ImageIO.getImageWritersByFormatName("JPEG").next();
            JPEGImageWriteParam param = new JPEGImageWriteParam(null);
            param.setCompressionMode(2);
            param.setCompressionQuality(1.0f);
            encoder.setOutput(ios);
            encoder.write(null, new IIOImage(bi, null, null), param);
            in = new ByteArrayInputStream(out.toByteArray());
            bi1 = ImageIO.read(in);
        }
        catch (Exception ex) {
            g2.setColor(Color.RED);
            g2.drawString("Error encoding or decoding the image", 5, hh * 2 - 5);
            return;
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(JPEGFlip.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(JPEGFlip.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(JPEGFlip.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        if (bi1 == null) {
            g2.setColor(Color.RED);
            g2.drawString("Error reading the image", 5, hh * 2 - 5);
            return;
        }
        g2.drawImage(bi1, w, hh * 2, -w, -hh, null);
        g2.drawString("JPEGImage Flipped", 4, hh * 2 - 4);
        g2.drawLine(0, hh, w, hh);
    }

    public static void main(String[] s) {
        JPEGFlip.createDemoFrame(new JPEGFlip());
    }
}

