/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ProgressBarDrawData
extends RangeDrawData {
    public ProgressBarDrawData() {
        this.state = new int[1];
    }

    @Override
    void draw(Theme theme, GC gC, Rectangle rectangle) {
        long l = theme.progressHandle;
        long l2 = this.gtk_widget_get_style(l);
        long l3 = gC.getGCData().drawable;
        theme.transferClipping(gC, l2);
        byte[] byArray = Converter.wcsToMbcs(null, "trough", true);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        this.gtk_render_box(l2, l3, this.getStateType(0), 1, null, l, byArray, n, n2, n3, n4);
        int n5 = OS.gtk_style_get_xthickness(l2);
        int n6 = OS.gtk_style_get_ythickness(l2);
        if ((this.style & 0x200) != 0) {
            this.gtk_orientable_set_orientation(l, 2);
            n += n5;
            n3 -= n5 * 2;
            n4 -= n6 * 2;
            n4 = (int)((float)n4 * ((float)this.selection / (float)Math.max(1, this.maximum - this.minimum)));
            n2 += rectangle.height - n6 - n4;
        } else {
            this.gtk_orientable_set_orientation(l, 0);
            n += n5;
            n2 += n6;
            n3 -= n5 * 2;
            n4 -= n6 * 2;
            n3 = (int)((float)n3 * ((float)this.selection / (float)Math.max(1, this.maximum - this.minimum)));
        }
        byArray = Converter.wcsToMbcs(null, "bar", true);
        this.gtk_render_box(l2, l3, 2, 2, null, l, byArray, n, n2, n3, n4);
    }

    @Override
    int getStateType(int n) {
        return 0;
    }

    @Override
    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }

    void gtk_orientable_set_orientation(long l, int n) {
        if (OS.GTK3) {
            switch (n) {
                case 2: {
                    OS.gtk_orientable_set_orientation(l, 1);
                    OS.gtk_progress_bar_set_inverted(l, true);
                    break;
                }
                case 0: {
                    OS.gtk_orientable_set_orientation(l, 0);
                    OS.gtk_progress_bar_set_inverted(l, false);
                }
            }
        } else {
            OS.gtk_progress_bar_set_orientation(l, n);
        }
    }
}

