/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.loader;

import java.io.File;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.loader.WebappLoader;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class VirtualWebappLoader
extends WebappLoader {
    private static final Log log = LogFactory.getLog(VirtualWebappLoader.class);
    private String virtualClasspath = "";

    public VirtualWebappLoader() {
    }

    public VirtualWebappLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void setVirtualClasspath(String string) {
        this.virtualClasspath = string;
    }

    public boolean getSearchVirtualFirst() {
        return this.getSearchExternalFirst();
    }

    public void setSearchVirtualFirst(boolean bl) {
        this.setSearchExternalFirst(bl);
    }

    @Override
    protected void startInternal() throws LifecycleException {
        StringTokenizer stringTokenizer = new StringTokenizer(this.virtualClasspath, ";");
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        while (stringTokenizer.hasMoreTokens()) {
            Object object2 = stringTokenizer.nextToken().trim();
            if (((String)object2).isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("virtualWebappLoader.token", new Object[]{object2}));
            }
            if (((String)object2).endsWith("*.jar")) {
                Object[] objectArray;
                File file = new File((String)(object2 = ((String)object2).substring(0, ((String)object2).length() - "*.jar".length())));
                if (!file.isDirectory()) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)sm.getString("virtualWebappLoader.token.notDirectory", new Object[]{file.getAbsolutePath()}));
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("virtualWebappLoader.token.glob.dir", new Object[]{file.getAbsolutePath()}));
                }
                if ((objectArray = file.list()) == null) continue;
                Arrays.sort(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    String string = ((String)objectArray[i]).toLowerCase(Locale.ENGLISH);
                    if (!string.endsWith(".jar")) continue;
                    File file2 = new File(file, (String)objectArray[i]);
                    if (!file2.isFile()) {
                        if (!log.isDebugEnabled()) continue;
                        log.debug((Object)sm.getString("virtualWebappLoader.token.notFile", new Object[]{file2.getAbsolutePath()}));
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("virtualWebappLoader.token.file", new Object[]{file2.getAbsolutePath()}));
                    }
                    linkedHashSet.add(file2.toURI().toString());
                }
                continue;
            }
            File file = new File((String)object2);
            if (!file.exists()) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)sm.getString("virtualWebappLoader.token.notExists", new Object[]{file.getAbsolutePath()}));
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("virtualWebappLoader.token.file", new Object[]{file.getAbsolutePath()}));
            }
            linkedHashSet.add(file.toURI().toString());
        }
        for (String string : linkedHashSet) {
            this.addRepository(string);
        }
        super.startInternal();
    }
}

