/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.beans.Introspector;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.naming.NamingException;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;
import javax.xml.ws.WebServiceRef;
import org.apache.catalina.ContainerServlet;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.security.SecurityUtil;
import org.apache.catalina.util.Introspection;
import org.apache.juli.logging.Log;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.collections.ManagedConcurrentWeakHashMap;
import org.apache.tomcat.util.res.StringManager;

public class DefaultInstanceManager
implements InstanceManager {
    private static final AnnotationCacheEntry[] ANNOTATIONS_EMPTY = new AnnotationCacheEntry[0];
    protected static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");
    private static final boolean EJB_PRESENT;
    private static final boolean JPA_PRESENT;
    private static final boolean WS_PRESENT;
    private final javax.naming.Context context;
    private final Map<String, Map<String, String>> injectionMap;
    protected final ClassLoader classLoader;
    protected final ClassLoader containerClassLoader;
    protected boolean privileged;
    protected boolean ignoreAnnotations;
    private final Set<String> restrictedClasses;
    private final ManagedConcurrentWeakHashMap<Class<?>, AnnotationCacheEntry[]> annotationCache = new ManagedConcurrentWeakHashMap();
    private final Map<String, String> postConstructMethods;
    private final Map<String, String> preDestroyMethods;

    public DefaultInstanceManager(javax.naming.Context context, Map<String, Map<String, String>> map, Context context2, ClassLoader classLoader) {
        this.classLoader = context2.getLoader().getClassLoader();
        this.privileged = context2.getPrivileged();
        this.containerClassLoader = classLoader;
        this.ignoreAnnotations = context2.getIgnoreAnnotations();
        Log log = context2.getLogger();
        HashSet<String> hashSet = new HashSet<String>();
        DefaultInstanceManager.loadProperties(hashSet, "org/apache/catalina/core/RestrictedServlets.properties", "defaultInstanceManager.restrictedServletsResource", log);
        DefaultInstanceManager.loadProperties(hashSet, "org/apache/catalina/core/RestrictedListeners.properties", "defaultInstanceManager.restrictedListenersResource", log);
        DefaultInstanceManager.loadProperties(hashSet, "org/apache/catalina/core/RestrictedFilters.properties", "defaultInstanceManager.restrictedFiltersResource", log);
        this.restrictedClasses = Collections.unmodifiableSet(hashSet);
        this.context = context;
        this.injectionMap = map;
        this.postConstructMethods = context2.findPostConstructMethods();
        this.preDestroyMethods = context2.findPreDestroyMethods();
    }

    public Object newInstance(Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, IllegalArgumentException, NoSuchMethodException, SecurityException {
        return this.newInstance(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), clazz);
    }

    public Object newInstance(String string) throws IllegalAccessException, InvocationTargetException, NamingException, InstantiationException, ClassNotFoundException, IllegalArgumentException, NoSuchMethodException, SecurityException {
        Class<?> clazz = this.loadClassMaybePrivileged(string, this.classLoader);
        return this.newInstance(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), clazz);
    }

    public Object newInstance(String string, ClassLoader classLoader) throws IllegalAccessException, NamingException, InvocationTargetException, InstantiationException, ClassNotFoundException, IllegalArgumentException, NoSuchMethodException, SecurityException {
        Class<?> clazz = classLoader.loadClass(string);
        return this.newInstance(clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), clazz);
    }

    public void newInstance(Object object) throws IllegalAccessException, InvocationTargetException, NamingException {
        this.newInstance(object, object.getClass());
    }

    private Object newInstance(Object object, Class<?> clazz) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (!this.ignoreAnnotations) {
            Map<String, String> map = this.assembleInjectionsFromClassHierarchy(clazz);
            this.populateAnnotationsCache(clazz, map);
            this.processAnnotations(object, map);
            this.postConstruct(object, clazz);
        }
        return object;
    }

    private Map<String, String> assembleInjectionsFromClassHierarchy(Class<?> clazz) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Map<String, String> map = null;
        while (clazz != null) {
            map = this.injectionMap.get(clazz.getName());
            if (map != null) {
                hashMap.putAll(map);
            }
            clazz = clazz.getSuperclass();
        }
        return hashMap;
    }

    public void destroyInstance(Object object) throws IllegalAccessException, InvocationTargetException {
        if (!this.ignoreAnnotations) {
            this.preDestroy(object, object.getClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postConstruct(Object object, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        AnnotationCacheEntry[] annotationCacheEntryArray;
        if (this.context == null) {
            return;
        }
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != Object.class) {
            this.postConstruct(object, clazz2);
        }
        for (AnnotationCacheEntry annotationCacheEntry : annotationCacheEntryArray = (AnnotationCacheEntry[])this.annotationCache.get(clazz)) {
            Method method;
            if (annotationCacheEntry.getType() != AnnotationCacheEntryType.POST_CONSTRUCT) continue;
            Method method2 = method = DefaultInstanceManager.getMethod(clazz, annotationCacheEntry);
            synchronized (method2) {
                boolean bl = method.isAccessible();
                method.setAccessible(true);
                method.invoke(object, new Object[0]);
                method.setAccessible(bl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void preDestroy(Object object, Class<?> clazz) throws IllegalAccessException, InvocationTargetException {
        AnnotationCacheEntry[] annotationCacheEntryArray;
        Class<?> clazz2 = clazz.getSuperclass();
        if (clazz2 != Object.class) {
            this.preDestroy(object, clazz2);
        }
        if ((annotationCacheEntryArray = (AnnotationCacheEntry[])this.annotationCache.get(clazz)) == null) {
            return;
        }
        for (AnnotationCacheEntry annotationCacheEntry : annotationCacheEntryArray) {
            Method method;
            if (annotationCacheEntry.getType() != AnnotationCacheEntryType.PRE_DESTROY) continue;
            Method method2 = method = DefaultInstanceManager.getMethod(clazz, annotationCacheEntry);
            synchronized (method2) {
                boolean bl = method.isAccessible();
                method.setAccessible(true);
                method.invoke(object, new Object[0]);
                method.setAccessible(bl);
            }
        }
    }

    public void backgroundProcess() {
        this.annotationCache.maintain();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void populateAnnotationsCache(Class<?> clazz, Map<String, String> map) throws IllegalAccessException, InvocationTargetException, NamingException {
        ArrayList<AnnotationCacheEntry> arrayList = null;
        HashSet hashSet = new HashSet();
        while (clazz != null) {
            AnnotationCacheEntry[] annotationCacheEntryArray = (AnnotationCacheEntry[])this.annotationCache.get(clazz);
            if (annotationCacheEntryArray == null) {
                PersistenceUnit persistenceUnit;
                PersistenceContext persistenceContext;
                WebServiceRef webServiceRef;
                EJB eJB;
                ManagedConcurrentWeakHashMap<Class<?>, AnnotationCacheEntry[]> managedConcurrentWeakHashMap;
                int n;
                if (arrayList == null) {
                    arrayList = new ArrayList<AnnotationCacheEntry>();
                } else {
                    arrayList.clear();
                }
                Method[] methodArray = Introspection.getDeclaredMethods(clazz);
                Method method = null;
                String string = this.postConstructMethods.get(clazz.getName());
                Method method2 = null;
                String string2 = this.preDestroyMethods.get(clazz.getName());
                ManagedConcurrentWeakHashMap<Class<?>, AnnotationCacheEntry[]> managedConcurrentWeakHashMap2 = methodArray;
                int n2 = ((Method[])managedConcurrentWeakHashMap2).length;
                for (n = 0; n < n2; ++n) {
                    Method method3 = managedConcurrentWeakHashMap2[n];
                    if (this.context != null) {
                        if (map != null && Introspection.isValidSetter(method3)) {
                            managedConcurrentWeakHashMap = Introspection.getPropertyName(method3);
                            hashSet.add(managedConcurrentWeakHashMap);
                            if (map.containsKey(managedConcurrentWeakHashMap)) {
                                arrayList.add(new AnnotationCacheEntry(method3.getName(), method3.getParameterTypes(), map.get(managedConcurrentWeakHashMap), AnnotationCacheEntryType.SETTER));
                                continue;
                            }
                        }
                        if ((managedConcurrentWeakHashMap = method3.getAnnotation(Resource.class)) != null) {
                            arrayList.add(new AnnotationCacheEntry(method3.getName(), method3.getParameterTypes(), managedConcurrentWeakHashMap.name(), AnnotationCacheEntryType.SETTER));
                        } else if (EJB_PRESENT && (eJB = method3.getAnnotation(EJB.class)) != null) {
                            arrayList.add(new AnnotationCacheEntry(method3.getName(), method3.getParameterTypes(), eJB.name(), AnnotationCacheEntryType.SETTER));
                        } else if (WS_PRESENT && (webServiceRef = method3.getAnnotation(WebServiceRef.class)) != null) {
                            arrayList.add(new AnnotationCacheEntry(method3.getName(), method3.getParameterTypes(), webServiceRef.name(), AnnotationCacheEntryType.SETTER));
                        } else if (JPA_PRESENT && (persistenceContext = method3.getAnnotation(PersistenceContext.class)) != null) {
                            arrayList.add(new AnnotationCacheEntry(method3.getName(), method3.getParameterTypes(), persistenceContext.name(), AnnotationCacheEntryType.SETTER));
                        } else if (JPA_PRESENT && (persistenceUnit = method3.getAnnotation(PersistenceUnit.class)) != null) {
                            arrayList.add(new AnnotationCacheEntry(method3.getName(), method3.getParameterTypes(), persistenceUnit.name(), AnnotationCacheEntryType.SETTER));
                        }
                    }
                    method = DefaultInstanceManager.findPostConstruct(method, string, method3);
                    method2 = DefaultInstanceManager.findPreDestroy(method2, string2, method3);
                }
                if (method != null) {
                    arrayList.add(new AnnotationCacheEntry(method.getName(), method.getParameterTypes(), null, AnnotationCacheEntryType.POST_CONSTRUCT));
                } else if (string != null) {
                    throw new IllegalArgumentException("Post construct method " + string + " for class " + clazz.getName() + " is declared in deployment descriptor but cannot be found.");
                }
                if (method2 != null) {
                    arrayList.add(new AnnotationCacheEntry(method2.getName(), method2.getParameterTypes(), null, AnnotationCacheEntryType.PRE_DESTROY));
                } else if (string2 != null) {
                    throw new IllegalArgumentException("Pre destroy method " + string2 + " for class " + clazz.getName() + " is declared in deployment descriptor but cannot be found.");
                }
                if (this.context != null) {
                    ManagedConcurrentWeakHashMap<Class<?>, AnnotationCacheEntry[]> managedConcurrentWeakHashMap3 = managedConcurrentWeakHashMap2 = Introspection.getDeclaredFields(clazz);
                    n = ((AccessibleObject[])managedConcurrentWeakHashMap3).length;
                    for (int i = 0; i < n; ++i) {
                        PersistenceUnit persistenceUnit2;
                        managedConcurrentWeakHashMap = managedConcurrentWeakHashMap3[i];
                        String string3 = managedConcurrentWeakHashMap.getName();
                        if (map != null && map.containsKey(string3) && !hashSet.contains(string3)) {
                            arrayList.add(new AnnotationCacheEntry(string3, null, map.get(string3), AnnotationCacheEntryType.FIELD));
                            continue;
                        }
                        eJB = managedConcurrentWeakHashMap.getAnnotation(Resource.class);
                        if (eJB != null) {
                            arrayList.add(new AnnotationCacheEntry(string3, null, eJB.name(), AnnotationCacheEntryType.FIELD));
                            continue;
                        }
                        if (EJB_PRESENT && (webServiceRef = managedConcurrentWeakHashMap.getAnnotation(EJB.class)) != null) {
                            arrayList.add(new AnnotationCacheEntry(string3, null, ((EJB)webServiceRef).name(), AnnotationCacheEntryType.FIELD));
                            continue;
                        }
                        if (WS_PRESENT && (persistenceContext = managedConcurrentWeakHashMap.getAnnotation(WebServiceRef.class)) != null) {
                            arrayList.add(new AnnotationCacheEntry(string3, null, ((WebServiceRef)persistenceContext).name(), AnnotationCacheEntryType.FIELD));
                            continue;
                        }
                        if (JPA_PRESENT && (persistenceUnit = managedConcurrentWeakHashMap.getAnnotation(PersistenceContext.class)) != null) {
                            arrayList.add(new AnnotationCacheEntry(string3, null, ((PersistenceContext)persistenceUnit).name(), AnnotationCacheEntryType.FIELD));
                            continue;
                        }
                        if (!JPA_PRESENT || (persistenceUnit2 = managedConcurrentWeakHashMap.getAnnotation(PersistenceUnit.class)) == null) continue;
                        arrayList.add(new AnnotationCacheEntry(string3, null, persistenceUnit2.name(), AnnotationCacheEntryType.FIELD));
                    }
                }
                annotationCacheEntryArray = arrayList.isEmpty() ? ANNOTATIONS_EMPTY : arrayList.toArray(new AnnotationCacheEntry[0]);
                managedConcurrentWeakHashMap2 = this.annotationCache;
                synchronized (managedConcurrentWeakHashMap2) {
                    this.annotationCache.put(clazz, (Object)annotationCacheEntryArray);
                }
            }
            clazz = clazz.getSuperclass();
        }
    }

    protected void processAnnotations(Object object, Map<String, String> map) throws IllegalAccessException, InvocationTargetException, NamingException {
        if (this.context == null) {
            return;
        }
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            AnnotationCacheEntry[] annotationCacheEntryArray;
            for (AnnotationCacheEntry annotationCacheEntry : annotationCacheEntryArray = (AnnotationCacheEntry[])this.annotationCache.get(clazz)) {
                if (annotationCacheEntry.getType() == AnnotationCacheEntryType.SETTER) {
                    DefaultInstanceManager.lookupMethodResource(this.context, object, DefaultInstanceManager.getMethod(clazz, annotationCacheEntry), annotationCacheEntry.getName(), clazz);
                    continue;
                }
                if (annotationCacheEntry.getType() != AnnotationCacheEntryType.FIELD) continue;
                DefaultInstanceManager.lookupFieldResource(this.context, object, DefaultInstanceManager.getField(clazz, annotationCacheEntry), annotationCacheEntry.getName(), clazz);
            }
        }
    }

    protected int getAnnotationCacheSize() {
        return this.annotationCache.size();
    }

    protected Class<?> loadClassMaybePrivileged(final String string, final ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz;
        if (SecurityUtil.isPackageProtectionEnabled()) {
            try {
                clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                    @Override
                    public Class<?> run() throws Exception {
                        return DefaultInstanceManager.this.loadClass(string, classLoader);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof ClassNotFoundException) {
                    throw (ClassNotFoundException)throwable;
                }
                throw new RuntimeException(throwable);
            }
        } else {
            clazz = this.loadClass(string, classLoader);
        }
        this.checkAccess(clazz);
        return clazz;
    }

    protected Class<?> loadClass(String string, ClassLoader classLoader) throws ClassNotFoundException {
        if (string.startsWith("org.apache.catalina")) {
            return this.containerClassLoader.loadClass(string);
        }
        try {
            Class<?> clazz = this.containerClassLoader.loadClass(string);
            if (ContainerServlet.class.isAssignableFrom(clazz)) {
                return clazz;
            }
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        return classLoader.loadClass(string);
    }

    private void checkAccess(Class<?> clazz) {
        if (this.privileged) {
            return;
        }
        if (ContainerServlet.class.isAssignableFrom(clazz)) {
            throw new SecurityException(sm.getString("defaultInstanceManager.restrictedContainerServlet", new Object[]{clazz}));
        }
        while (clazz != null) {
            if (this.restrictedClasses.contains(clazz.getName())) {
                throw new SecurityException(sm.getString("defaultInstanceManager.restrictedClass", new Object[]{clazz}));
            }
            clazz = clazz.getSuperclass();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void lookupFieldResource(javax.naming.Context context, Object object, Field field, String string, Class<?> clazz) throws NamingException, IllegalAccessException {
        String string2 = DefaultInstanceManager.normalize(string);
        Object object2 = string2 != null && string2.length() > 0 ? context.lookup(string2) : context.lookup(clazz.getName() + "/" + field.getName());
        Field field2 = field;
        synchronized (field2) {
            boolean bl = field.isAccessible();
            field.setAccessible(true);
            field.set(object, object2);
            field.setAccessible(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void lookupMethodResource(javax.naming.Context context, Object object, Method method, String string, Class<?> clazz) throws NamingException, IllegalAccessException, InvocationTargetException {
        if (!Introspection.isValidSetter(method)) {
            throw new IllegalArgumentException(sm.getString("defaultInstanceManager.invalidInjection"));
        }
        String string2 = DefaultInstanceManager.normalize(string);
        Object object2 = string2 != null && string2.length() > 0 ? context.lookup(string2) : context.lookup(clazz.getName() + "/" + Introspection.getPropertyName(method));
        Method method2 = method;
        synchronized (method2) {
            boolean bl = method.isAccessible();
            method.setAccessible(true);
            method.invoke(object, object2);
            method.setAccessible(bl);
        }
    }

    @Deprecated
    public static String getName(Method method) {
        return Introspector.decapitalize(method.getName().substring(3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadProperties(Set<String> set, String string, String string2, Log log) {
        Properties properties = new Properties();
        ClassLoader classLoader = DefaultInstanceManager.class.getClassLoader();
        InputStream inputStream = null;
        try {
            inputStream = classLoader.getResourceAsStream(string);
            if (inputStream == null) {
                log.error((Object)sm.getString(string2, new Object[]{string}));
            } else {
                properties.load(inputStream);
            }
        }
        catch (IOException iOException) {
            log.error((Object)sm.getString(string2, new Object[]{string}), (Throwable)iOException);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (properties.isEmpty()) {
            return;
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if ("restricted".equals(entry.getValue())) {
                set.add(entry.getKey().toString());
                continue;
            }
            log.warn((Object)sm.getString("defaultInstanceManager.restrictedWrongValue", new Object[]{string, entry.getKey(), entry.getValue()}));
        }
    }

    private static String normalize(String string) {
        if (string != null && string.startsWith("java:comp/env/")) {
            return string.substring(14);
        }
        return string;
    }

    private static Method getMethod(final Class<?> clazz, final AnnotationCacheEntry annotationCacheEntry) {
        Method method = null;
        if (Globals.IS_SECURITY_ENABLED) {
            method = AccessController.doPrivileged(new PrivilegedAction<Method>(){

                @Override
                public Method run() {
                    Method method = null;
                    try {
                        method = clazz.getDeclaredMethod(annotationCacheEntry.getAccessibleObjectName(), annotationCacheEntry.getParamTypes());
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                    return method;
                }
            });
        } else {
            try {
                method = clazz.getDeclaredMethod(annotationCacheEntry.getAccessibleObjectName(), annotationCacheEntry.getParamTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return method;
    }

    private static Field getField(final Class<?> clazz, final AnnotationCacheEntry annotationCacheEntry) {
        Field field = null;
        if (Globals.IS_SECURITY_ENABLED) {
            field = AccessController.doPrivileged(new PrivilegedAction<Field>(){

                @Override
                public Field run() {
                    Field field = null;
                    try {
                        field = clazz.getDeclaredField(annotationCacheEntry.getAccessibleObjectName());
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    return field;
                }
            });
        } else {
            try {
                field = clazz.getDeclaredField(annotationCacheEntry.getAccessibleObjectName());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return field;
    }

    private static Method findPostConstruct(Method method, String string, Method method2) {
        return DefaultInstanceManager.findLifecycleCallback(method, string, method2, PostConstruct.class);
    }

    private static Method findPreDestroy(Method method, String string, Method method2) {
        return DefaultInstanceManager.findLifecycleCallback(method, string, method2, PreDestroy.class);
    }

    private static Method findLifecycleCallback(Method method, String string, Method method2, Class<? extends Annotation> clazz) {
        Method method3 = method;
        if (string != null) {
            if (method2.getName().equals(string)) {
                if (!Introspection.isValidLifecycleCallback(method2)) {
                    throw new IllegalArgumentException("Invalid " + clazz.getName() + " annotation");
                }
                method3 = method2;
            }
        } else if (method2.isAnnotationPresent(clazz)) {
            if (method != null || !Introspection.isValidLifecycleCallback(method2)) {
                throw new IllegalArgumentException("Invalid " + clazz.getName() + " annotation");
            }
            method3 = method2;
        }
        return method3;
    }

    static {
        Class<?> clazz = null;
        try {
            clazz = Class.forName("javax.ejb.EJB");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        EJB_PRESENT = clazz != null;
        clazz = null;
        try {
            clazz = Class.forName("javax.persistence.PersistenceContext");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        JPA_PRESENT = clazz != null;
        clazz = null;
        try {
            clazz = Class.forName("javax.xml.ws.WebServiceRef");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        WS_PRESENT = clazz != null;
    }

    private static enum AnnotationCacheEntryType {
        FIELD,
        SETTER,
        POST_CONSTRUCT,
        PRE_DESTROY;

    }

    private static final class AnnotationCacheEntry {
        private final String accessibleObjectName;
        private final Class<?>[] paramTypes;
        private final String name;
        private final AnnotationCacheEntryType type;

        public AnnotationCacheEntry(String string, Class<?>[] classArray, String string2, AnnotationCacheEntryType annotationCacheEntryType) {
            this.accessibleObjectName = string;
            this.paramTypes = classArray;
            this.name = string2;
            this.type = annotationCacheEntryType;
        }

        public String getAccessibleObjectName() {
            return this.accessibleObjectName;
        }

        public Class<?>[] getParamTypes() {
            return this.paramTypes;
        }

        public String getName() {
            return this.name;
        }

        public AnnotationCacheEntryType getType() {
            return this.type;
        }
    }
}

