/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.mbeans;

import java.util.Hashtable;
import java.util.Set;
import javax.management.DynamicMBean;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Engine;
import org.apache.catalina.Group;
import org.apache.catalina.Host;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Realm;
import org.apache.catalina.Role;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.User;
import org.apache.catalina.UserDatabase;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.deploy.ContextEnvironment;
import org.apache.catalina.deploy.ContextResource;
import org.apache.catalina.deploy.ContextResourceLink;
import org.apache.catalina.deploy.NamingResources;
import org.apache.catalina.mbeans.MBeanFactory;
import org.apache.catalina.util.ContextName;
import org.apache.catalina.valves.ValveBase;
import org.apache.coyote.ProtocolHandler;
import org.apache.coyote.ajp.AjpAprProtocol;
import org.apache.coyote.ajp.AjpProtocol;
import org.apache.coyote.http11.Http11AprProtocol;
import org.apache.coyote.http11.Http11NioProtocol;
import org.apache.coyote.http11.Http11Protocol;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;

public class MBeanUtils {
    private static String[][] exceptions = new String[][]{{"org.apache.catalina.users.MemoryGroup", "Group"}, {"org.apache.catalina.users.MemoryRole", "Role"}, {"org.apache.catalina.users.MemoryUser", "User"}};
    private static Registry registry = MBeanUtils.createRegistry();
    private static MBeanServer mserver = MBeanUtils.createServer();
    @Deprecated
    static Hashtable<String, int[]> seq = new Hashtable();

    static String createManagedName(Object object) {
        String string = object.getClass().getName();
        for (String[] stringArray : exceptions) {
            if (!string.equals(stringArray[0])) continue;
            return stringArray[1];
        }
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public static DynamicMBean createMBean(ContextEnvironment contextEnvironment) throws Exception {
        String string = MBeanUtils.createManagedName(contextEnvironment);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception("ManagedBean is not found with " + string);
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)contextEnvironment);
        ObjectName objectName = MBeanUtils.createObjectName(string2, contextEnvironment);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    public static DynamicMBean createMBean(ContextResource contextResource) throws Exception {
        String string = MBeanUtils.createManagedName(contextResource);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception("ManagedBean is not found with " + string);
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)contextResource);
        ObjectName objectName = MBeanUtils.createObjectName(string2, contextResource);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    public static DynamicMBean createMBean(ContextResourceLink contextResourceLink) throws Exception {
        String string = MBeanUtils.createManagedName(contextResourceLink);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception("ManagedBean is not found with " + string);
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)contextResourceLink);
        ObjectName objectName = MBeanUtils.createObjectName(string2, contextResourceLink);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    static DynamicMBean createMBean(Group group) throws Exception {
        String string = MBeanUtils.createManagedName(group);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception("ManagedBean is not found with " + string);
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)group);
        ObjectName objectName = MBeanUtils.createObjectName(string2, group);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    @Deprecated
    static DynamicMBean createMBean(Loader loader) throws Exception {
        String string = MBeanUtils.createManagedName(loader);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception("ManagedBean is not found with " + string);
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)loader);
        ObjectName objectName = MBeanUtils.createObjectName(string2, loader);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    @Deprecated
    static DynamicMBean createMBean(MBeanFactory mBeanFactory) throws Exception {
        String string = MBeanUtils.createManagedName(mBeanFactory);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception("ManagedBean is not found with " + string);
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)mBeanFactory);
        ObjectName objectName = MBeanUtils.createObjectName(string2, mBeanFactory);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    @Deprecated
    static DynamicMBean createMBean(NamingResources namingResources) throws Exception {
        String string = MBeanUtils.createManagedName(namingResources);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception("ManagedBean is not found with " + string);
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)namingResources);
        ObjectName objectName = MBeanUtils.createObjectName(string2, namingResources);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    static DynamicMBean createMBean(Role role) throws Exception {
        String string = MBeanUtils.createManagedName(role);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception("ManagedBean is not found with " + string);
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)role);
        ObjectName objectName = MBeanUtils.createObjectName(string2, role);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    static DynamicMBean createMBean(User user) throws Exception {
        String string = MBeanUtils.createManagedName(user);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception("ManagedBean is not found with " + string);
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)user);
        ObjectName objectName = MBeanUtils.createObjectName(string2, user);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    static DynamicMBean createMBean(UserDatabase userDatabase) throws Exception {
        String string = MBeanUtils.createManagedName(userDatabase);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            Exception exception = new Exception("ManagedBean is not found with " + string);
            throw new MBeanException(exception);
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        DynamicMBean dynamicMBean = managedBean.createMBean((Object)userDatabase);
        ObjectName objectName = MBeanUtils.createObjectName(string2, userDatabase);
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
        mserver.registerMBean(dynamicMBean, objectName);
        return dynamicMBean;
    }

    @Deprecated
    static ObjectName createObjectName(String string, Connector connector) throws MalformedObjectNameException {
        ObjectName objectName = null;
        try {
            String string2;
            Object object = IntrospectionUtils.getProperty((Object)connector, (String)"address");
            Integer n = (Integer)IntrospectionUtils.getProperty((Object)connector, (String)"port");
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.append(":type=Connector");
            stringBuilder.append(",port=");
            stringBuilder.append(n);
            if (object != null && (string2 = object.toString()).length() > 0) {
                stringBuilder.append(",address=");
                stringBuilder.append(ObjectName.quote(string2));
            }
            objectName = new ObjectName(stringBuilder.toString());
            return objectName;
        }
        catch (Exception exception) {
            MalformedObjectNameException malformedObjectNameException = new MalformedObjectNameException("Cannot create object name for " + connector);
            malformedObjectNameException.initCause(exception);
            throw malformedObjectNameException;
        }
    }

    @Deprecated
    static ObjectName createObjectName(String string, Context context) throws MalformedObjectNameException {
        ObjectName objectName = null;
        Host host = (Host)context.getParent();
        ContextName contextName = new ContextName(context.getName(), false);
        objectName = new ObjectName(string + ":j2eeType=WebModule,name=//" + host.getName() + contextName.getDisplayName() + ",J2EEApplication=none,J2EEServer=none");
        return objectName;
    }

    public static ObjectName createObjectName(String string, ContextEnvironment contextEnvironment) throws MalformedObjectNameException {
        ObjectName objectName = null;
        Object object = contextEnvironment.getNamingResources().getContainer();
        if (object instanceof Server) {
            objectName = new ObjectName(string + ":type=Environment,resourcetype=Global,name=" + contextEnvironment.getName());
        } else if (object instanceof Context) {
            Context context = (Context)object;
            ContextName contextName = new ContextName(context.getName(), false);
            Container container = context.getParent();
            objectName = new ObjectName(string + ":type=Environment,resourcetype=Context,context=" + contextName.getDisplayName() + ",host=" + container.getName() + ",name=" + contextEnvironment.getName());
        }
        return objectName;
    }

    public static ObjectName createObjectName(String string, ContextResource contextResource) throws MalformedObjectNameException {
        ObjectName objectName = null;
        String string2 = ObjectName.quote(contextResource.getName());
        Object object = contextResource.getNamingResources().getContainer();
        if (object instanceof Server) {
            objectName = new ObjectName(string + ":type=Resource,resourcetype=Global,class=" + contextResource.getType() + ",name=" + string2);
        } else if (object instanceof Context) {
            Context context = (Context)object;
            ContextName contextName = new ContextName(context.getName(), false);
            Container container = context.getParent();
            objectName = new ObjectName(string + ":type=Resource,resourcetype=Context,context=" + contextName.getDisplayName() + ",host=" + container.getName() + ",class=" + contextResource.getType() + ",name=" + string2);
        }
        return objectName;
    }

    public static ObjectName createObjectName(String string, ContextResourceLink contextResourceLink) throws MalformedObjectNameException {
        ObjectName objectName = null;
        String string2 = ObjectName.quote(contextResourceLink.getName());
        Object object = contextResourceLink.getNamingResources().getContainer();
        if (object instanceof Server) {
            objectName = new ObjectName(string + ":type=ResourceLink,resourcetype=Global,name=" + string2);
        } else if (object instanceof Context) {
            Context context = (Context)object;
            ContextName contextName = new ContextName(context.getName(), false);
            Container container = context.getParent();
            objectName = new ObjectName(string + ":type=ResourceLink,resourcetype=Context,context=" + contextName.getDisplayName() + ",host=" + container.getName() + ",name=" + string2);
        }
        return objectName;
    }

    @Deprecated
    static ObjectName createObjectName(String string, Engine engine) throws MalformedObjectNameException {
        ObjectName objectName = null;
        objectName = new ObjectName(string + ":type=Engine");
        return objectName;
    }

    static ObjectName createObjectName(String string, Group group) throws MalformedObjectNameException {
        ObjectName objectName = null;
        objectName = new ObjectName(string + ":type=Group,groupname=" + ObjectName.quote(group.getGroupname()) + ",database=" + group.getUserDatabase().getId());
        return objectName;
    }

    @Deprecated
    static ObjectName createObjectName(String string, Host host) throws MalformedObjectNameException {
        ObjectName objectName = null;
        objectName = new ObjectName(string + ":type=Host,host=" + host.getName());
        return objectName;
    }

    static ObjectName createObjectName(String string, Loader loader) throws MalformedObjectNameException {
        ObjectName objectName = null;
        Container container = loader.getContainer();
        if (container instanceof Engine) {
            objectName = new ObjectName(string + ":type=Loader");
        } else if (container instanceof Host) {
            objectName = new ObjectName(string + ":type=Loader,host=" + container.getName());
        } else if (container instanceof Context) {
            Context context = (Context)container;
            ContextName contextName = new ContextName(context.getName(), false);
            Container container2 = context.getParent();
            objectName = new ObjectName(string + ":type=Loader,context=" + contextName.getDisplayName() + ",host=" + container2.getName());
        }
        return objectName;
    }

    @Deprecated
    static ObjectName createObjectName(String string, Manager manager) throws MalformedObjectNameException {
        ObjectName objectName = null;
        Container container = manager.getContainer();
        if (container instanceof Engine) {
            objectName = new ObjectName(string + ":type=Manager");
        } else if (container instanceof Host) {
            objectName = new ObjectName(string + ":type=Manager,host=" + container.getName());
        } else if (container instanceof Context) {
            Context context = (Context)container;
            ContextName contextName = new ContextName(context.getName(), false);
            Container container2 = context.getParent();
            objectName = new ObjectName(string + ":type=Manager,context=" + contextName.getDisplayName() + ",host=" + container2.getName());
        }
        return objectName;
    }

    @Deprecated
    static ObjectName createObjectName(String string, NamingResources namingResources) throws MalformedObjectNameException {
        ObjectName objectName = null;
        Object object = namingResources.getContainer();
        if (object instanceof Server) {
            objectName = new ObjectName(string + ":type=NamingResources,resourcetype=Global");
        } else if (object instanceof Context) {
            Context context = (Context)object;
            ContextName contextName = new ContextName(context.getName(), false);
            Container container = context.getParent();
            objectName = new ObjectName(string + ":type=NamingResources,resourcetype=Context,context=" + contextName.getDisplayName() + ",host=" + container.getName());
        }
        return objectName;
    }

    @Deprecated
    static ObjectName createObjectName(String string, MBeanFactory mBeanFactory) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName(string + ":type=MBeanFactory");
        return objectName;
    }

    @Deprecated
    static ObjectName createObjectName(String string, Realm realm) throws MalformedObjectNameException {
        ObjectName objectName = null;
        Container container = realm.getContainer();
        if (container instanceof Engine) {
            objectName = new ObjectName(string + ":type=Realm");
        } else if (container instanceof Host) {
            objectName = new ObjectName(string + ":type=Realm,host=" + container.getName());
        } else if (container instanceof Context) {
            Context context = (Context)container;
            ContextName contextName = new ContextName(context.getName(), false);
            Container container2 = context.getParent();
            objectName = new ObjectName(string + ":type=Realm,context=" + contextName.getDisplayName() + ",host=" + container2.getName());
        }
        return objectName;
    }

    static ObjectName createObjectName(String string, Role role) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName(string + ":type=Role,rolename=" + ObjectName.quote(role.getRolename()) + ",database=" + role.getUserDatabase().getId());
        return objectName;
    }

    @Deprecated
    static ObjectName createObjectName(String string, Server server) throws MalformedObjectNameException {
        ObjectName objectName = null;
        objectName = new ObjectName(string + ":type=Server");
        return objectName;
    }

    @Deprecated
    static ObjectName createObjectName(String string, Service service) throws MalformedObjectNameException {
        ObjectName objectName = null;
        objectName = new ObjectName(string + ":type=Service,serviceName=" + service.getName());
        return objectName;
    }

    static ObjectName createObjectName(String string, User user) throws MalformedObjectNameException {
        ObjectName objectName = new ObjectName(string + ":type=User,username=" + ObjectName.quote(user.getUsername()) + ",database=" + user.getUserDatabase().getId());
        return objectName;
    }

    static ObjectName createObjectName(String string, UserDatabase userDatabase) throws MalformedObjectNameException {
        ObjectName objectName = null;
        objectName = new ObjectName(string + ":type=UserDatabase,database=" + userDatabase.getId());
        return objectName;
    }

    @Deprecated
    static ObjectName createObjectName(String string, Valve valve) throws MalformedObjectNameException {
        ObjectName objectName;
        if (valve instanceof ValveBase && (objectName = ((ValveBase)valve).getObjectName()) != null) {
            return objectName;
        }
        objectName = null;
        Container container = null;
        String string2 = valve.getClass().getName();
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            string2 = string2.substring(n + 1);
        }
        if (valve instanceof Contained) {
            container = ((Contained)((Object)valve)).getContainer();
        }
        if (container == null) {
            throw new MalformedObjectNameException("Cannot create mbean for non-contained valve " + valve);
        }
        if (container instanceof Engine) {
            String string3 = "";
            int n2 = MBeanUtils.getSeq(string3);
            String string4 = "";
            if (n2 > 0) {
                string4 = ",seq=" + n2;
            }
            objectName = new ObjectName(string + ":type=Valve,name=" + string2 + string4 + string3);
        } else if (container instanceof Host) {
            String string5 = ",host=" + container.getName();
            int n3 = MBeanUtils.getSeq(string5);
            String string6 = "";
            if (n3 > 0) {
                string6 = ",seq=" + n3;
            }
            objectName = new ObjectName(string + ":type=Valve,name=" + string2 + string6 + string5);
        } else if (container instanceof Context) {
            Context context = (Context)container;
            ContextName contextName = new ContextName(context.getName(), false);
            Container container2 = context.getParent();
            String string7 = ",context=" + contextName.getDisplayName() + ",host=" + container2.getName();
            int n4 = MBeanUtils.getSeq(string7);
            String string8 = "";
            if (n4 > 0) {
                string8 = ",seq=" + n4;
            }
            objectName = new ObjectName(string + ":type=Valve,name=" + string2 + string8 + string7);
        }
        return objectName;
    }

    @Deprecated
    static int getSeq(String string) {
        int[] nArray = seq.get(string);
        if (nArray == null) {
            nArray = new int[]{0};
            seq.put(string, nArray);
        } else {
            nArray[0] = nArray[0] + 1;
        }
        return nArray[0];
    }

    public static synchronized Registry createRegistry() {
        if (registry == null) {
            registry = Registry.getRegistry(null, null);
            ClassLoader classLoader = MBeanUtils.class.getClassLoader();
            registry.loadDescriptors("org.apache.catalina.mbeans", classLoader);
            registry.loadDescriptors("org.apache.catalina.authenticator", classLoader);
            registry.loadDescriptors("org.apache.catalina.core", classLoader);
            registry.loadDescriptors("org.apache.catalina", classLoader);
            registry.loadDescriptors("org.apache.catalina.deploy", classLoader);
            registry.loadDescriptors("org.apache.catalina.loader", classLoader);
            registry.loadDescriptors("org.apache.catalina.realm", classLoader);
            registry.loadDescriptors("org.apache.catalina.session", classLoader);
            registry.loadDescriptors("org.apache.catalina.startup", classLoader);
            registry.loadDescriptors("org.apache.catalina.users", classLoader);
            registry.loadDescriptors("org.apache.catalina.ha", classLoader);
            registry.loadDescriptors("org.apache.catalina.connector", classLoader);
            registry.loadDescriptors("org.apache.catalina.valves", classLoader);
        }
        return registry;
    }

    public static synchronized MBeanServer createServer() {
        if (mserver == null) {
            mserver = Registry.getRegistry(null, null).getMBeanServer();
        }
        return mserver;
    }

    @Deprecated
    static void destroyMBean(Connector connector, Service service) throws Exception {
        ObjectName objectName;
        String string = service.getContainer().getName();
        if (string == null) {
            string = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string, connector))) {
            mserver.unregisterMBean(objectName);
        }
        String string2 = null;
        ProtocolHandler protocolHandler = connector.getProtocolHandler();
        if (protocolHandler instanceof Http11Protocol) {
            string2 = ((Http11Protocol)protocolHandler).getName();
        } else if (protocolHandler instanceof Http11NioProtocol) {
            string2 = ((Http11NioProtocol)protocolHandler).getName();
        } else if (protocolHandler instanceof Http11AprProtocol) {
            string2 = ((Http11AprProtocol)protocolHandler).getName();
        } else if (protocolHandler instanceof AjpProtocol) {
            string2 = ((AjpProtocol)protocolHandler).getName();
        } else if (protocolHandler instanceof AjpAprProtocol) {
            string2 = ((AjpAprProtocol)protocolHandler).getName();
        }
        ObjectName objectName2 = new ObjectName(string + ":type=RequestProcessor,worker=" + string2 + ",*");
        Set<ObjectName> set = mserver.queryNames(objectName2, null);
        for (ObjectName objectName3 : set) {
            mserver.unregisterMBean(objectName3);
        }
    }

    @Deprecated
    static void destroyMBean(Context context) throws Exception {
        ObjectName objectName;
        String string = context.getParent().getParent().getName();
        if (string == null) {
            string = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string, context))) {
            mserver.unregisterMBean(objectName);
        }
    }

    public static void destroyMBean(ContextEnvironment contextEnvironment) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(contextEnvironment);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, contextEnvironment))) {
            mserver.unregisterMBean(objectName);
        }
    }

    public static void destroyMBean(ContextResource contextResource) throws Exception {
        ObjectName objectName;
        String string;
        ManagedBean managedBean;
        if ("org.apache.catalina.UserDatabase".equals(contextResource.getType())) {
            MBeanUtils.destroyMBeanUserDatabase(contextResource.getName());
        }
        if ((managedBean = registry.findManagedBean(string = MBeanUtils.createManagedName(contextResource))) == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, contextResource))) {
            mserver.unregisterMBean(objectName);
        }
    }

    public static void destroyMBean(ContextResourceLink contextResourceLink) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(contextResourceLink);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, contextResourceLink))) {
            mserver.unregisterMBean(objectName);
        }
    }

    @Deprecated
    static void destroyMBean(Engine engine) throws Exception {
        ObjectName objectName;
        String string = engine.getName();
        if (string == null) {
            string = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string, engine))) {
            mserver.unregisterMBean(objectName);
        }
    }

    static void destroyMBean(Group group) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(group);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, group))) {
            mserver.unregisterMBean(objectName);
        }
    }

    @Deprecated
    static void destroyMBean(Host host) throws Exception {
        ObjectName objectName;
        String string = host.getParent().getName();
        if (string == null) {
            string = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string, host))) {
            mserver.unregisterMBean(objectName);
        }
    }

    @Deprecated
    static void destroyMBean(Loader loader) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(loader);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, loader))) {
            mserver.unregisterMBean(objectName);
        }
    }

    @Deprecated
    static void destroyMBean(Manager manager) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(manager);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, manager))) {
            mserver.unregisterMBean(objectName);
        }
    }

    @Deprecated
    static void destroyMBean(NamingResources namingResources) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(namingResources);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, namingResources))) {
            mserver.unregisterMBean(objectName);
        }
    }

    @Deprecated
    static void destroyMBean(Realm realm) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(realm);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, realm))) {
            mserver.unregisterMBean(objectName);
        }
    }

    static void destroyMBean(Role role) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(role);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, role))) {
            mserver.unregisterMBean(objectName);
        }
    }

    @Deprecated
    static void destroyMBean(Server server) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(server);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, server))) {
            mserver.unregisterMBean(objectName);
        }
        if (mserver.isRegistered(objectName = new ObjectName("Catalina:type=StringCache"))) {
            mserver.unregisterMBean(objectName);
        }
        if (mserver.isRegistered(objectName = new ObjectName("Catalina:type=MBeanFactory"))) {
            mserver.unregisterMBean(objectName);
        }
    }

    @Deprecated
    static void destroyMBean(Service service) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(service);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, service))) {
            mserver.unregisterMBean(objectName);
        }
    }

    static void destroyMBean(User user) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(user);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, user))) {
            mserver.unregisterMBean(objectName);
        }
    }

    @Deprecated
    static void destroyMBean(UserDatabase userDatabase) throws Exception {
        ObjectName objectName;
        String string = MBeanUtils.createManagedName(userDatabase);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        if (mserver.isRegistered(objectName = MBeanUtils.createObjectName(string2, userDatabase))) {
            mserver.unregisterMBean(objectName);
        }
    }

    static void destroyMBeanUserDatabase(String string) throws Exception {
        ObjectName objectName = null;
        Set<ObjectName> set = null;
        objectName = new ObjectName("Users:type=Group,database=" + string + ",*");
        set = mserver.queryNames(objectName, null);
        for (ObjectName objectName2 : set) {
            mserver.unregisterMBean(objectName2);
        }
        objectName = new ObjectName("Users:type=Role,database=" + string + ",*");
        set = mserver.queryNames(objectName, null);
        for (ObjectName objectName2 : set) {
            mserver.unregisterMBean(objectName2);
        }
        objectName = new ObjectName("Users:type=User,database=" + string + ",*");
        set = mserver.queryNames(objectName, null);
        for (ObjectName objectName2 : set) {
            mserver.unregisterMBean(objectName2);
        }
        ObjectName objectName3 = new ObjectName("Users:type=UserDatabase,database=" + string);
        if (mserver.isRegistered(objectName3)) {
            mserver.unregisterMBean(objectName3);
        }
    }

    @Deprecated
    static void destroyMBean(Valve valve, Container container) throws Exception {
        ((Contained)((Object)valve)).setContainer(container);
        String string = MBeanUtils.createManagedName(valve);
        ManagedBean managedBean = registry.findManagedBean(string);
        if (managedBean == null) {
            return;
        }
        String string2 = managedBean.getDomain();
        if (string2 == null) {
            string2 = mserver.getDefaultDomain();
        }
        ObjectName objectName = MBeanUtils.createObjectName(string2, valve);
        try {
            ((Contained)((Object)valve)).setContainer(null);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable((Throwable)throwable);
        }
        if (mserver.isRegistered(objectName)) {
            mserver.unregisterMBean(objectName);
        }
    }

    @Deprecated
    public static String getDomain(Service service) {
        if (service == null) {
            return null;
        }
        String string = null;
        Container container = service.getContainer();
        if (container != null) {
            string = container.getName();
        }
        if (string == null) {
            string = service.getName();
        }
        return string;
    }

    @Deprecated
    public static String getDomain(Container container) {
        Container container2;
        String string = null;
        for (container2 = container; !(container2 instanceof Engine) && container2 != null; container2 = container2.getParent()) {
        }
        if (container2 != null) {
            string = container2.getName();
        }
        return string;
    }

    @Deprecated
    public static String getContainerKeyProperties(Container container) {
        Container container2 = container;
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (!(container2 instanceof Engine)) {
            if (container2 instanceof Wrapper) {
                stringBuilder.append(",servlet=");
                stringBuilder.append(container2.getName());
            } else if (container2 instanceof Context) {
                stringBuilder.append(",context=");
                ContextName contextName = new ContextName(container2.getName(), false);
                stringBuilder.append(contextName.getDisplayName());
            } else if (container2 instanceof Host) {
                stringBuilder.append(",host=");
                stringBuilder.append(container2.getName());
            } else {
                if (container2 == null) {
                    stringBuilder.append(",container");
                    stringBuilder.append(n++);
                    stringBuilder.append("=null");
                    break;
                }
                stringBuilder.append(",container");
                stringBuilder.append(n++);
                stringBuilder.append('=');
                stringBuilder.append(container2.getName());
            }
            container2 = container2.getParent();
        }
        return stringBuilder.toString();
    }
}

