/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.concurrent.Future;
import java.util.regex.Pattern;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.startup.UserDatabase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public final class UserConfig
implements LifecycleListener {
    private static final Log log = LogFactory.getLog(UserConfig.class);
    private String configClass = "org.apache.catalina.startup.ContextConfig";
    private String contextClass = "org.apache.catalina.core.StandardContext";
    private String directoryName = "public_html";
    private String homeBase = null;
    private Host host = null;
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.startup");
    private String userClass = "org.apache.catalina.startup.PasswdUserDatabase";
    Pattern allow = null;
    Pattern deny = null;

    public String getConfigClass() {
        return this.configClass;
    }

    public void setConfigClass(String string) {
        this.configClass = string;
    }

    public String getContextClass() {
        return this.contextClass;
    }

    public void setContextClass(String string) {
        this.contextClass = string;
    }

    public String getDirectoryName() {
        return this.directoryName;
    }

    public void setDirectoryName(String string) {
        this.directoryName = string;
    }

    public String getHomeBase() {
        return this.homeBase;
    }

    public void setHomeBase(String string) {
        this.homeBase = string;
    }

    public String getUserClass() {
        return this.userClass;
    }

    public void setUserClass(String string) {
        this.userClass = string;
    }

    public String getAllow() {
        if (this.allow == null) {
            return null;
        }
        return this.allow.toString();
    }

    public void setAllow(String string) {
        this.allow = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    public String getDeny() {
        if (this.deny == null) {
            return null;
        }
        return this.deny.toString();
    }

    public void setDeny(String string) {
        this.deny = string == null || string.length() == 0 ? null : Pattern.compile(string);
    }

    @Override
    public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
        try {
            this.host = (Host)lifecycleEvent.getLifecycle();
        }
        catch (ClassCastException classCastException) {
            log.error((Object)sm.getString("hostConfig.cce", new Object[]{lifecycleEvent.getLifecycle()}), (Throwable)classCastException);
            return;
        }
        if (lifecycleEvent.getType().equals("start")) {
            this.start();
        } else if (lifecycleEvent.getType().equals("stop")) {
            this.stop();
        }
    }

    private void deploy() {
        Object object;
        if (this.host.getLogger().isDebugEnabled()) {
            this.host.getLogger().debug((Object)sm.getString("userConfig.deploying"));
        }
        UserDatabase userDatabase = null;
        try {
            object = Class.forName(this.userClass);
            userDatabase = (UserDatabase)((Class)object).newInstance();
            userDatabase.setUserConfig(this);
        }
        catch (Exception exception) {
            this.host.getLogger().error((Object)sm.getString("userConfig.database"), (Throwable)exception);
            return;
        }
        object = this.host.getStartStopExecutor();
        ArrayList arrayList = new ArrayList();
        Enumeration<String> enumeration = userDatabase.getUsers();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!this.isDeployAllowed(string)) continue;
            String object2 = userDatabase.getHome(string);
            arrayList.add(object.submit(new DeployUserDirectory(this, string, object2)));
        }
        for (Future future : arrayList) {
            try {
                future.get();
            }
            catch (Exception exception) {
                this.host.getLogger().error((Object)sm.getString("userConfig.deploy.threaded.error"), (Throwable)exception);
            }
        }
    }

    private void deploy(String string, String string2) {
        String string3 = "/~" + string;
        if (this.host.findChild(string3) != null) {
            return;
        }
        File file = new File(string2, this.directoryName);
        if (!file.exists() || !file.isDirectory()) {
            return;
        }
        this.host.getLogger().info((Object)sm.getString("userConfig.deploy", new Object[]{string}));
        try {
            Class<?> clazz = Class.forName(this.contextClass);
            Context context = (Context)clazz.newInstance();
            context.setPath(string3);
            context.setDocBase(file.toString());
            clazz = Class.forName(this.configClass);
            LifecycleListener lifecycleListener = (LifecycleListener)clazz.newInstance();
            context.addLifecycleListener(lifecycleListener);
            this.host.addChild(context);
        }
        catch (Exception exception) {
            this.host.getLogger().error((Object)sm.getString("userConfig.error", new Object[]{string}), (Throwable)exception);
        }
    }

    private void start() {
        if (this.host.getLogger().isDebugEnabled()) {
            this.host.getLogger().debug((Object)sm.getString("userConfig.start"));
        }
        this.deploy();
    }

    private void stop() {
        if (this.host.getLogger().isDebugEnabled()) {
            this.host.getLogger().debug((Object)sm.getString("userConfig.stop"));
        }
    }

    private boolean isDeployAllowed(String string) {
        if (this.deny != null && this.deny.matcher(string).matches()) {
            return false;
        }
        if (this.allow != null) {
            return this.allow.matcher(string).matches();
        }
        return true;
    }

    private static class DeployUserDirectory
    implements Runnable {
        private UserConfig config;
        private String user;
        private String home;

        public DeployUserDirectory(UserConfig userConfig, String string, String string2) {
            this.config = userConfig;
            this.user = string;
            this.home = string2;
        }

        @Override
        public void run() {
            this.config.deploy(this.user, this.home);
        }
    }
}

