/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.Http11NioProcessor;
import org.apache.coyote.http11.upgrade.NioProcessor;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.UpgradeNioProcessor;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11NioProtocol
extends AbstractHttp11JsseProtocol<NioChannel> {
    private static final Log log = LogFactory.getLog(Http11NioProtocol.class);
    private Http11ConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public Http11NioProtocol() {
        this.endpoint = new NioEndpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((NioEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public NioEndpoint getEndpoint() {
        return (NioEndpoint)this.endpoint;
    }

    public void setPollerThreadCount(int n) {
        ((NioEndpoint)this.endpoint).setPollerThreadCount(n);
    }

    public int getPollerThreadCount() {
        return ((NioEndpoint)this.endpoint).getPollerThreadCount();
    }

    public void setSelectorTimeout(long l) {
        ((NioEndpoint)this.endpoint).setSelectorTimeout(l);
    }

    public long getSelectorTimeout() {
        return ((NioEndpoint)this.endpoint).getSelectorTimeout();
    }

    public void setAcceptorThreadPriority(int n) {
        ((NioEndpoint)this.endpoint).setAcceptorThreadPriority(n);
    }

    public void setPollerThreadPriority(int n) {
        ((NioEndpoint)this.endpoint).setPollerThreadPriority(n);
    }

    public int getAcceptorThreadPriority() {
        return ((NioEndpoint)this.endpoint).getAcceptorThreadPriority();
    }

    public int getPollerThreadPriority() {
        return ((NioEndpoint)this.endpoint).getThreadPriority();
    }

    public boolean getUseSendfile() {
        return ((NioEndpoint)this.endpoint).getUseSendfile();
    }

    public void setUseSendfile(boolean bl) {
        ((NioEndpoint)this.endpoint).setUseSendfile(bl);
    }

    public void setOomParachute(int n) {
        ((NioEndpoint)this.endpoint).setOomParachute(n);
    }

    @Override
    protected String getNamePrefix() {
        return "http-nio";
    }

    protected static class Http11ConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler<NioChannel, Http11NioProcessor>
    implements NioEndpoint.Handler {
        protected Http11NioProtocol proto;

        Http11ConnectionHandler(Http11NioProtocol http11NioProtocol) {
            this.proto = http11NioProtocol;
        }

        @Override
        protected AbstractProtocol<NioChannel> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return this.proto.sslImplementation;
        }

        @Override
        public void release(SocketChannel socketChannel) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Iterating through our connections to release a socket channel:" + socketChannel));
            }
            boolean bl = false;
            Iterator iterator = this.connections.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (((NioChannel)entry.getKey()).getIOChannel() != socketChannel) continue;
                iterator.remove();
                Processor processor = (Processor)entry.getValue();
                processor.recycle(true);
                this.unregister(processor);
                bl = true;
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Done iterating through our connections to release a socket channel:" + socketChannel + " released:" + bl));
            }
        }

        @Override
        public void release(SocketWrapper<NioChannel> socketWrapper) {
            Processor processor = (Processor)this.connections.remove(socketWrapper.getSocket());
            if (processor != null) {
                processor.recycle(true);
                if (!processor.isUpgrade()) {
                    this.recycledProcessors.offer(processor);
                }
            }
        }

        @Override
        public void release(SocketWrapper<NioChannel> socketWrapper, Processor<NioChannel> processor, boolean bl, boolean bl2) {
            processor.recycle(bl);
            this.recycledProcessors.offer(processor);
            if (bl2) {
                socketWrapper.setTimeout(this.getProtocol().getKeepAliveTimeout());
                socketWrapper.getSocket().getPoller().add(socketWrapper.getSocket());
            }
        }

        @Override
        protected void initSsl(SocketWrapper<NioChannel> socketWrapper, Processor<NioChannel> processor) {
            if (this.proto.isSSLEnabled() && this.proto.sslImplementation != null && socketWrapper.getSocket() instanceof SecureNioChannel) {
                SecureNioChannel secureNioChannel = (SecureNioChannel)socketWrapper.getSocket();
                processor.setSslSupport(this.proto.sslImplementation.getSSLSupport(secureNioChannel.getSslEngine().getSession()));
            } else {
                processor.setSslSupport(null);
            }
        }

        @Override
        protected void longPoll(SocketWrapper<NioChannel> socketWrapper, Processor<NioChannel> processor) {
            if (processor.isAsync()) {
                socketWrapper.setAsync(true);
            } else {
                socketWrapper.getSocket().getPoller().add(socketWrapper.getSocket());
            }
        }

        @Override
        public Http11NioProcessor createProcessor() {
            Http11NioProcessor http11NioProcessor = new Http11NioProcessor(this.proto.getMaxHttpHeaderSize(), this.proto.getRejectIllegalHeader(), (NioEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize(), this.proto.getAllowedTrailerHeadersAsSet(), this.proto.getMaxExtensionSize(), this.proto.getMaxSwallowSize(), this.proto.getRelaxedPathChars(), this.proto.getRelaxedQueryChars());
            this.proto.configureProcessor(http11NioProcessor);
            this.register(http11NioProcessor);
            return http11NioProcessor;
        }

        @Override
        @Deprecated
        protected Processor<NioChannel> createUpgradeProcessor(SocketWrapper<NioChannel> socketWrapper, UpgradeInbound upgradeInbound) throws IOException {
            return new UpgradeNioProcessor(socketWrapper, upgradeInbound, ((Http11NioProtocol)this.getProtocol()).getEndpoint().getSelectorPool());
        }

        @Override
        protected Processor<NioChannel> createUpgradeProcessor(SocketWrapper<NioChannel> socketWrapper, HttpUpgradeHandler httpUpgradeHandler) throws IOException {
            return new NioProcessor(socketWrapper, httpUpgradeHandler, this.proto.getEndpoint().getSelectorPool(), this.proto.getUpgradeAsyncWriteBufferSize());
        }
    }
}

