/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Selector;
import org.apache.coyote.http11.upgrade.AbstractServletInputStream;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SocketWrapper;

public class NioServletInputStream
extends AbstractServletInputStream {
    private final NioChannel channel;
    private final NioSelectorPool pool;

    public NioServletInputStream(SocketWrapper<NioChannel> socketWrapper, NioSelectorPool nioSelectorPool) {
        this.channel = socketWrapper.getSocket();
        this.pool = nioSelectorPool;
    }

    @Override
    protected boolean doIsReady() throws IOException {
        ByteBuffer byteBuffer = this.channel.getBufHandler().getReadBuffer();
        if (byteBuffer.remaining() > 0) {
            return true;
        }
        byteBuffer.clear();
        this.fillReadBuffer(false);
        boolean bl = byteBuffer.position() > 0;
        byteBuffer.flip();
        return bl;
    }

    @Override
    protected int doRead(boolean bl, byte[] byArray, int n, int n2) throws IOException {
        ByteBuffer byteBuffer = this.channel.getBufHandler().getReadBuffer();
        int n3 = byteBuffer.remaining();
        if (n3 >= n2) {
            byteBuffer.get(byArray, n, n2);
            return n2;
        }
        int n4 = n2;
        int n5 = n;
        if (n3 > 0) {
            byteBuffer.get(byArray, n, n3);
            n4 -= n3;
            n5 += n3;
        }
        byteBuffer.clear();
        int n6 = this.fillReadBuffer(bl);
        if (n6 > 0) {
            byteBuffer.flip();
            if (n6 > n4) {
                byteBuffer.get(byArray, n5, n4);
                n4 = 0;
            } else {
                byteBuffer.get(byArray, n5, n6);
                n4 -= n6;
            }
        } else if (n6 == 0) {
            byteBuffer.flip();
        } else if (n6 == -1) {
            throw new EOFException();
        }
        return n2 - n4;
    }

    @Override
    protected void doClose() throws IOException {
        this.channel.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int fillReadBuffer(boolean bl) throws IOException {
        int n;
        if (bl) {
            Selector selector = null;
            try {
                selector = this.pool.get();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                NioEndpoint.KeyAttachment keyAttachment = (NioEndpoint.KeyAttachment)this.channel.getAttachment();
                if (keyAttachment == null) {
                    throw new IOException("Key must be cancelled.");
                }
                n = this.pool.read(this.channel.getBufHandler().getReadBuffer(), this.channel, selector, keyAttachment.getTimeout());
            }
            catch (EOFException eOFException) {
                n = -1;
            }
            finally {
                if (selector != null) {
                    this.pool.put(selector);
                }
            }
        } else {
            n = this.channel.read(this.channel.getBufHandler().getReadBuffer());
        }
        return n;
    }
}

