/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

public final class Ascii {
    private static final byte[] toUpper;
    private static final byte[] toLower;
    private static final boolean[] isAlpha;
    private static final boolean[] isUpper;
    private static final boolean[] isLower;
    private static final boolean[] isWhite;
    private static final boolean[] isDigit;
    private static final long OVERFLOW_LIMIT = 0xCCCCCCCCCCCCCCCL;

    @Deprecated
    public static int toUpper(int n) {
        return toUpper[n & 0xFF] & 0xFF;
    }

    public static int toLower(int n) {
        return toLower[n & 0xFF] & 0xFF;
    }

    @Deprecated
    public static boolean isAlpha(int n) {
        return isAlpha[n & 0xFF];
    }

    @Deprecated
    public static boolean isUpper(int n) {
        return isUpper[n & 0xFF];
    }

    @Deprecated
    public static boolean isLower(int n) {
        return isLower[n & 0xFF];
    }

    @Deprecated
    public static boolean isWhite(int n) {
        return isWhite[n & 0xFF];
    }

    public static boolean isDigit(int n) {
        return isDigit[n & 0xFF];
    }

    @Deprecated
    public static int parseInt(byte[] byArray, int n, int n2) throws NumberFormatException {
        byte by;
        if (byArray == null || n2 <= 0 || !Ascii.isDigit(by = byArray[n++])) {
            throw new NumberFormatException();
        }
        int n3 = by - 48;
        while (--n2 > 0) {
            if (!Ascii.isDigit(by = byArray[n++])) {
                throw new NumberFormatException();
            }
            n3 = n3 * 10 + by - 48;
        }
        return n3;
    }

    @Deprecated
    public static int parseInt(char[] cArray, int n, int n2) throws NumberFormatException {
        char c;
        if (cArray == null || n2 <= 0 || !Ascii.isDigit(c = cArray[n++])) {
            throw new NumberFormatException();
        }
        int n3 = c - 48;
        while (--n2 > 0) {
            if (!Ascii.isDigit(c = cArray[n++])) {
                throw new NumberFormatException();
            }
            n3 = n3 * 10 + c - 48;
        }
        return n3;
    }

    public static long parseLong(byte[] byArray, int n, int n2) throws NumberFormatException {
        byte by;
        if (byArray == null || n2 <= 0 || !Ascii.isDigit(by = byArray[n++])) {
            throw new NumberFormatException();
        }
        long l = by - 48;
        while (--n2 > 0) {
            if (Ascii.isDigit(by = byArray[n++]) && (l < 0xCCCCCCCCCCCCCCCL || l == 0xCCCCCCCCCCCCCCCL && by - 48 < 8)) {
                l = l * 10L + (long)by - 48L;
                continue;
            }
            throw new NumberFormatException();
        }
        return l;
    }

    @Deprecated
    public static long parseLong(char[] cArray, int n, int n2) throws NumberFormatException {
        char c;
        if (cArray == null || n2 <= 0 || !Ascii.isDigit(c = cArray[n++])) {
            throw new NumberFormatException();
        }
        long l = c - 48;
        while (--n2 > 0) {
            if (!Ascii.isDigit(c = cArray[n++])) {
                throw new NumberFormatException();
            }
            long l2 = l * 10L + (long)c - 48L;
            if (l2 < l) {
                throw new NumberFormatException();
            }
            l = l2;
        }
        return l;
    }

    static {
        int n;
        toUpper = new byte[256];
        toLower = new byte[256];
        isAlpha = new boolean[256];
        isUpper = new boolean[256];
        isLower = new boolean[256];
        isWhite = new boolean[256];
        isDigit = new boolean[256];
        for (n = 0; n < 256; ++n) {
            Ascii.toUpper[n] = (byte)n;
            Ascii.toLower[n] = (byte)n;
        }
        for (n = 97; n <= 122; ++n) {
            int n2 = n + 65 - 97;
            Ascii.toUpper[n] = (byte)n2;
            Ascii.toLower[n2] = (byte)n;
            Ascii.isAlpha[n] = true;
            Ascii.isAlpha[n2] = true;
            Ascii.isLower[n] = true;
            Ascii.isUpper[n2] = true;
        }
        Ascii.isWhite[32] = true;
        Ascii.isWhite[9] = true;
        Ascii.isWhite[13] = true;
        Ascii.isWhite[10] = true;
        Ascii.isWhite[12] = true;
        Ascii.isWhite[8] = true;
        for (n = 48; n <= 57; ++n) {
            Ascii.isDigit[n] = true;
        }
    }
}

