/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.X509KeyManager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioSelectorPool;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SSLUtil;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SendfileKeepAliveState;
import org.apache.tomcat.util.net.SendfileState;
import org.apache.tomcat.util.net.SocketProperties;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.net.jsse.NioX509KeyManager;

public class NioEndpoint
extends AbstractEndpoint<NioChannel> {
    private static final Log log = LogFactory.getLog(NioEndpoint.class);
    public static final int OP_REGISTER = 256;
    public static final int OP_CALLBACK = 512;
    protected NioSelectorPool selectorPool = new NioSelectorPool();
    protected ServerSocketChannel serverSock = null;
    protected boolean useSendfile = true;
    protected int oomParachute = 0x100000;
    protected byte[] oomParachuteData = null;
    protected static final String oomParachuteMsg = "SEVERE:Memory usage is low, parachute is non existent, your system may start failing.";
    long lastParachuteCheck = System.currentTimeMillis();
    protected volatile CountDownLatch stopLatch = null;
    protected ConcurrentLinkedQueue<SocketProcessor> processorCache = new ConcurrentLinkedQueue<SocketProcessor>(){
        private static final long serialVersionUID = 1L;
        protected AtomicInteger size = new AtomicInteger(0);

        @Override
        public boolean offer(SocketProcessor socketProcessor) {
            boolean bl;
            socketProcessor.reset(null, null);
            boolean bl2 = NioEndpoint.this.socketProperties.getProcessorCache() == -1 ? true : (bl = this.size.get() < NioEndpoint.this.socketProperties.getProcessorCache());
            if (NioEndpoint.this.running && !NioEndpoint.this.paused && bl) {
                boolean bl3 = super.offer(socketProcessor);
                if (bl3) {
                    this.size.incrementAndGet();
                }
                return bl3;
            }
            return false;
        }

        @Override
        public SocketProcessor poll() {
            SocketProcessor socketProcessor = (SocketProcessor)super.poll();
            if (socketProcessor != null) {
                this.size.decrementAndGet();
            }
            return socketProcessor;
        }

        @Override
        public void clear() {
            super.clear();
            this.size.set(0);
        }
    };
    protected ConcurrentLinkedQueue<KeyAttachment> keyCache = new ConcurrentLinkedQueue<KeyAttachment>(){
        private static final long serialVersionUID = 1L;
        protected AtomicInteger size = new AtomicInteger(0);

        @Override
        public boolean offer(KeyAttachment keyAttachment) {
            boolean bl;
            keyAttachment.reset();
            boolean bl2 = NioEndpoint.this.socketProperties.getKeyCache() == -1 ? true : (bl = this.size.get() < NioEndpoint.this.socketProperties.getKeyCache());
            if (NioEndpoint.this.running && !NioEndpoint.this.paused && bl) {
                boolean bl3 = super.offer(keyAttachment);
                if (bl3) {
                    this.size.incrementAndGet();
                }
                return bl3;
            }
            return false;
        }

        @Override
        public KeyAttachment poll() {
            KeyAttachment keyAttachment = (KeyAttachment)super.poll();
            if (keyAttachment != null) {
                this.size.decrementAndGet();
            }
            return keyAttachment;
        }

        @Override
        public void clear() {
            super.clear();
            this.size.set(0);
        }
    };
    protected ConcurrentLinkedQueue<PollerEvent> eventCache = new ConcurrentLinkedQueue<PollerEvent>(){
        private static final long serialVersionUID = 1L;
        protected AtomicInteger size = new AtomicInteger(0);

        @Override
        public boolean offer(PollerEvent pollerEvent) {
            boolean bl;
            pollerEvent.reset();
            boolean bl2 = NioEndpoint.this.socketProperties.getEventCache() == -1 ? true : (bl = this.size.get() < NioEndpoint.this.socketProperties.getEventCache());
            if (NioEndpoint.this.running && !NioEndpoint.this.paused && bl) {
                boolean bl3 = super.offer(pollerEvent);
                if (bl3) {
                    this.size.incrementAndGet();
                }
                return bl3;
            }
            return false;
        }

        @Override
        public PollerEvent poll() {
            PollerEvent pollerEvent = (PollerEvent)super.poll();
            if (pollerEvent != null) {
                this.size.decrementAndGet();
            }
            return pollerEvent;
        }

        @Override
        public void clear() {
            super.clear();
            this.size.set(0);
        }
    };
    protected ConcurrentLinkedQueue<NioChannel> nioChannels = new ConcurrentLinkedQueue<NioChannel>(){
        private static final long serialVersionUID = 1L;
        protected AtomicInteger size = new AtomicInteger(0);
        protected AtomicInteger bytes = new AtomicInteger(0);

        @Override
        public boolean offer(NioChannel nioChannel) {
            boolean bl = NioEndpoint.this.socketProperties.getBufferPool() == -1 ? true : this.size.get() < NioEndpoint.this.socketProperties.getBufferPool();
            boolean bl2 = bl = bl && (NioEndpoint.this.socketProperties.getBufferPoolSize() == -1 || this.bytes.get() + nioChannel.getBufferSize() < NioEndpoint.this.socketProperties.getBufferPoolSize());
            if (NioEndpoint.this.running && !NioEndpoint.this.paused && bl) {
                boolean bl3 = super.offer(nioChannel);
                if (bl3) {
                    this.size.incrementAndGet();
                    this.bytes.addAndGet(nioChannel.getBufferSize());
                }
                return bl3;
            }
            return false;
        }

        @Override
        public NioChannel poll() {
            NioChannel nioChannel = (NioChannel)super.poll();
            if (nioChannel != null) {
                this.size.decrementAndGet();
                this.bytes.addAndGet(-nioChannel.getBufferSize());
            }
            return nioChannel;
        }

        @Override
        public void clear() {
            super.clear();
            this.size.set(0);
            this.bytes.set(0);
        }
    };
    protected int pollerThreadPriority = 5;
    protected Handler handler = null;
    protected boolean useComet = true;
    protected int pollerThreadCount = Math.min(2, Runtime.getRuntime().availableProcessors());
    protected long selectorTimeout = 1000L;
    protected Poller[] pollers = null;
    protected AtomicInteger pollerRotater = new AtomicInteger(0);
    protected SSLContext sslContext = null;
    private String[] enabledCiphers;
    private String[] enabledProtocols;

    @Override
    public boolean setProperty(String string, String string2) {
        try {
            if (string.startsWith("selectorPool.")) {
                return IntrospectionUtils.setProperty(this.selectorPool, string.substring("selectorPool.".length()), string2);
            }
            return super.setProperty(string, string2);
        }
        catch (Exception exception) {
            log.error((Object)("Unable to set attribute \"" + string + "\" to \"" + string2 + "\""), (Throwable)exception);
            return false;
        }
    }

    public void setPollerThreadPriority(int n) {
        this.pollerThreadPriority = n;
    }

    public int getPollerThreadPriority() {
        return this.pollerThreadPriority;
    }

    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void setUseComet(boolean bl) {
        this.useComet = bl;
    }

    @Override
    public boolean getUseComet() {
        return this.useComet;
    }

    @Override
    public boolean getUseCometTimeout() {
        return this.getUseComet();
    }

    @Override
    public boolean getUsePolling() {
        return true;
    }

    public void setPollerThreadCount(int n) {
        this.pollerThreadCount = n;
    }

    public int getPollerThreadCount() {
        return this.pollerThreadCount;
    }

    public void setSelectorTimeout(long l) {
        this.selectorTimeout = l;
    }

    public long getSelectorTimeout() {
        return this.selectorTimeout;
    }

    public Poller getPoller0() {
        int n = Math.abs(this.pollerRotater.incrementAndGet()) % this.pollers.length;
        return this.pollers[n];
    }

    public void setSelectorPool(NioSelectorPool nioSelectorPool) {
        this.selectorPool = nioSelectorPool;
    }

    public void setSocketProperties(SocketProperties socketProperties) {
        this.socketProperties = socketProperties;
    }

    public void setUseSendfile(boolean bl) {
        this.useSendfile = bl;
    }

    @Override
    public boolean getDeferAccept() {
        return false;
    }

    public void setOomParachute(int n) {
        this.oomParachute = n;
    }

    public void setOomParachuteData(byte[] byArray) {
        this.oomParachuteData = byArray;
    }

    public SSLContext getSSLContext() {
        return this.sslContext;
    }

    public void setSSLContext(SSLContext sSLContext) {
        this.sslContext = sSLContext;
    }

    @Override
    public int getLocalPort() {
        ServerSocketChannel serverSocketChannel = this.serverSock;
        if (serverSocketChannel == null) {
            return -1;
        }
        ServerSocket serverSocket = serverSocketChannel.socket();
        if (serverSocket == null) {
            return -1;
        }
        return serverSocket.getLocalPort();
    }

    protected void checkParachute() {
        boolean bl = this.reclaimParachute(false);
        if (!bl && System.currentTimeMillis() - this.lastParachuteCheck > 10000L) {
            try {
                log.fatal((Object)oomParachuteMsg);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                System.err.println(oomParachuteMsg);
            }
            this.lastParachuteCheck = System.currentTimeMillis();
        }
    }

    protected boolean reclaimParachute(boolean bl) {
        if (this.oomParachuteData != null) {
            return true;
        }
        if (this.oomParachute > 0 && (bl || Runtime.getRuntime().freeMemory() > (long)(this.oomParachute * 2))) {
            this.oomParachuteData = new byte[this.oomParachute];
        }
        return this.oomParachuteData != null;
    }

    protected void releaseCaches() {
        this.keyCache.clear();
        this.nioChannels.clear();
        this.processorCache.clear();
        if (this.handler != null) {
            this.handler.recycle();
        }
    }

    public int getKeepAliveCount() {
        if (this.pollers == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < this.pollers.length; ++i) {
            n += this.pollers[i].getKeyCount();
        }
        return n;
    }

    @Override
    public void bind() throws Exception {
        this.serverSock = ServerSocketChannel.open();
        this.socketProperties.setProperties(this.serverSock.socket());
        InetSocketAddress inetSocketAddress = this.getAddress() != null ? new InetSocketAddress(this.getAddress(), this.getPort()) : new InetSocketAddress(this.getPort());
        this.serverSock.socket().bind(inetSocketAddress, this.getBacklog());
        this.serverSock.configureBlocking(true);
        if (this.getSocketProperties().getSoTimeout() >= 0) {
            this.serverSock.socket().setSoTimeout(this.getSocketProperties().getSoTimeout());
        }
        if (this.acceptorThreadCount == 0) {
            this.acceptorThreadCount = 1;
        }
        if (this.pollerThreadCount <= 0) {
            this.pollerThreadCount = 1;
        }
        this.stopLatch = new CountDownLatch(this.pollerThreadCount);
        if (this.isSSLEnabled()) {
            SSLUtil sSLUtil = this.handler.getSslImplementation().getSSLUtil(this);
            this.sslContext = sSLUtil.createSSLContext();
            this.sslContext.init(this.wrap(sSLUtil.getKeyManagers()), sSLUtil.getTrustManagers(), null);
            SSLSessionContext sSLSessionContext = this.sslContext.getServerSessionContext();
            if (sSLSessionContext != null) {
                sSLUtil.configureSessionContext(sSLSessionContext);
            }
            this.enabledCiphers = sSLUtil.getEnableableCiphers(this.sslContext);
            this.enabledProtocols = sSLUtil.getEnableableProtocols(this.sslContext);
        }
        if (this.oomParachute > 0) {
            this.reclaimParachute(true);
        }
        this.selectorPool.open();
    }

    public KeyManager[] wrap(KeyManager[] keyManagerArray) {
        if (keyManagerArray == null) {
            return null;
        }
        KeyManager[] keyManagerArray2 = new KeyManager[keyManagerArray.length];
        for (int i = 0; i < keyManagerArray2.length; ++i) {
            if (keyManagerArray[i] instanceof X509KeyManager && this.getKeyAlias() != null) {
                String string = this.getKeyAlias();
                if ("jks".equalsIgnoreCase(this.getKeystoreType())) {
                    string = string.toLowerCase(Locale.ENGLISH);
                }
                keyManagerArray2[i] = new NioX509KeyManager((X509KeyManager)keyManagerArray[i], string);
                continue;
            }
            keyManagerArray2[i] = keyManagerArray[i];
        }
        return keyManagerArray2;
    }

    @Override
    public void startInternal() throws Exception {
        if (!this.running) {
            this.running = true;
            this.paused = false;
            if (this.getExecutor() == null) {
                this.createExecutor();
            }
            this.initializeConnectionLatch();
            this.pollers = new Poller[this.getPollerThreadCount()];
            for (int i = 0; i < this.pollers.length; ++i) {
                this.pollers[i] = new Poller();
                Thread thread = new Thread((Runnable)this.pollers[i], this.getName() + "-ClientPoller-" + i);
                thread.setPriority(this.threadPriority);
                thread.setDaemon(true);
                thread.start();
            }
            this.startAcceptorThreads();
        }
    }

    @Override
    public void stopInternal() {
        this.releaseConnectionLatch();
        if (!this.paused) {
            this.pause();
        }
        if (this.running) {
            this.running = false;
            this.unlockAccept();
            for (int i = 0; this.pollers != null && i < this.pollers.length; ++i) {
                if (this.pollers[i] == null) continue;
                this.pollers[i].destroy();
                this.pollers[i] = null;
            }
            try {
                if (!this.stopLatch.await(this.selectorTimeout + 100L, TimeUnit.MILLISECONDS)) {
                    log.warn((Object)sm.getString("endpoint.nio.stopLatchAwaitFail"));
                }
            }
            catch (InterruptedException interruptedException) {
                log.warn((Object)sm.getString("endpoint.nio.stopLatchAwaitInterrupted"), (Throwable)interruptedException);
            }
        }
        this.eventCache.clear();
        this.keyCache.clear();
        this.nioChannels.clear();
        this.processorCache.clear();
        this.shutdownExecutor();
    }

    @Override
    public void unbind() throws Exception {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy initiated for " + new InetSocketAddress(this.getAddress(), this.getPort())));
        }
        if (this.running) {
            this.stop();
        }
        this.serverSock.socket().close();
        this.serverSock.close();
        this.serverSock = null;
        this.sslContext = null;
        this.releaseCaches();
        this.selectorPool.close();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Destroy completed for " + new InetSocketAddress(this.getAddress(), this.getPort())));
        }
    }

    public int getWriteBufSize() {
        return this.socketProperties.getTxBufSize();
    }

    public int getReadBufSize() {
        return this.socketProperties.getRxBufSize();
    }

    public NioSelectorPool getSelectorPool() {
        return this.selectorPool;
    }

    @Override
    public boolean getUseSendfile() {
        return this.useSendfile;
    }

    public int getOomParachute() {
        return this.oomParachute;
    }

    public byte[] getOomParachuteData() {
        return this.oomParachuteData;
    }

    @Override
    protected AbstractEndpoint.Acceptor createAcceptor() {
        return new Acceptor();
    }

    protected boolean setSocketOptions(SocketChannel socketChannel) {
        try {
            socketChannel.configureBlocking(false);
            Socket socket = socketChannel.socket();
            this.socketProperties.setProperties(socket);
            NioChannel nioChannel = this.nioChannels.poll();
            if (nioChannel == null) {
                if (this.sslContext != null) {
                    SSLEngine sSLEngine = this.createSSLEngine();
                    int n = sSLEngine.getSession().getApplicationBufferSize();
                    NioBufferHandler nioBufferHandler = new NioBufferHandler(Math.max(n, this.socketProperties.getAppReadBufSize()), Math.max(n, this.socketProperties.getAppWriteBufSize()), this.socketProperties.getDirectBuffer());
                    nioChannel = new SecureNioChannel(socketChannel, sSLEngine, nioBufferHandler, this.selectorPool);
                } else {
                    NioBufferHandler nioBufferHandler = new NioBufferHandler(this.socketProperties.getAppReadBufSize(), this.socketProperties.getAppWriteBufSize(), this.socketProperties.getDirectBuffer());
                    nioChannel = new NioChannel(socketChannel, nioBufferHandler);
                }
            } else {
                nioChannel.setIOChannel(socketChannel);
                if (nioChannel instanceof SecureNioChannel) {
                    SSLEngine sSLEngine = this.createSSLEngine();
                    ((SecureNioChannel)nioChannel).reset(sSLEngine);
                } else {
                    nioChannel.reset();
                }
            }
            this.getPoller0().register(nioChannel);
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            try {
                log.error((Object)"", throwable);
            }
            catch (Throwable throwable2) {
                ExceptionUtils.handleThrowable(throwable2);
            }
            return false;
        }
        return true;
    }

    protected SSLEngine createSSLEngine() {
        SSLEngine sSLEngine = this.sslContext.createSSLEngine();
        if ("false".equals(this.getClientAuth())) {
            sSLEngine.setNeedClientAuth(false);
            sSLEngine.setWantClientAuth(false);
        } else if ("true".equals(this.getClientAuth()) || "yes".equals(this.getClientAuth())) {
            sSLEngine.setNeedClientAuth(true);
        } else if ("want".equals(this.getClientAuth())) {
            sSLEngine.setWantClientAuth(true);
        }
        sSLEngine.setUseClientMode(false);
        sSLEngine.setEnabledCipherSuites(this.enabledCiphers);
        sSLEngine.setEnabledProtocols(this.enabledProtocols);
        this.configureUseServerCipherSuitesOrder(sSLEngine);
        return sSLEngine;
    }

    protected boolean isWorkerAvailable() {
        return true;
    }

    @Override
    public void processSocketAsync(SocketWrapper<NioChannel> socketWrapper, SocketStatus socketStatus) {
        this.dispatchForEvent(socketWrapper.getSocket(), socketStatus, true);
    }

    public boolean dispatchForEvent(NioChannel nioChannel, SocketStatus socketStatus, boolean bl) {
        if (bl && socketStatus == SocketStatus.OPEN_READ) {
            nioChannel.getPoller().add(nioChannel, 512);
        } else {
            this.processSocket(nioChannel, socketStatus, bl);
        }
        return true;
    }

    public boolean processSocket(NioChannel nioChannel, SocketStatus socketStatus, boolean bl) {
        try {
            KeyAttachment keyAttachment = (KeyAttachment)nioChannel.getAttachment();
            if (keyAttachment == null) {
                return false;
            }
            keyAttachment.setCometNotify(false);
            SocketProcessor socketProcessor = this.processorCache.poll();
            if (socketProcessor == null) {
                socketProcessor = new SocketProcessor(nioChannel, socketStatus);
            } else {
                socketProcessor.reset(nioChannel, socketStatus);
            }
            if (bl && this.getExecutor() != null) {
                this.getExecutor().execute(socketProcessor);
            } else {
                socketProcessor.run();
            }
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            log.warn((Object)("Socket processing request was rejected for:" + nioChannel), (Throwable)rejectedExecutionException);
            return false;
        }
        catch (Throwable throwable) {
            ExceptionUtils.handleThrowable(throwable);
            log.error((Object)sm.getString("endpoint.process.fail"), throwable);
            return false;
        }
        return true;
    }

    @Override
    public void removeWaitingRequest(SocketWrapper<NioChannel> socketWrapper) {
    }

    @Override
    protected Log getLog() {
        return log;
    }

    private void closeSocket(SocketChannel socketChannel) {
        block5: {
            block4: {
                try {
                    socketChannel.socket().close();
                }
                catch (IOException iOException) {
                    if (!log.isDebugEnabled()) break block4;
                    log.debug((Object)"", (Throwable)iOException);
                }
            }
            try {
                socketChannel.close();
            }
            catch (IOException iOException) {
                if (!log.isDebugEnabled()) break block5;
                log.debug((Object)"", (Throwable)iOException);
            }
        }
    }

    public static class SendfileData {
        public volatile String fileName;
        public volatile FileChannel fchannel;
        public volatile long pos;
        public volatile long length;
        public SendfileKeepAliveState keepAliveState = SendfileKeepAliveState.NONE;
    }

    protected class SocketProcessor
    implements Runnable {
        protected NioChannel socket = null;
        protected SocketStatus status = null;

        public SocketProcessor(NioChannel nioChannel, SocketStatus socketStatus) {
            this.reset(nioChannel, socketStatus);
        }

        public void reset(NioChannel nioChannel, SocketStatus socketStatus) {
            this.socket = nioChannel;
            this.status = socketStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SelectionKey selectionKey = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
            KeyAttachment keyAttachment = null;
            if (selectionKey != null) {
                keyAttachment = (KeyAttachment)selectionKey.attachment();
            }
            if (keyAttachment != null && keyAttachment.isUpgraded() && SocketStatus.OPEN_WRITE == this.status) {
                Object object = keyAttachment.getWriteThreadLock();
                synchronized (object) {
                    this.doRun(selectionKey, keyAttachment);
                }
            }
            NioChannel nioChannel = this.socket;
            synchronized (nioChannel) {
                this.doRun(selectionKey, keyAttachment);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doRun(SelectionKey selectionKey, KeyAttachment keyAttachment) {
            try {
                int n = -1;
                try {
                    if (selectionKey != null) {
                        if (this.socket.isHandshakeComplete() || this.status == SocketStatus.STOP) {
                            n = 0;
                        } else {
                            n = this.socket.handshake(selectionKey.isReadable(), selectionKey.isWritable());
                            this.status = SocketStatus.OPEN_READ;
                        }
                    }
                }
                catch (IOException iOException) {
                    n = -1;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Error during SSL handshake", (Throwable)iOException);
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {
                    n = -1;
                }
                if (n == 0) {
                    AbstractEndpoint.Handler.SocketState socketState = AbstractEndpoint.Handler.SocketState.OPEN;
                    socketState = this.status == null ? NioEndpoint.this.handler.process(keyAttachment, SocketStatus.OPEN_READ) : NioEndpoint.this.handler.process(keyAttachment, this.status);
                    if (socketState == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.close(keyAttachment, this.socket, selectionKey, SocketStatus.ERROR);
                    }
                } else if (n == -1) {
                    this.close(keyAttachment, this.socket, selectionKey, SocketStatus.DISCONNECT);
                } else {
                    keyAttachment.getPoller().add(this.socket, n);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                this.socket.getPoller().cancelledKey(selectionKey, null, false);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                try {
                    NioEndpoint.this.oomParachuteData = null;
                    log.error((Object)"", (Throwable)outOfMemoryError);
                    if (this.socket != null) {
                        this.socket.getPoller().cancelledKey(selectionKey, SocketStatus.ERROR, false);
                    }
                    NioEndpoint.this.releaseCaches();
                }
                catch (Throwable throwable) {
                    try {
                        System.err.println(NioEndpoint.oomParachuteMsg);
                        throwable.printStackTrace();
                    }
                    catch (Throwable throwable2) {
                        ExceptionUtils.handleThrowable(throwable2);
                    }
                }
            }
            catch (VirtualMachineError virtualMachineError) {
                ExceptionUtils.handleThrowable(virtualMachineError);
            }
            catch (Throwable throwable) {
                log.error((Object)"", throwable);
                if (this.socket != null) {
                    this.socket.getPoller().cancelledKey(selectionKey, SocketStatus.ERROR, false);
                }
            }
            finally {
                this.socket = null;
                this.status = null;
                if (NioEndpoint.this.running && !NioEndpoint.this.paused) {
                    NioEndpoint.this.processorCache.offer(this);
                }
            }
        }

        private void close(KeyAttachment keyAttachment, NioChannel nioChannel, SelectionKey selectionKey, SocketStatus socketStatus) {
            try {
                if (keyAttachment != null) {
                    keyAttachment.setComet(false);
                }
                if (nioChannel.getPoller().cancelledKey(selectionKey, socketStatus, false) != null) {
                    if (NioEndpoint.this.running && !NioEndpoint.this.paused) {
                        NioEndpoint.this.nioChannels.offer(nioChannel);
                    }
                    if (NioEndpoint.this.running && !NioEndpoint.this.paused && keyAttachment != null) {
                        NioEndpoint.this.keyCache.offer(keyAttachment);
                    }
                }
            }
            catch (Exception exception) {
                log.error((Object)"", (Throwable)exception);
            }
        }
    }

    public static interface Handler
    extends AbstractEndpoint.Handler {
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<NioChannel> var1, SocketStatus var2);

        public void release(SocketWrapper<NioChannel> var1);

        public void release(SocketChannel var1);

        public SSLImplementation getSslImplementation();

        public boolean isAvailable(SocketWrapper<NioChannel> var1);
    }

    public static class NioBufferHandler
    implements SecureNioChannel.ApplicationBufferHandler {
        protected ByteBuffer readbuf = null;
        protected ByteBuffer writebuf = null;

        public NioBufferHandler(int n, int n2, boolean bl) {
            if (bl) {
                this.readbuf = ByteBuffer.allocateDirect(n);
                this.writebuf = ByteBuffer.allocateDirect(n2);
            } else {
                this.readbuf = ByteBuffer.allocate(n);
                this.writebuf = ByteBuffer.allocate(n2);
            }
        }

        @Override
        public ByteBuffer expand(ByteBuffer byteBuffer, int n) {
            return byteBuffer;
        }

        @Override
        public ByteBuffer getReadBuffer() {
            return this.readbuf;
        }

        @Override
        public ByteBuffer getWriteBuffer() {
            return this.writebuf;
        }
    }

    public static class KeyAttachment
    extends SocketWrapper<NioChannel> {
        protected Poller poller = null;
        protected int interestOps = 0;
        protected boolean comet = false;
        protected int cometOps = 1;
        protected boolean cometNotify = false;
        protected CountDownLatch readLatch = null;
        protected CountDownLatch writeLatch = null;
        protected volatile SendfileData sendfileData = null;
        private long writeTimeout = -1L;

        public KeyAttachment(NioChannel nioChannel) {
            super(nioChannel);
        }

        public void reset(Poller poller, NioChannel nioChannel, long l) {
            int n;
            super.reset(nioChannel, l);
            this.cometNotify = false;
            this.cometOps = 1;
            this.interestOps = 0;
            this.poller = poller;
            this.lastRegistered = 0L;
            this.sendfileData = null;
            if (this.readLatch != null) {
                try {
                    for (n = 0; n < (int)this.readLatch.getCount(); ++n) {
                        this.readLatch.countDown();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.readLatch = null;
            this.sendfileData = null;
            if (this.writeLatch != null) {
                try {
                    for (n = 0; n < (int)this.writeLatch.getCount(); ++n) {
                        this.writeLatch.countDown();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.writeLatch = null;
            this.setWriteTimeout(l);
        }

        public void reset() {
            this.reset(null, null, -1L);
        }

        public Poller getPoller() {
            return this.poller;
        }

        public void setPoller(Poller poller) {
            this.poller = poller;
        }

        public void setCometNotify(boolean bl) {
            this.cometNotify = bl;
        }

        public boolean getCometNotify() {
            return this.cometNotify;
        }

        @Deprecated
        public void setCometOps(int n) {
            this.cometOps = n;
        }

        @Deprecated
        public int getCometOps() {
            return this.cometOps;
        }

        public NioChannel getChannel() {
            return (NioChannel)this.getSocket();
        }

        public void setChannel(NioChannel nioChannel) {
            this.socket = nioChannel;
        }

        public int interestOps() {
            return this.interestOps;
        }

        public int interestOps(int n) {
            this.interestOps = n;
            return n;
        }

        public CountDownLatch getReadLatch() {
            return this.readLatch;
        }

        public CountDownLatch getWriteLatch() {
            return this.writeLatch;
        }

        protected CountDownLatch resetLatch(CountDownLatch countDownLatch) {
            if (countDownLatch == null || countDownLatch.getCount() == 0L) {
                return null;
            }
            throw new IllegalStateException("Latch must be at count 0");
        }

        public void resetReadLatch() {
            this.readLatch = this.resetLatch(this.readLatch);
        }

        public void resetWriteLatch() {
            this.writeLatch = this.resetLatch(this.writeLatch);
        }

        protected CountDownLatch startLatch(CountDownLatch countDownLatch, int n) {
            if (countDownLatch == null || countDownLatch.getCount() == 0L) {
                return new CountDownLatch(n);
            }
            throw new IllegalStateException("Latch must be at count 0 or null.");
        }

        public void startReadLatch(int n) {
            this.readLatch = this.startLatch(this.readLatch, n);
        }

        public void startWriteLatch(int n) {
            this.writeLatch = this.startLatch(this.writeLatch, n);
        }

        protected void awaitLatch(CountDownLatch countDownLatch, long l, TimeUnit timeUnit) throws InterruptedException {
            if (countDownLatch == null) {
                throw new IllegalStateException("Latch cannot be null");
            }
            countDownLatch.await(l, timeUnit);
        }

        public void awaitReadLatch(long l, TimeUnit timeUnit) throws InterruptedException {
            this.awaitLatch(this.readLatch, l, timeUnit);
        }

        public void awaitWriteLatch(long l, TimeUnit timeUnit) throws InterruptedException {
            this.awaitLatch(this.writeLatch, l, timeUnit);
        }

        @Deprecated
        public long getLastRegistered() {
            return this.lastRegistered;
        }

        @Deprecated
        public void setLastRegistered(long l) {
            this.lastRegistered = l;
        }

        public void setSendfileData(SendfileData sendfileData) {
            this.sendfileData = sendfileData;
        }

        public SendfileData getSendfileData() {
            return this.sendfileData;
        }

        public void setWriteTimeout(long l) {
            this.writeTimeout = l;
        }

        public long getWriteTimeout() {
            return this.writeTimeout;
        }
    }

    public class Poller
    implements Runnable {
        protected Selector selector;
        protected ConcurrentLinkedQueue<Runnable> events = new ConcurrentLinkedQueue();
        protected volatile boolean close = false;
        protected long nextExpiration = 0L;
        protected AtomicLong wakeupCounter = new AtomicLong(0L);
        protected volatile int keyCount = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Poller() throws IOException {
            Class<Selector> clazz = Selector.class;
            synchronized (Selector.class) {
                this.selector = Selector.open();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public int getKeyCount() {
            return this.keyCount;
        }

        public Selector getSelector() {
            return this.selector;
        }

        NioEndpoint getEndpoint() {
            return NioEndpoint.this;
        }

        protected void destroy() {
            this.close = true;
            this.selector.wakeup();
        }

        @Deprecated
        public void addEvent(Runnable runnable) {
            this.events.offer(runnable);
            if (this.wakeupCounter.incrementAndGet() == 0L) {
                this.selector.wakeup();
            }
        }

        @Deprecated
        public void cometInterest(NioChannel nioChannel) {
            KeyAttachment keyAttachment = (KeyAttachment)nioChannel.getAttachment();
            this.add(nioChannel, keyAttachment.getCometOps());
            if ((keyAttachment.getCometOps() & 0x200) == 512) {
                this.nextExpiration = 0L;
                this.selector.wakeup();
            }
        }

        public void add(NioChannel nioChannel) {
            this.add(nioChannel, 1);
        }

        public void add(NioChannel nioChannel, int n) {
            PollerEvent pollerEvent = NioEndpoint.this.eventCache.poll();
            if (pollerEvent == null) {
                pollerEvent = new PollerEvent(nioChannel, null, n);
            } else {
                pollerEvent.reset(nioChannel, null, n);
            }
            this.addEvent(pollerEvent);
            if (this.close) {
                NioEndpoint.this.processSocket(nioChannel, SocketStatus.STOP, false);
            }
        }

        public boolean events() {
            boolean bl = false;
            Runnable runnable = null;
            int n = this.events.size();
            for (int i = 0; i < n && (runnable = this.events.poll()) != null; ++i) {
                bl = true;
                try {
                    runnable.run();
                    if (!(runnable instanceof PollerEvent)) continue;
                    ((PollerEvent)runnable).reset();
                    NioEndpoint.this.eventCache.offer((PollerEvent)runnable);
                    continue;
                }
                catch (Throwable throwable) {
                    log.error((Object)"", throwable);
                }
            }
            return bl;
        }

        public void register(NioChannel nioChannel) {
            nioChannel.setPoller(this);
            KeyAttachment keyAttachment = NioEndpoint.this.keyCache.poll();
            KeyAttachment keyAttachment2 = keyAttachment != null ? keyAttachment : new KeyAttachment(nioChannel);
            keyAttachment2.reset(this, nioChannel, NioEndpoint.this.getSocketProperties().getSoTimeout());
            keyAttachment2.setKeepAliveLeft(NioEndpoint.this.getMaxKeepAliveRequests());
            keyAttachment2.setSecure(NioEndpoint.this.isSSLEnabled());
            PollerEvent pollerEvent = NioEndpoint.this.eventCache.poll();
            keyAttachment2.interestOps(1);
            if (pollerEvent == null) {
                pollerEvent = new PollerEvent(nioChannel, keyAttachment2, 256);
            } else {
                pollerEvent.reset(nioChannel, keyAttachment2, 256);
            }
            this.addEvent(pollerEvent);
        }

        public KeyAttachment cancelledKey(SelectionKey selectionKey, SocketStatus socketStatus, boolean bl) {
            KeyAttachment keyAttachment;
            block22: {
                keyAttachment = null;
                try {
                    block21: {
                        block20: {
                            if (selectionKey == null) {
                                return null;
                            }
                            keyAttachment = (KeyAttachment)selectionKey.attachment();
                            if (keyAttachment != null && keyAttachment.isComet() && socketStatus != null) {
                                keyAttachment.setComet(false);
                                if (socketStatus == SocketStatus.TIMEOUT) {
                                    if (NioEndpoint.this.processSocket(keyAttachment.getChannel(), socketStatus, true)) {
                                        return null;
                                    }
                                } else {
                                    NioEndpoint.this.processSocket(keyAttachment.getChannel(), socketStatus, false);
                                }
                            }
                            if ((keyAttachment = (KeyAttachment)selectionKey.attach(null)) != null) {
                                NioEndpoint.this.handler.release(keyAttachment);
                            } else {
                                NioEndpoint.this.handler.release((SocketChannel)selectionKey.channel());
                            }
                            if (selectionKey.isValid()) {
                                selectionKey.cancel();
                            }
                            if (keyAttachment != null) {
                                try {
                                    ((NioChannel)keyAttachment.getSocket()).close(true);
                                }
                                catch (Exception exception) {
                                    if (!log.isDebugEnabled()) break block20;
                                    log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.socketCloseFail"), (Throwable)exception);
                                }
                            }
                        }
                        if (selectionKey.channel().isOpen()) {
                            try {
                                selectionKey.channel().close();
                            }
                            catch (Exception exception) {
                                if (!log.isDebugEnabled()) break block21;
                                log.debug((Object)AbstractEndpoint.sm.getString("endpoint.debug.channelCloseFail"), (Throwable)exception);
                            }
                        }
                    }
                    try {
                        if (keyAttachment != null && keyAttachment.getSendfileData() != null && keyAttachment.getSendfileData().fchannel != null && keyAttachment.getSendfileData().fchannel.isOpen()) {
                            keyAttachment.getSendfileData().fchannel.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (keyAttachment != null) {
                        keyAttachment.reset();
                        NioEndpoint.this.countDownConnection();
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    if (!log.isDebugEnabled()) break block22;
                    log.error((Object)"", throwable);
                }
            }
            return keyAttachment;
        }

        @Override
        public void run() {
            block16: while (true) {
                try {
                    while (true) {
                        Iterator<SelectionKey> iterator;
                        if (NioEndpoint.this.paused && !this.close) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {}
                            continue;
                        }
                        boolean bl = false;
                        if (this.close) {
                            this.events();
                            this.timeout(0, false);
                            try {
                                this.selector.close();
                            }
                            catch (IOException iOException) {
                                log.error((Object)AbstractEndpoint.sm.getString("endpoint.nio.selectorCloseFail"), (Throwable)iOException);
                            }
                            break block16;
                        }
                        bl = this.events();
                        try {
                            if (!this.close) {
                                this.keyCount = this.wakeupCounter.getAndSet(-1L) > 0L ? this.selector.selectNow() : this.selector.select(NioEndpoint.this.selectorTimeout);
                                this.wakeupCounter.set(0L);
                            }
                            if (this.close) {
                                this.events();
                                this.timeout(0, false);
                                try {
                                    this.selector.close();
                                }
                                catch (IOException iOException) {
                                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.nio.selectorCloseFail"), (Throwable)iOException);
                                }
                                break block16;
                            }
                        }
                        catch (NullPointerException nullPointerException) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)nullPointerException);
                            }
                            if (this.wakeupCounter != null && this.selector != null) continue;
                            throw nullPointerException;
                        }
                        catch (CancelledKeyException cancelledKeyException) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"Possibly encountered sun bug 5076772 on windows JDK 1.5", (Throwable)cancelledKeyException);
                            }
                            if (this.wakeupCounter != null && this.selector != null) continue;
                            throw cancelledKeyException;
                        }
                        catch (Throwable throwable) {
                            ExceptionUtils.handleThrowable(throwable);
                            log.error((Object)"", throwable);
                            continue;
                        }
                        if (this.keyCount == 0) {
                            bl |= this.events();
                        }
                        Iterator<SelectionKey> iterator2 = iterator = this.keyCount > 0 ? this.selector.selectedKeys().iterator() : null;
                        while (iterator != null && iterator.hasNext()) {
                            SelectionKey selectionKey = iterator.next();
                            KeyAttachment keyAttachment = (KeyAttachment)selectionKey.attachment();
                            if (keyAttachment == null) {
                                iterator.remove();
                                continue;
                            }
                            keyAttachment.access();
                            iterator.remove();
                            this.processKey(selectionKey, keyAttachment);
                        }
                        this.timeout(this.keyCount, bl);
                        if (NioEndpoint.this.oomParachute <= 0 || NioEndpoint.this.oomParachuteData != null) continue;
                        NioEndpoint.this.checkParachute();
                    }
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    try {
                        NioEndpoint.this.oomParachuteData = null;
                        NioEndpoint.this.releaseCaches();
                        log.error((Object)"", (Throwable)outOfMemoryError);
                    }
                    catch (Throwable throwable) {
                        try {
                            System.err.println(NioEndpoint.oomParachuteMsg);
                            throwable.printStackTrace();
                        }
                        catch (Throwable throwable2) {
                            ExceptionUtils.handleThrowable(throwable2);
                        }
                    }
                    continue;
                }
                break;
            }
            NioEndpoint.this.stopLatch.countDown();
        }

        protected boolean processKey(SelectionKey selectionKey, KeyAttachment keyAttachment) {
            boolean bl = true;
            try {
                if (this.close) {
                    this.cancelledKey(selectionKey, SocketStatus.STOP, keyAttachment.comet);
                } else if (selectionKey.isValid() && keyAttachment != null) {
                    keyAttachment.access();
                    selectionKey.attach(keyAttachment);
                    NioChannel nioChannel = keyAttachment.getChannel();
                    if (selectionKey.isReadable() || selectionKey.isWritable()) {
                        if (keyAttachment.getSendfileData() != null) {
                            this.processSendfile(selectionKey, keyAttachment, false);
                        } else if (NioEndpoint.this.isWorkerAvailable()) {
                            this.unreg(selectionKey, keyAttachment, selectionKey.readyOps());
                            boolean bl2 = false;
                            if (selectionKey.isReadable() && !NioEndpoint.this.processSocket(nioChannel, SocketStatus.OPEN_READ, true)) {
                                bl2 = true;
                            }
                            if (!bl2 && selectionKey.isWritable() && !NioEndpoint.this.processSocket(nioChannel, SocketStatus.OPEN_WRITE, true)) {
                                bl2 = true;
                            }
                            if (bl2) {
                                this.cancelledKey(selectionKey, SocketStatus.DISCONNECT, false);
                            }
                        } else {
                            bl = false;
                        }
                    }
                } else {
                    this.cancelledKey(selectionKey, SocketStatus.ERROR, false);
                }
            }
            catch (CancelledKeyException cancelledKeyException) {
                this.cancelledKey(selectionKey, SocketStatus.ERROR, false);
            }
            catch (Throwable throwable) {
                ExceptionUtils.handleThrowable(throwable);
                log.error((Object)"", throwable);
            }
            return bl;
        }

        public SendfileState processSendfile(SelectionKey selectionKey, KeyAttachment keyAttachment, boolean bl) {
            NioChannel nioChannel = null;
            try {
                Object object;
                this.unreg(selectionKey, keyAttachment, selectionKey.readyOps());
                SendfileData sendfileData = keyAttachment.getSendfileData();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Processing send file for: " + sendfileData.fileName));
                }
                if (sendfileData.fchannel == null) {
                    object = new File(sendfileData.fileName);
                    FileInputStream fileInputStream = new FileInputStream((File)object);
                    sendfileData.fchannel = fileInputStream.getChannel();
                }
                Object object2 = object = (nioChannel = keyAttachment.getChannel()) instanceof SecureNioChannel ? nioChannel : nioChannel.getIOChannel();
                if (nioChannel.getOutboundRemaining() > 0) {
                    if (nioChannel.flushOutbound()) {
                        keyAttachment.access();
                    }
                } else {
                    long l = sendfileData.fchannel.transferTo(sendfileData.pos, sendfileData.length, (WritableByteChannel)object);
                    if (l > 0L) {
                        sendfileData.pos += l;
                        sendfileData.length -= l;
                        keyAttachment.access();
                    } else if (sendfileData.fchannel.size() <= sendfileData.pos) {
                        throw new IOException("Sendfile configured to send more data than was available");
                    }
                }
                if (sendfileData.length <= 0L && nioChannel.getOutboundRemaining() <= 0) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Send file complete for: " + sendfileData.fileName));
                    }
                    keyAttachment.setSendfileData(null);
                    try {
                        sendfileData.fchannel.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!bl) {
                        switch (sendfileData.keepAliveState) {
                            case NONE: {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Send file connection is being closed");
                                }
                                this.cancelledKey(selectionKey, SocketStatus.STOP, false);
                                break;
                            }
                            case PIPELINED: {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Connection is keep alive, processing pipe-lined data");
                                }
                                if (NioEndpoint.this.processSocket(nioChannel, SocketStatus.OPEN_READ, true)) break;
                                this.cancelledKey(selectionKey, SocketStatus.DISCONNECT, false);
                                break;
                            }
                            case OPEN: {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)"Connection is keep alive, registering back for OP_READ");
                                }
                                this.reg(selectionKey, keyAttachment, 1);
                            }
                        }
                    }
                    return SendfileState.DONE;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("OP_WRITE for sendfile: " + sendfileData.fileName));
                }
                if (bl) {
                    this.add(keyAttachment.getChannel(), 4);
                } else {
                    this.reg(selectionKey, keyAttachment, 4);
                }
                return SendfileState.PENDING;
            }
            catch (IOException iOException) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Unable to complete sendfile request:", (Throwable)iOException);
                }
                if (!bl) {
                    this.cancelledKey(selectionKey, SocketStatus.ERROR, false);
                }
                return SendfileState.ERROR;
            }
            catch (Throwable throwable) {
                log.error((Object)"", throwable);
                if (!bl) {
                    this.cancelledKey(selectionKey, SocketStatus.ERROR, false);
                }
                return SendfileState.ERROR;
            }
        }

        protected void unreg(SelectionKey selectionKey, KeyAttachment keyAttachment, int n) {
            this.reg(selectionKey, keyAttachment, selectionKey.interestOps() & ~n);
        }

        protected void reg(SelectionKey selectionKey, KeyAttachment keyAttachment, int n) {
            selectionKey.interestOps(n);
            keyAttachment.interestOps(n);
            keyAttachment.setCometOps(n);
        }

        protected void timeout(int n, boolean bl) {
            long l = System.currentTimeMillis();
            if ((n > 0 || bl) && l < this.nextExpiration && !this.close) {
                return;
            }
            Set<SelectionKey> set = this.selector.keys();
            int n2 = 0;
            try {
                for (SelectionKey selectionKey : set) {
                    ++n2;
                    try {
                        boolean bl2;
                        long l2;
                        long l3;
                        KeyAttachment keyAttachment = (KeyAttachment)selectionKey.attachment();
                        if (keyAttachment == null) {
                            this.cancelledKey(selectionKey, SocketStatus.ERROR, false);
                            continue;
                        }
                        if (keyAttachment.getError()) {
                            this.cancelledKey(selectionKey, SocketStatus.ERROR, true);
                            continue;
                        }
                        if (keyAttachment.isComet() && keyAttachment.getCometNotify()) {
                            keyAttachment.setCometNotify(false);
                            this.reg(selectionKey, keyAttachment, 0);
                            if (NioEndpoint.this.processSocket(keyAttachment.getChannel(), SocketStatus.OPEN_READ, true)) continue;
                            NioEndpoint.this.processSocket(keyAttachment.getChannel(), SocketStatus.DISCONNECT, true);
                            continue;
                        }
                        if ((keyAttachment.interestOps() & 1) == 1 || (keyAttachment.interestOps() & 4) == 4) {
                            l3 = l - keyAttachment.getLastAccess();
                            l2 = keyAttachment.getTimeout();
                            boolean bl3 = bl2 = l2 > 0L && l3 > l2;
                            if (this.close) {
                                selectionKey.interestOps(0);
                                keyAttachment.interestOps(0);
                                this.processKey(selectionKey, keyAttachment);
                                continue;
                            }
                            if (!bl2) continue;
                            selectionKey.interestOps(0);
                            keyAttachment.interestOps(0);
                            this.cancelledKey(selectionKey, SocketStatus.TIMEOUT, true);
                            continue;
                        }
                        if (!keyAttachment.isAsync() && !keyAttachment.isComet()) continue;
                        if (this.close) {
                            selectionKey.interestOps(0);
                            keyAttachment.interestOps(0);
                            this.processKey(selectionKey, keyAttachment);
                            continue;
                        }
                        if (!keyAttachment.isAsync() || keyAttachment.getTimeout() > 0L) {
                            l3 = l - keyAttachment.getLastAccess();
                            bl2 = l3 > (l2 = keyAttachment.getTimeout() == -1L ? (long)NioEndpoint.this.socketProperties.getSoTimeout() : keyAttachment.getTimeout());
                            if (!bl2) continue;
                            keyAttachment.access(Long.MAX_VALUE);
                            NioEndpoint.this.processSocket(keyAttachment.getChannel(), SocketStatus.TIMEOUT, true);
                            continue;
                        }
                        if (!keyAttachment.isAsync() || NioEndpoint.this.handler.isAvailable(keyAttachment)) continue;
                        keyAttachment.access(Long.MAX_VALUE);
                        NioEndpoint.this.processSocket(keyAttachment.getChannel(), SocketStatus.TIMEOUT, true);
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        this.cancelledKey(selectionKey, SocketStatus.ERROR, false);
                    }
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                log.warn((Object)AbstractEndpoint.sm.getString("endpoint.nio.timeoutCme"), (Throwable)concurrentModificationException);
            }
            long l4 = this.nextExpiration;
            this.nextExpiration = System.currentTimeMillis() + NioEndpoint.this.socketProperties.getTimeoutInterval();
            if (log.isTraceEnabled()) {
                log.trace((Object)("timeout completed: keys processed=" + n2 + "; now=" + l + "; nextExpiration=" + l4 + "; keyCount=" + n + "; hasEvents=" + bl + "; eval=" + (l < l4 && (n > 0 || bl) && !this.close)));
            }
        }
    }

    public static class PollerEvent
    implements Runnable {
        protected NioChannel socket;
        protected int interestOps;
        protected KeyAttachment key;

        public PollerEvent(NioChannel nioChannel, KeyAttachment keyAttachment, int n) {
            this.reset(nioChannel, keyAttachment, n);
        }

        public void reset(NioChannel nioChannel, KeyAttachment keyAttachment, int n) {
            this.socket = nioChannel;
            this.interestOps = n;
            this.key = keyAttachment;
        }

        public void reset() {
            this.reset(null, null, 0);
        }

        @Override
        public void run() {
            if (this.interestOps == 256) {
                try {
                    this.socket.getIOChannel().register(this.socket.getPoller().getSelector(), 1, this.key);
                }
                catch (Exception exception) {
                    log.error((Object)"", (Throwable)exception);
                }
            } else {
                SelectionKey selectionKey = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
                try {
                    if (selectionKey == null) {
                        this.socket.getPoller().getEndpoint().countDownConnection();
                    } else {
                        KeyAttachment keyAttachment = (KeyAttachment)selectionKey.attachment();
                        if (keyAttachment != null) {
                            if (keyAttachment.isComet() && (this.interestOps & 0x200) == 512) {
                                keyAttachment.setCometNotify(true);
                            } else {
                                keyAttachment.setCometNotify(false);
                            }
                            this.interestOps &= 0xFFFFFDFF;
                            keyAttachment.access();
                            int n = selectionKey.interestOps() | this.interestOps;
                            keyAttachment.interestOps(n);
                            selectionKey.interestOps(n);
                        } else {
                            this.socket.getPoller().cancelledKey(selectionKey, SocketStatus.ERROR, false);
                        }
                    }
                }
                catch (CancelledKeyException cancelledKeyException) {
                    try {
                        this.socket.getPoller().cancelledKey(selectionKey, SocketStatus.DISCONNECT, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        public String toString() {
            return super.toString() + "[intOps=" + this.interestOps + "]";
        }
    }

    protected class Acceptor
    extends AbstractEndpoint.Acceptor {
        protected Acceptor() {
        }

        @Override
        public void run() {
            int n = 0;
            while (NioEndpoint.this.running) {
                while (NioEndpoint.this.paused && NioEndpoint.this.running) {
                    this.state = AbstractEndpoint.Acceptor.AcceptorState.PAUSED;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (!NioEndpoint.this.running) break;
                this.state = AbstractEndpoint.Acceptor.AcceptorState.RUNNING;
                try {
                    NioEndpoint.this.countUpOrAwaitConnection();
                    SocketChannel socketChannel = null;
                    try {
                        socketChannel = NioEndpoint.this.serverSock.accept();
                    }
                    catch (IOException iOException) {
                        NioEndpoint.this.countDownConnection();
                        n = NioEndpoint.this.handleExceptionWithDelay(n);
                        throw iOException;
                    }
                    n = 0;
                    if (NioEndpoint.this.running && !NioEndpoint.this.paused) {
                        if (NioEndpoint.this.setSocketOptions(socketChannel)) continue;
                        NioEndpoint.this.countDownConnection();
                        NioEndpoint.this.closeSocket(socketChannel);
                        continue;
                    }
                    NioEndpoint.this.countDownConnection();
                    NioEndpoint.this.closeSocket(socketChannel);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
                catch (IOException iOException) {
                    if (!NioEndpoint.this.running) continue;
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), (Throwable)iOException);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    try {
                        NioEndpoint.this.oomParachuteData = null;
                        NioEndpoint.this.releaseCaches();
                        log.error((Object)"", (Throwable)outOfMemoryError);
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                System.err.println(NioEndpoint.oomParachuteMsg);
                                throwable.printStackTrace();
                            }
                            catch (Throwable throwable2) {
                                ExceptionUtils.handleThrowable(throwable2);
                            }
                        }
                        catch (Throwable throwable3) {
                            ExceptionUtils.handleThrowable(throwable3);
                        }
                    }
                }
                catch (Throwable throwable) {
                    ExceptionUtils.handleThrowable(throwable);
                    log.error((Object)AbstractEndpoint.sm.getString("endpoint.accept.fail"), throwable);
                }
            }
            this.state = AbstractEndpoint.Acceptor.AcceptorState.ENDED;
        }
    }
}

