/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.net;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioSelectorPool;

public class SecureNioChannel
extends NioChannel {
    protected static final Log log = LogFactory.getLog(SecureNioChannel.class);
    protected ByteBuffer netInBuffer;
    protected ByteBuffer netOutBuffer;
    protected SSLEngine sslEngine;
    protected boolean handshakeComplete = false;
    protected SSLEngineResult.HandshakeStatus handshakeStatus;
    protected boolean closed = false;
    protected boolean closing = false;
    protected NioSelectorPool pool;

    public SecureNioChannel(SocketChannel socketChannel, SSLEngine sSLEngine, ApplicationBufferHandler applicationBufferHandler, NioSelectorPool nioSelectorPool) throws IOException {
        super(socketChannel, applicationBufferHandler);
        this.sslEngine = sSLEngine;
        int n = this.sslEngine.getSession().getApplicationBufferSize();
        int n2 = this.sslEngine.getSession().getPacketBufferSize();
        if (this.netInBuffer == null) {
            this.netInBuffer = ByteBuffer.allocateDirect(n2);
        }
        if (this.netOutBuffer == null) {
            this.netOutBuffer = ByteBuffer.allocateDirect(n2);
        }
        this.pool = nioSelectorPool;
        applicationBufferHandler.expand(applicationBufferHandler.getReadBuffer(), n);
        applicationBufferHandler.expand(applicationBufferHandler.getWriteBuffer(), n);
        this.reset();
    }

    public void reset(SSLEngine sSLEngine) throws IOException {
        this.sslEngine = sSLEngine;
        this.reset();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.netOutBuffer.position(0);
        this.netOutBuffer.limit(0);
        this.netInBuffer.position(0);
        this.netInBuffer.limit(0);
        this.handshakeComplete = false;
        this.closed = false;
        this.closing = false;
        this.sslEngine.beginHandshake();
        this.handshakeStatus = this.sslEngine.getHandshakeStatus();
    }

    @Override
    public int getBufferSize() {
        int n = super.getBufferSize();
        n += this.netInBuffer != null ? this.netInBuffer.capacity() : 0;
        return n += this.netOutBuffer != null ? this.netOutBuffer.capacity() : 0;
    }

    @Override
    public boolean flush(boolean bl, Selector selector, long l) throws IOException {
        if (!bl) {
            this.flush(this.netOutBuffer);
        } else {
            this.pool.write(this.netOutBuffer, this, selector, l, bl);
        }
        return !this.netOutBuffer.hasRemaining();
    }

    protected boolean flush(ByteBuffer byteBuffer) throws IOException {
        int n = byteBuffer.remaining();
        if (n > 0) {
            return this.sc.write(byteBuffer) >= n;
        }
        return true;
    }

    @Override
    public int handshake(boolean bl, boolean bl2) throws IOException {
        if (this.handshakeComplete) {
            return 0;
        }
        if (!this.flush(this.netOutBuffer)) {
            return 4;
        }
        SSLEngineResult sSLEngineResult = null;
        block9: while (!this.handshakeComplete) {
            switch (this.handshakeStatus) {
                case NOT_HANDSHAKING: {
                    throw new IOException("NOT_HANDSHAKING during handshake");
                }
                case FINISHED: {
                    this.handshakeComplete = !this.netOutBuffer.hasRemaining();
                    return this.handshakeComplete ? 0 : 4;
                }
                case NEED_WRAP: {
                    try {
                        sSLEngineResult = this.handshakeWrap(bl2);
                    }
                    catch (SSLException sSLException) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("channel.nio.ssl.wrapException"), (Throwable)sSLException);
                        }
                        sSLEngineResult = this.handshakeWrap(bl2);
                    }
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.handshakeStatus = this.tasks();
                        }
                    } else {
                        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.CLOSED) {
                            this.flush(this.netOutBuffer);
                            return -1;
                        }
                        throw new IOException("Unexpected status:" + (Object)((Object)sSLEngineResult.getStatus()) + " during handshake WRAP.");
                    }
                    if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_UNWRAP || !this.flush(this.netOutBuffer)) {
                        return 4;
                    }
                }
                case NEED_UNWRAP: {
                    sSLEngineResult = this.handshakeUnwrap(bl);
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
                        if (this.handshakeStatus != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block9;
                        this.handshakeStatus = this.tasks();
                        continue block9;
                    }
                    if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                        return 1;
                    }
                    throw new IOException("Invalid handshake status:" + (Object)((Object)this.handshakeStatus) + " during handshake UNWRAP.");
                }
                case NEED_TASK: {
                    this.handshakeStatus = this.tasks();
                    continue block9;
                }
            }
            throw new IllegalStateException("Invalid handshake status:" + (Object)((Object)this.handshakeStatus));
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void rehandshake(long l) throws IOException {
        if (this.netInBuffer.position() > 0 && this.netInBuffer.position() < this.netInBuffer.limit()) {
            throw new IOException("Network input buffer still contains data. Handshake will fail.");
        }
        if (this.netOutBuffer.position() > 0 && this.netOutBuffer.position() < this.netOutBuffer.limit()) {
            throw new IOException("Network output buffer still contains data. Handshake will fail.");
        }
        if (this.getBufHandler().getReadBuffer().position() > 0 && this.getBufHandler().getReadBuffer().position() < this.getBufHandler().getReadBuffer().limit()) {
            throw new IOException("Application input buffer still contains data. Data would have been lost.");
        }
        if (this.getBufHandler().getWriteBuffer().position() > 0 && this.getBufHandler().getWriteBuffer().position() < this.getBufHandler().getWriteBuffer().limit()) {
            throw new IOException("Application output buffer still contains data. Data would have been lost.");
        }
        this.reset();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = true;
        Selector selector = null;
        SelectionKey selectionKey = null;
        try {
            block20: while (bl3) {
                int n = this.handshake(bl, bl2);
                switch (n) {
                    case -1: {
                        throw new EOFException("EOF during handshake.");
                    }
                    case 0: {
                        bl3 = false;
                        continue block20;
                    }
                }
                long l2 = System.currentTimeMillis();
                if (selector == null) {
                    Class<Selector> clazz = Selector.class;
                    // MONITORENTER : java.nio.channels.Selector.class
                    selector = Selector.open();
                    // MONITOREXIT : clazz
                    selectionKey = this.getIOChannel().register(selector, n);
                } else {
                    selectionKey.interestOps(n);
                }
                int n2 = selector.select(l);
                if (n2 == 0 && System.currentTimeMillis() - l2 >= l) {
                    throw new SocketTimeoutException("Handshake operation timed out.");
                }
                bl = selectionKey.isReadable();
                bl2 = selectionKey.isWritable();
            }
            return;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception);
            throw iOException;
        }
        finally {
            if (selectionKey != null) {
                try {
                    selectionKey.cancel();
                }
                catch (Exception exception) {}
            }
            if (selector != null) {
                try {
                    selector.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected SSLEngineResult.HandshakeStatus tasks() {
        Runnable runnable = null;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    protected SSLEngineResult handshakeWrap(boolean bl) throws IOException {
        this.netOutBuffer.clear();
        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(this.bufHandler.getWriteBuffer(), this.netOutBuffer);
        this.netOutBuffer.flip();
        this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
        if (bl) {
            this.flush(this.netOutBuffer);
        }
        return sSLEngineResult;
    }

    protected SSLEngineResult handshakeUnwrap(boolean bl) throws IOException {
        SSLEngineResult sSLEngineResult;
        int n;
        if (this.netInBuffer.position() == this.netInBuffer.limit()) {
            this.netInBuffer.clear();
        }
        if (bl && (n = this.sc.read(this.netInBuffer)) == -1) {
            throw new IOException("EOF encountered during handshake.");
        }
        boolean bl2 = false;
        do {
            this.netInBuffer.flip();
            sSLEngineResult = this.sslEngine.unwrap(this.netInBuffer, this.bufHandler.getReadBuffer());
            this.netInBuffer.compact();
            this.handshakeStatus = sSLEngineResult.getHandshakeStatus();
            if (sSLEngineResult.getStatus() != SSLEngineResult.Status.OK || sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue;
            this.handshakeStatus = this.tasks();
        } while (bl2 = sSLEngineResult.getStatus() == SSLEngineResult.Status.OK && this.handshakeStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP);
        return sSLEngineResult;
    }

    @Override
    public void close() throws IOException {
        if (this.closing) {
            return;
        }
        this.closing = true;
        this.sslEngine.closeOutbound();
        if (!this.flush(this.netOutBuffer)) {
            throw new IOException("Remaining data in the network buffer, can't send SSL close message, force a close with close(true) instead");
        }
        this.netOutBuffer.clear();
        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(this.getEmptyBuf(), this.netOutBuffer);
        if (sSLEngineResult.getStatus() != SSLEngineResult.Status.CLOSED) {
            throw new IOException("Invalid close state, will not send network data.");
        }
        this.netOutBuffer.flip();
        this.flush(this.netOutBuffer);
        this.closed = !this.netOutBuffer.hasRemaining() && sSLEngineResult.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_WRAP;
    }

    @Override
    public void close(boolean bl) throws IOException {
        try {
            this.close();
        }
        finally {
            if (bl || this.closed) {
                this.closed = true;
                this.sc.socket().close();
                this.sc.close();
            }
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (this.closing || this.closed) {
            return -1;
        }
        if (!this.handshakeComplete) {
            throw new IllegalStateException("Handshake incomplete, you must complete handshake before reading data.");
        }
        int n = this.sc.read(this.netInBuffer);
        if (n == -1) {
            return -1;
        }
        int n2 = 0;
        do {
            this.netInBuffer.flip();
            SSLEngineResult sSLEngineResult = this.sslEngine.unwrap(this.netInBuffer, byteBuffer);
            this.netInBuffer.compact();
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK || sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                n2 += sSLEngineResult.bytesProduced();
                if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                    this.tasks();
                }
                if (sSLEngineResult.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW) continue;
                break;
            }
            if (sSLEngineResult.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW && n2 > 0) break;
            throw new IOException("Unable to unwrap data, invalid status: " + (Object)((Object)sSLEngineResult.getStatus()));
        } while (this.netInBuffer.position() != 0);
        return n2;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.checkInterruptStatus();
        if (byteBuffer == this.netOutBuffer) {
            int n = this.sc.write(byteBuffer);
            return n;
        }
        if (this.closing || this.closed) {
            throw new IOException("Channel is in closing state.");
        }
        if (!this.flush(this.netOutBuffer)) {
            return 0;
        }
        this.netOutBuffer.clear();
        SSLEngineResult sSLEngineResult = this.sslEngine.wrap(byteBuffer, this.netOutBuffer);
        int n = sSLEngineResult.bytesConsumed();
        this.netOutBuffer.flip();
        if (sSLEngineResult.getStatus() == SSLEngineResult.Status.OK) {
            if (sSLEngineResult.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                this.tasks();
            }
        } else {
            throw new IOException("Unable to wrap data, invalid engine state: " + (Object)((Object)sSLEngineResult.getStatus()));
        }
        this.flush(this.netOutBuffer);
        return n;
    }

    @Override
    public int getOutboundRemaining() {
        return this.netOutBuffer.remaining();
    }

    @Override
    public boolean flushOutbound() throws IOException {
        int n = this.netOutBuffer.remaining();
        this.flush(this.netOutBuffer);
        int n2 = this.netOutBuffer.remaining();
        return n2 < n;
    }

    @Override
    public ApplicationBufferHandler getBufHandler() {
        return this.bufHandler;
    }

    @Override
    public boolean isHandshakeComplete() {
        return this.handshakeComplete;
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    public SSLEngine getSslEngine() {
        return this.sslEngine;
    }

    public ByteBuffer getEmptyBuf() {
        return emptyBuf;
    }

    public void setBufHandler(ApplicationBufferHandler applicationBufferHandler) {
        this.bufHandler = applicationBufferHandler;
    }

    public static interface ApplicationBufferHandler {
        public ByteBuffer expand(ByteBuffer var1, int var2);

        public ByteBuffer getReadBuffer();

        public ByteBuffer getWriteBuffer();
    }
}

