/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper.xmlparser;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Locale;
import java.util.jar.JarFile;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.compiler.ErrorDispatcher;
import org.apache.jasper.compiler.JspUtil;
import org.apache.jasper.compiler.Localizer;
import org.apache.jasper.xmlparser.ASCIIReader;
import org.apache.jasper.xmlparser.EncodingMap;
import org.apache.jasper.xmlparser.SymbolTable;
import org.apache.jasper.xmlparser.UCSReader;
import org.apache.jasper.xmlparser.UTF8Reader;
import org.apache.jasper.xmlparser.XMLChar;
import org.apache.jasper.xmlparser.XMLString;
import org.apache.jasper.xmlparser.XMLStringBuffer;

public class XMLEncodingDetector {
    private InputStream stream;
    private String encoding;
    private boolean isEncodingSetInProlog;
    private boolean isBomPresent;
    private int skip;
    private Boolean isBigEndian;
    private Reader reader;
    public static final int DEFAULT_BUFFER_SIZE = 2048;
    public static final int DEFAULT_XMLDECL_BUFFER_SIZE = 64;
    private boolean fAllowJavaEncodings;
    private SymbolTable fSymbolTable;
    private XMLEncodingDetector fCurrentEntity;
    private int fBufferSize = 2048;
    private int lineNumber = 1;
    private int columnNumber = 1;
    private boolean literal;
    private char[] ch = new char[2048];
    private int position;
    private int count;
    private boolean mayReadChunks = false;
    private XMLString fString = new XMLString();
    private XMLStringBuffer fStringBuffer = new XMLStringBuffer();
    private XMLStringBuffer fStringBuffer2 = new XMLStringBuffer();
    private static final String fVersionSymbol = "version";
    private static final String fEncodingSymbol = "encoding";
    private static final String fStandaloneSymbol = "standalone";
    private int fMarkupDepth = 0;
    private String[] fStrings = new String[3];
    private ErrorDispatcher err;

    public XMLEncodingDetector() {
        this.fSymbolTable = new SymbolTable();
        this.fCurrentEntity = this;
    }

    public static Object[] getEncoding(String string, JarFile jarFile, JspCompilationContext jspCompilationContext, ErrorDispatcher errorDispatcher) throws IOException, JasperException {
        InputStream inputStream = JspUtil.getInputStream(string, jarFile, jspCompilationContext, errorDispatcher);
        XMLEncodingDetector xMLEncodingDetector = new XMLEncodingDetector();
        Object[] objectArray = xMLEncodingDetector.getEncoding(inputStream, errorDispatcher);
        inputStream.close();
        return objectArray;
    }

    private Object[] getEncoding(InputStream inputStream, ErrorDispatcher errorDispatcher) throws IOException, JasperException {
        this.stream = inputStream;
        this.err = errorDispatcher;
        this.createInitialReader();
        this.scanXMLDecl();
        return new Object[]{this.encoding, this.isEncodingSetInProlog, this.isBomPresent, this.skip};
    }

    void endEntity() {
    }

    private void createInitialReader() throws IOException, JasperException {
        this.stream = new RewindableInputStream(this.stream);
        if (this.encoding == null) {
            int n;
            byte[] byArray = new byte[4];
            for (n = 0; n < 4; ++n) {
                byArray[n] = (byte)this.stream.read();
            }
            if (n == 4) {
                Object[] objectArray = this.getEncodingName(byArray, n);
                this.encoding = (String)objectArray[0];
                this.isBigEndian = (Boolean)objectArray[1];
                if (objectArray.length > 3) {
                    this.isBomPresent = (Boolean)objectArray[2];
                    this.skip = (Integer)objectArray[3];
                } else {
                    this.isBomPresent = true;
                    this.skip = (Integer)objectArray[2];
                }
                this.stream.reset();
                if (this.encoding.equals("UTF-8")) {
                    long l;
                    int n2 = byArray[0] & 0xFF;
                    int n3 = byArray[1] & 0xFF;
                    int n4 = byArray[2] & 0xFF;
                    if (n2 == 239 && n3 == 187 && n4 == 191 && (l = this.stream.skip(3L)) != 3L) {
                        throw new IOException(Localizer.getMessage("xmlParser.skipBomFail"));
                    }
                }
                this.reader = this.createReader(this.stream, this.encoding, this.isBigEndian);
            } else {
                this.reader = this.createReader(this.stream, this.encoding, this.isBigEndian);
            }
        }
    }

    private Reader createReader(InputStream inputStream, String string, Boolean bl) throws IOException, JasperException {
        String string2;
        String string3;
        if (string == null) {
            string = "UTF-8";
        }
        if ((string3 = string.toUpperCase(Locale.ENGLISH)).equals("UTF-8")) {
            return new UTF8Reader(inputStream, this.fBufferSize);
        }
        if (string3.equals("US-ASCII")) {
            return new ASCIIReader(inputStream, this.fBufferSize);
        }
        if (string3.equals("ISO-10646-UCS-4")) {
            if (bl != null) {
                boolean bl2 = bl;
                if (bl2) {
                    return new UCSReader(inputStream, 8);
                }
                return new UCSReader(inputStream, 4);
            }
            this.err.jspError("jsp.error.xml.encodingByteOrderUnsupported", string);
        }
        if (string3.equals("ISO-10646-UCS-2")) {
            if (bl != null) {
                boolean bl3 = bl;
                if (bl3) {
                    return new UCSReader(inputStream, 2);
                }
                return new UCSReader(inputStream, 1);
            }
            this.err.jspError("jsp.error.xml.encodingByteOrderUnsupported", string);
        }
        boolean bl4 = XMLChar.isValidIANAEncoding(string);
        boolean bl5 = XMLChar.isValidJavaEncoding(string);
        if (!bl4 || this.fAllowJavaEncodings && !bl5) {
            this.err.jspError("jsp.error.xml.encodingDeclInvalid", string);
            string = "ISO-8859-1";
        }
        if ((string2 = EncodingMap.getIANA2JavaMapping(string3)) == null) {
            if (this.fAllowJavaEncodings) {
                string2 = string;
            } else {
                this.err.jspError("jsp.error.xml.encodingDeclInvalid", string);
                string2 = "ISO8859_1";
            }
        }
        return new InputStreamReader(inputStream, string2);
    }

    private Object[] getEncodingName(byte[] byArray, int n) {
        if (n < 2) {
            return new Object[]{"UTF-8", null, Boolean.FALSE, 0};
        }
        int n2 = byArray[0] & 0xFF;
        int n3 = byArray[1] & 0xFF;
        if (n2 == 254 && n3 == 255) {
            return new Object[]{"UTF-16BE", Boolean.TRUE, 2};
        }
        if (n2 == 255 && n3 == 254) {
            return new Object[]{"UTF-16LE", Boolean.FALSE, 2};
        }
        if (n < 3) {
            return new Object[]{"UTF-8", null, Boolean.FALSE, 0};
        }
        int n4 = byArray[2] & 0xFF;
        if (n2 == 239 && n3 == 187 && n4 == 191) {
            return new Object[]{"UTF-8", null, 3};
        }
        if (n < 4) {
            return new Object[]{"UTF-8", null, 0};
        }
        int n5 = byArray[3] & 0xFF;
        if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 60) {
            return new Object[]{"ISO-10646-UCS-4", Boolean.TRUE, 4};
        }
        if (n2 == 60 && n3 == 0 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", Boolean.FALSE, 4};
        }
        if (n2 == 0 && n3 == 0 && n4 == 60 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null, 4};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 0) {
            return new Object[]{"ISO-10646-UCS-4", null, 4};
        }
        if (n2 == 0 && n3 == 60 && n4 == 0 && n5 == 63) {
            return new Object[]{"UTF-16BE", Boolean.TRUE, 4};
        }
        if (n2 == 60 && n3 == 0 && n4 == 63 && n5 == 0) {
            return new Object[]{"UTF-16LE", Boolean.FALSE, 4};
        }
        if (n2 == 76 && n3 == 111 && n4 == 167 && n5 == 148) {
            return new Object[]{"CP037", null, 4};
        }
        return new Object[]{"UTF-8", null, Boolean.FALSE, 0};
    }

    public boolean isExternal() {
        return true;
    }

    public int peekChar() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int n = this.fCurrentEntity.ch[this.fCurrentEntity.position];
        if (this.fCurrentEntity.isExternal()) {
            return n != 13 ? n : 10;
        }
        return n;
    }

    public int scanChar() throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int n = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
        boolean bl = false;
        if (n == 10 || n == 13 && (bl = this.fCurrentEntity.isExternal())) {
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = (char)n;
                this.load(1, false);
            }
            if (n == 13 && bl) {
                if (this.fCurrentEntity.ch[this.fCurrentEntity.position++] != '\n') {
                    --this.fCurrentEntity.position;
                }
                n = 10;
            }
        }
        ++this.fCurrentEntity.columnNumber;
        return n;
    }

    public String scanName() throws IOException {
        Object object;
        int n;
        int n2;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if (XMLChar.isNameStart(this.fCurrentEntity.ch[n2 = this.fCurrentEntity.position++])) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[n2];
                n2 = 0;
                if (this.load(1, false)) {
                    ++this.fCurrentEntity.columnNumber;
                    String string = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, 0, 1);
                    return string;
                }
            }
            while (XMLChar.isName(this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
                if (++this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                n = this.fCurrentEntity.position - n2;
                if (n == this.fBufferSize) {
                    object = new char[this.fBufferSize * 2];
                    System.arraycopy(this.fCurrentEntity.ch, n2, object, 0, n);
                    this.fCurrentEntity.ch = (char[])object;
                    this.fBufferSize *= 2;
                } else {
                    System.arraycopy(this.fCurrentEntity.ch, n2, this.fCurrentEntity.ch, 0, n);
                }
                n2 = 0;
                if (!this.load(n, false)) continue;
                break;
            }
        }
        n = this.fCurrentEntity.position - n2;
        this.fCurrentEntity.columnNumber += n;
        object = null;
        if (n > 0) {
            object = this.fSymbolTable.addSymbol(this.fCurrentEntity.ch, n2, n);
        }
        return object;
    }

    public int scanLiteral(int n, XMLString xMLString) throws IOException {
        int n2;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        } else if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
            this.fCurrentEntity.ch[0] = this.fCurrentEntity.ch[this.fCurrentEntity.count - 1];
            this.load(1, false);
            this.fCurrentEntity.position = 0;
        }
        int n3 = this.fCurrentEntity.position;
        int n4 = this.fCurrentEntity.ch[n3];
        int n5 = 0;
        boolean bl = this.fCurrentEntity.isExternal();
        if (n4 == 10 || n4 == 13 && bl) {
            do {
                if ((n4 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == 13 && bl) {
                    ++n5;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                        n3 = 0;
                        this.fCurrentEntity.position = n5;
                        if (this.load(n5, false)) break;
                    }
                    if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                        ++this.fCurrentEntity.position;
                        ++n3;
                        continue;
                    }
                    ++n5;
                    continue;
                }
                if (n4 == 10) {
                    ++n5;
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                    n3 = 0;
                    this.fCurrentEntity.position = n5;
                    if (!this.load(n5, false)) continue;
                    break;
                }
                --this.fCurrentEntity.position;
                break;
            } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
            for (n2 = n3; n2 < this.fCurrentEntity.position; ++n2) {
                this.fCurrentEntity.ch[n2] = 10;
            }
            n2 = this.fCurrentEntity.position - n3;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                xMLString.setValues(this.fCurrentEntity.ch, n3, n2);
                return -1;
            }
        }
        while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
            if (((n4 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) != n || this.fCurrentEntity.literal && !bl) && n4 != 37 && XMLChar.isContent(n4)) continue;
            --this.fCurrentEntity.position;
            break;
        }
        n2 = this.fCurrentEntity.position - n3;
        this.fCurrentEntity.columnNumber += n2 - n5;
        xMLString.setValues(this.fCurrentEntity.ch, n3, n2);
        if (this.fCurrentEntity.position != this.fCurrentEntity.count) {
            n4 = this.fCurrentEntity.ch[this.fCurrentEntity.position];
            if (n4 == n && this.fCurrentEntity.literal) {
                n4 = -1;
            }
        } else {
            n4 = -1;
        }
        return n4;
    }

    public boolean scanData(String string, XMLStringBuffer xMLStringBuffer) throws IOException {
        boolean bl = false;
        int n = string.length();
        char c = string.charAt(0);
        boolean bl2 = this.fCurrentEntity.isExternal();
        do {
            int n2;
            int n3;
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.load(0, true);
            } else if (this.fCurrentEntity.position >= this.fCurrentEntity.count - n) {
                System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.position, this.fCurrentEntity.ch, 0, this.fCurrentEntity.count - this.fCurrentEntity.position);
                this.load(this.fCurrentEntity.count - this.fCurrentEntity.position, false);
                this.fCurrentEntity.position = 0;
            }
            if (this.fCurrentEntity.position >= this.fCurrentEntity.count - n) {
                n3 = this.fCurrentEntity.count - this.fCurrentEntity.position;
                xMLStringBuffer.append(this.fCurrentEntity.ch, this.fCurrentEntity.position, n3);
                this.fCurrentEntity.columnNumber += this.fCurrentEntity.count;
                this.fCurrentEntity.position = this.fCurrentEntity.count;
                this.load(0, true);
                return false;
            }
            n3 = this.fCurrentEntity.position;
            char c2 = this.fCurrentEntity.ch[n3];
            int n4 = 0;
            if (c2 == '\n' || c2 == '\r' && bl2) {
                do {
                    if ((c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == '\r' && bl2) {
                        ++n4;
                        ++this.fCurrentEntity.lineNumber;
                        this.fCurrentEntity.columnNumber = 1;
                        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                            n3 = 0;
                            this.fCurrentEntity.position = n4;
                            if (this.load(n4, false)) break;
                        }
                        if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                            ++this.fCurrentEntity.position;
                            ++n3;
                            continue;
                        }
                        ++n4;
                        continue;
                    }
                    if (c2 == '\n') {
                        ++n4;
                        ++this.fCurrentEntity.lineNumber;
                        this.fCurrentEntity.columnNumber = 1;
                        if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                        n3 = 0;
                        this.fCurrentEntity.position = n4;
                        this.fCurrentEntity.count = n4;
                        if (!this.load(n4, false)) continue;
                        break;
                    }
                    --this.fCurrentEntity.position;
                    break;
                } while (this.fCurrentEntity.position < this.fCurrentEntity.count - 1);
                for (n2 = n3; n2 < this.fCurrentEntity.position; ++n2) {
                    this.fCurrentEntity.ch[n2] = 10;
                }
                n2 = this.fCurrentEntity.position - n3;
                if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                    xMLStringBuffer.append(this.fCurrentEntity.ch, n3, n2);
                    return true;
                }
            }
            block3: while (this.fCurrentEntity.position < this.fCurrentEntity.count) {
                if ((c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) == c) {
                    n2 = this.fCurrentEntity.position - 1;
                    for (int i = 1; i < n; ++i) {
                        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                            this.fCurrentEntity.position -= i;
                            break block3;
                        }
                        c2 = this.fCurrentEntity.ch[this.fCurrentEntity.position++];
                        if (string.charAt(i) == c2) continue;
                        --this.fCurrentEntity.position;
                        break;
                    }
                    if (this.fCurrentEntity.position != n2 + n) continue;
                    bl = true;
                    break;
                }
                if (c2 == '\n' || bl2 && c2 == '\r') {
                    --this.fCurrentEntity.position;
                    break;
                }
                if (!XMLChar.isInvalid(c2)) continue;
                --this.fCurrentEntity.position;
                n2 = this.fCurrentEntity.position - n3;
                this.fCurrentEntity.columnNumber += n2 - n4;
                xMLStringBuffer.append(this.fCurrentEntity.ch, n3, n2);
                return true;
            }
            n2 = this.fCurrentEntity.position - n3;
            this.fCurrentEntity.columnNumber += n2 - n4;
            if (bl) {
                n2 -= n;
            }
            xMLStringBuffer.append(this.fCurrentEntity.ch, n3, n2);
        } while (!bl);
        return !bl;
    }

    public boolean skipChar(int n) throws IOException {
        char c;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position]) == n) {
            ++this.fCurrentEntity.position;
            if (n == 10) {
                ++this.fCurrentEntity.lineNumber;
                this.fCurrentEntity.columnNumber = 1;
            } else {
                ++this.fCurrentEntity.columnNumber;
            }
            return true;
        }
        if (n == 10 && c == '\r' && this.fCurrentEntity.isExternal()) {
            if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                this.fCurrentEntity.ch[0] = c;
                this.load(1, false);
            }
            ++this.fCurrentEntity.position;
            if (this.fCurrentEntity.ch[this.fCurrentEntity.position] == '\n') {
                ++this.fCurrentEntity.position;
            }
            ++this.fCurrentEntity.lineNumber;
            this.fCurrentEntity.columnNumber = 1;
            return true;
        }
        return false;
    }

    public boolean skipSpaces() throws IOException {
        char c;
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        if (XMLChar.isSpace(c = this.fCurrentEntity.ch[this.fCurrentEntity.position])) {
            boolean bl = this.fCurrentEntity.isExternal();
            do {
                boolean bl2 = false;
                if (c == '\n' || bl && c == '\r') {
                    ++this.fCurrentEntity.lineNumber;
                    this.fCurrentEntity.columnNumber = 1;
                    if (this.fCurrentEntity.position == this.fCurrentEntity.count - 1) {
                        this.fCurrentEntity.ch[0] = c;
                        bl2 = this.load(1, true);
                        if (!bl2) {
                            this.fCurrentEntity.position = 0;
                        }
                    }
                    if (c == '\r' && bl && this.fCurrentEntity.ch[++this.fCurrentEntity.position] != '\n') {
                        --this.fCurrentEntity.position;
                    }
                } else {
                    ++this.fCurrentEntity.columnNumber;
                }
                if (!bl2) {
                    ++this.fCurrentEntity.position;
                }
                if (this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
                this.load(0, true);
            } while (XMLChar.isSpace(c = this.fCurrentEntity.ch[this.fCurrentEntity.position]));
            return true;
        }
        return false;
    }

    public boolean skipString(String string) throws IOException {
        if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
            this.load(0, true);
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c;
            if ((c = this.fCurrentEntity.ch[this.fCurrentEntity.position++]) != string.charAt(i)) {
                this.fCurrentEntity.position -= i + 1;
                return false;
            }
            if (i >= n - 1 || this.fCurrentEntity.position != this.fCurrentEntity.count) continue;
            System.arraycopy(this.fCurrentEntity.ch, this.fCurrentEntity.count - i - 1, this.fCurrentEntity.ch, 0, i + 1);
            if (!this.load(i + 1, false)) continue;
            this.fCurrentEntity.position -= i + 1;
            return false;
        }
        this.fCurrentEntity.columnNumber += n;
        return true;
    }

    final boolean load(int n, boolean bl) throws IOException {
        int n2 = this.fCurrentEntity.mayReadChunks ? this.fCurrentEntity.ch.length - n : 64;
        int n3 = this.fCurrentEntity.reader.read(this.fCurrentEntity.ch, n, n2);
        boolean bl2 = false;
        if (n3 != -1) {
            if (n3 != 0) {
                this.fCurrentEntity.count = n3 + n;
                this.fCurrentEntity.position = n;
            }
        } else {
            this.fCurrentEntity.count = n;
            this.fCurrentEntity.position = n;
            bl2 = true;
            if (bl) {
                this.endEntity();
                if (this.fCurrentEntity == null) {
                    throw new EOFException();
                }
                if (this.fCurrentEntity.position == this.fCurrentEntity.count) {
                    this.load(0, false);
                }
            }
        }
        return bl2;
    }

    private void scanXMLDecl() throws IOException, JasperException {
        if (this.skipString("<?xml")) {
            ++this.fMarkupDepth;
            if (XMLChar.isName(this.peekChar())) {
                this.fStringBuffer.clear();
                this.fStringBuffer.append("xml");
                while (XMLChar.isName(this.peekChar())) {
                    this.fStringBuffer.append((char)this.scanChar());
                }
                String string = this.fSymbolTable.addSymbol(this.fStringBuffer.ch, this.fStringBuffer.offset, this.fStringBuffer.length);
                this.scanPIData(string, this.fString);
            } else {
                this.scanXMLDeclOrTextDecl(false);
            }
        }
    }

    private void scanXMLDeclOrTextDecl(boolean bl) throws IOException, JasperException {
        this.scanXMLDeclOrTextDecl(bl, this.fStrings);
        --this.fMarkupDepth;
        String string = this.fStrings[1];
        if (string != null) {
            this.isEncodingSetInProlog = true;
            this.encoding = string;
        }
    }

    private void scanXMLDeclOrTextDecl(boolean bl, String[] stringArray) throws IOException, JasperException {
        String string = null;
        String string2 = null;
        String string3 = null;
        int n = 0;
        boolean bl2 = false;
        boolean bl3 = this.skipSpaces();
        while (this.peekChar() != 63) {
            bl2 = true;
            String string4 = this.scanPseudoAttribute(bl, this.fString);
            switch (n) {
                case 0: {
                    if (string4 == fVersionSymbol) {
                        if (!bl3) {
                            this.reportFatalError(bl ? "jsp.error.xml.spaceRequiredBeforeVersionInTextDecl" : "jsp.error.xml.spaceRequiredBeforeVersionInXMLDecl", null);
                        }
                        string = this.fString.toString();
                        n = 1;
                        if (string.equals("1.0")) break;
                        this.err.jspError("jsp.error.xml.versionNotSupported", string);
                        break;
                    }
                    if (string4 == fEncodingSymbol) {
                        if (!bl) {
                            this.err.jspError("jsp.error.xml.versionInfoRequired");
                        }
                        if (!bl3) {
                            this.reportFatalError(bl ? "jsp.error.xml.spaceRequiredBeforeEncodingInTextDecl" : "jsp.error.xml.spaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        string2 = this.fString.toString();
                        n = bl ? 3 : 2;
                        break;
                    }
                    if (bl) {
                        this.err.jspError("jsp.error.xml.encodingDeclRequired");
                        break;
                    }
                    this.err.jspError("jsp.error.xml.versionInfoRequired");
                    break;
                }
                case 1: {
                    if (string4 == fEncodingSymbol) {
                        if (!bl3) {
                            this.reportFatalError(bl ? "jsp.error.xml.spaceRequiredBeforeEncodingInTextDecl" : "jsp.error.xml.spaceRequiredBeforeEncodingInXMLDecl", null);
                        }
                        string2 = this.fString.toString();
                        n = bl ? 3 : 2;
                        break;
                    }
                    if (!bl && string4 == fStandaloneSymbol) {
                        if (!bl3) {
                            this.err.jspError("jsp.error.xml.spaceRequiredBeforeStandalone");
                        }
                        string3 = this.fString.toString();
                        n = 3;
                        if (string3.equals("yes") || string3.equals("no")) break;
                        this.err.jspError("jsp.error.xml.sdDeclInvalid");
                        break;
                    }
                    this.err.jspError("jsp.error.xml.encodingDeclRequired");
                    break;
                }
                case 2: {
                    if (string4 == fStandaloneSymbol) {
                        if (!bl3) {
                            this.err.jspError("jsp.error.xml.spaceRequiredBeforeStandalone");
                        }
                        string3 = this.fString.toString();
                        n = 3;
                        if (string3.equals("yes") || string3.equals("no")) break;
                        this.err.jspError("jsp.error.xml.sdDeclInvalid");
                        break;
                    }
                    this.err.jspError("jsp.error.xml.encodingDeclRequired");
                    break;
                }
                default: {
                    this.err.jspError("jsp.error.xml.noMorePseudoAttributes");
                }
            }
            bl3 = this.skipSpaces();
        }
        if (bl && n != 3) {
            this.err.jspError("jsp.error.xml.morePseudoAttributes");
        }
        if (bl) {
            if (!bl2 && string2 == null) {
                this.err.jspError("jsp.error.xml.encodingDeclRequired");
            }
        } else if (!bl2 && string == null) {
            this.err.jspError("jsp.error.xml.versionInfoRequired");
        }
        if (!this.skipChar(63)) {
            this.err.jspError("jsp.error.xml.xmlDeclUnterminated");
        }
        if (!this.skipChar(62)) {
            this.err.jspError("jsp.error.xml.xmlDeclUnterminated");
        }
        stringArray[0] = string;
        stringArray[1] = string2;
        stringArray[2] = string3;
    }

    public String scanPseudoAttribute(boolean bl, XMLString xMLString) throws IOException, JasperException {
        String string = this.scanName();
        if (string == null) {
            this.err.jspError("jsp.error.xml.pseudoAttrNameExpected");
        }
        this.skipSpaces();
        if (!this.skipChar(61)) {
            this.reportFatalError(bl ? "jsp.error.xml.eqRequiredInTextDecl" : "jsp.error.xml.eqRequiredInXMLDecl", string);
        }
        this.skipSpaces();
        int n = this.peekChar();
        if (n != 39 && n != 34) {
            this.reportFatalError(bl ? "jsp.error.xml.quoteRequiredInTextDecl" : "jsp.error.xml.quoteRequiredInXMLDecl", string);
        }
        this.scanChar();
        int n2 = this.scanLiteral(n, xMLString);
        if (n2 != n) {
            this.fStringBuffer2.clear();
            do {
                this.fStringBuffer2.append(xMLString);
                if (n2 == -1) continue;
                if (n2 == 38 || n2 == 37 || n2 == 60 || n2 == 93) {
                    this.fStringBuffer2.append((char)this.scanChar());
                    continue;
                }
                if (XMLChar.isHighSurrogate(n2)) {
                    this.scanSurrogates(this.fStringBuffer2);
                    continue;
                }
                if (!XMLChar.isInvalid(n2)) continue;
                String string2 = bl ? "jsp.error.xml.invalidCharInTextDecl" : "jsp.error.xml.invalidCharInXMLDecl";
                this.reportFatalError(string2, Integer.toString(n2, 16));
                this.scanChar();
            } while ((n2 = this.scanLiteral(n, xMLString)) != n);
            this.fStringBuffer2.append(xMLString);
            xMLString.setValues(this.fStringBuffer2);
        }
        if (!this.skipChar(n)) {
            this.reportFatalError(bl ? "jsp.error.xml.closeQuoteMissingInTextDecl" : "jsp.error.xml.closeQuoteMissingInXMLDecl", string);
        }
        return string;
    }

    private void scanPIData(String string, XMLString xMLString) throws IOException, JasperException {
        int n;
        if (string.length() == 3) {
            n = Character.toLowerCase(string.charAt(0));
            char c = Character.toLowerCase(string.charAt(1));
            char c2 = Character.toLowerCase(string.charAt(2));
            if (n == 120 && c == 'm' && c2 == 'l') {
                this.err.jspError("jsp.error.xml.reservedPITarget");
            }
        }
        if (!this.skipSpaces()) {
            if (this.skipString("?>")) {
                xMLString.clear();
                return;
            }
            this.err.jspError("jsp.error.xml.spaceRequiredInPI");
        }
        this.fStringBuffer.clear();
        if (this.scanData("?>", this.fStringBuffer)) {
            do {
                if ((n = this.peekChar()) == -1) continue;
                if (XMLChar.isHighSurrogate(n)) {
                    this.scanSurrogates(this.fStringBuffer);
                    continue;
                }
                if (!XMLChar.isInvalid(n)) continue;
                this.err.jspError("jsp.error.xml.invalidCharInPI", Integer.toHexString(n));
                this.scanChar();
            } while (this.scanData("?>", this.fStringBuffer));
        }
        xMLString.setValues(this.fStringBuffer);
    }

    private boolean scanSurrogates(XMLStringBuffer xMLStringBuffer) throws IOException, JasperException {
        int n = this.scanChar();
        int n2 = this.peekChar();
        if (!XMLChar.isLowSurrogate(n2)) {
            this.err.jspError("jsp.error.xml.invalidCharInContent", Integer.toString(n, 16));
            return false;
        }
        this.scanChar();
        int n3 = XMLChar.supplemental((char)n, (char)n2);
        if (!XMLChar.isValid(n3)) {
            this.err.jspError("jsp.error.xml.invalidCharInContent", Integer.toString(n3, 16));
            return false;
        }
        xMLStringBuffer.append((char)n);
        xMLStringBuffer.append((char)n2);
        return true;
    }

    private void reportFatalError(String string, String string2) throws JasperException {
        this.err.jspError(string, string2);
    }

    private final class RewindableInputStream
    extends InputStream {
        private InputStream fInputStream;
        private byte[] fData = new byte[64];
        private int fEndOffset;
        private int fOffset;
        private int fLength;
        private int fMark;

        public RewindableInputStream(InputStream inputStream) {
            this.fInputStream = inputStream;
            this.fEndOffset = -1;
            this.fOffset = 0;
            this.fLength = 0;
            this.fMark = 0;
        }

        @Override
        public int read() throws IOException {
            int n = 0;
            if (this.fOffset < this.fLength) {
                return this.fData[this.fOffset++] & 0xFF;
            }
            if (this.fOffset == this.fEndOffset) {
                return -1;
            }
            if (this.fOffset == this.fData.length) {
                byte[] byArray = new byte[this.fOffset << 1];
                System.arraycopy(this.fData, 0, byArray, 0, this.fOffset);
                this.fData = byArray;
            }
            if ((n = this.fInputStream.read()) == -1) {
                this.fEndOffset = this.fOffset;
                return -1;
            }
            this.fData[this.fLength++] = (byte)n;
            ++this.fOffset;
            return n & 0xFF;
        }

        @Override
        public int read(byte[] byArray, int n, int n2) throws IOException {
            int n3 = this.fLength - this.fOffset;
            if (n3 == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                if (XMLEncodingDetector.this.fCurrentEntity.mayReadChunks) {
                    return this.fInputStream.read(byArray, n, n2);
                }
                int n4 = this.read();
                if (n4 == -1) {
                    this.fEndOffset = this.fOffset;
                    return -1;
                }
                byArray[n] = (byte)n4;
                return 1;
            }
            if (n2 < n3) {
                if (n2 <= 0) {
                    return 0;
                }
            } else {
                n2 = n3;
            }
            if (byArray != null) {
                System.arraycopy(this.fData, this.fOffset, byArray, n, n2);
            }
            this.fOffset += n2;
            return n2;
        }

        @Override
        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            int n = this.fLength - this.fOffset;
            if (n == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return 0L;
                }
                return this.fInputStream.skip(l);
            }
            if (l <= (long)n) {
                this.fOffset = (int)((long)this.fOffset + l);
                return l;
            }
            this.fOffset += n;
            if (this.fOffset == this.fEndOffset) {
                return n;
            }
            return this.fInputStream.skip(l -= (long)n) + (long)n;
        }

        @Override
        public int available() throws IOException {
            int n = this.fLength - this.fOffset;
            if (n == 0) {
                if (this.fOffset == this.fEndOffset) {
                    return -1;
                }
                return XMLEncodingDetector.this.fCurrentEntity.mayReadChunks ? this.fInputStream.available() : 0;
            }
            return n;
        }

        @Override
        public synchronized void mark(int n) {
            this.fMark = this.fOffset;
        }

        @Override
        public synchronized void reset() {
            this.fOffset = this.fMark;
        }

        @Override
        public boolean markSupported() {
            return true;
        }

        @Override
        public void close() throws IOException {
            if (this.fInputStream != null) {
                this.fInputStream.close();
                this.fInputStream = null;
            }
        }
    }
}

