/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.dbcp2.datasources.UserPassKey;
import org.apache.tomcat.dbcp.pool2.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool2.KeyedPooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

class KeyedCPDSConnectionFactory
implements KeyedPooledObjectFactory<UserPassKey, PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource cpds;
    private final String validationQuery;
    private final int validationQueryTimeoutSeconds;
    private final boolean rollbackAfterValidation;
    private KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> pool;
    private long maxConnLifetimeMillis = -1L;
    private final Set<PooledConnection> validatingSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<PooledConnection, PooledConnectionAndInfo> pcMap = new ConcurrentHashMap<PooledConnection, PooledConnectionAndInfo>();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, String string, int n, boolean bl) {
        this.cpds = connectionPoolDataSource;
        this.validationQuery = string;
        this.validationQueryTimeoutSeconds = n;
        this.rollbackAfterValidation = bl;
    }

    public void setPool(KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> keyedObjectPool) {
        this.pool = keyedObjectPool;
    }

    public KeyedObjectPool<UserPassKey, PooledConnectionAndInfo> getPool() {
        return this.pool;
    }

    @Override
    public synchronized PooledObject<PooledConnectionAndInfo> makeObject(UserPassKey userPassKey) throws Exception {
        PooledConnectionAndInfo pooledConnectionAndInfo = null;
        PooledConnection pooledConnection = null;
        String string = userPassKey.getUsername();
        String string2 = userPassKey.getPassword();
        pooledConnection = string == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(string, string2);
        if (pooledConnection == null) {
            throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
        }
        pooledConnection.addConnectionEventListener(this);
        pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, string, userPassKey.getPasswordCharArray());
        this.pcMap.put(pooledConnection, pooledConnectionAndInfo);
        return new DefaultPooledObject<PooledConnectionAndInfo>(pooledConnectionAndInfo);
    }

    @Override
    public void destroyObject(UserPassKey userPassKey, PooledObject<PooledConnectionAndInfo> pooledObject) throws Exception {
        PooledConnection pooledConnection = pooledObject.getObject().getPooledConnection();
        pooledConnection.removeConnectionEventListener(this);
        this.pcMap.remove(pooledConnection);
        pooledConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateObject(UserPassKey userPassKey, PooledObject<PooledConnectionAndInfo> pooledObject) {
        try {
            this.validateLifetime(pooledObject);
        }
        catch (Exception exception) {
            return false;
        }
        boolean bl = false;
        PooledConnection pooledConnection = pooledObject.getObject().getPooledConnection();
        Connection connection = null;
        this.validatingSet.add(pooledConnection);
        if (null == this.validationQuery) {
            int n = this.validationQueryTimeoutSeconds;
            if (n < 0) {
                n = 0;
            }
            try {
                connection = pooledConnection.getConnection();
                bl = connection.isValid(n);
                return bl;
            }
            catch (SQLException sQLException) {
                bl = false;
                return bl;
            }
            finally {
                Utils.closeQuietly(connection);
                this.validatingSet.remove(pooledConnection);
            }
        }
        Statement statement = null;
        ResultSet resultSet = null;
        this.validatingSet.add(pooledConnection);
        try {
            connection = pooledConnection.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(this.validationQuery);
            bl = resultSet.next();
            if (this.rollbackAfterValidation) {
                connection.rollback();
            }
            Utils.closeQuietly(resultSet);
        }
        catch (Exception exception) {
            bl = false;
            return bl;
        }
        Utils.closeQuietly(statement);
        Utils.closeQuietly(connection);
        this.validatingSet.remove(pooledConnection);
        return bl;
        finally {
            Utils.closeQuietly(resultSet);
            Utils.closeQuietly(statement);
            Utils.closeQuietly(connection);
            this.validatingSet.remove(pooledConnection);
        }
    }

    @Override
    public void passivateObject(UserPassKey userPassKey, PooledObject<PooledConnectionAndInfo> pooledObject) throws Exception {
        this.validateLifetime(pooledObject);
    }

    @Override
    public void activateObject(UserPassKey userPassKey, PooledObject<PooledConnectionAndInfo> pooledObject) throws Exception {
        this.validateLifetime(pooledObject);
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (!this.validatingSet.contains(pooledConnection)) {
            PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
            if (pooledConnectionAndInfo == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this.pool.returnObject(pooledConnectionAndInfo.getUserPassKey(), pooledConnectionAndInfo);
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pooledConnection.removeConnectionEventListener(this);
                try {
                    this.pool.invalidateObject(pooledConnectionAndInfo.getUserPassKey(), pooledConnectionAndInfo);
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
                    exception2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (null != connectionEvent.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + connectionEvent.getSQLException() + ")");
        }
        pooledConnection.removeConnectionEventListener(this);
        PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pooledConnectionAndInfo.getUserPassKey(), pooledConnectionAndInfo);
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
            exception.printStackTrace();
        }
    }

    @Override
    public void invalidate(PooledConnection pooledConnection) throws SQLException {
        PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        UserPassKey userPassKey = pooledConnectionAndInfo.getUserPassKey();
        try {
            this.pool.invalidateObject(userPassKey, pooledConnectionAndInfo);
            this.pool.clear(userPassKey);
        }
        catch (Exception exception) {
            throw new SQLException("Error invalidating connection", exception);
        }
    }

    @Override
    public void setPassword(String string) {
    }

    public void setMaxConnLifetimeMillis(long l) {
        this.maxConnLifetimeMillis = l;
    }

    @Override
    public void closePool(String string) throws SQLException {
        try {
            this.pool.clear(new UserPassKey(string));
        }
        catch (Exception exception) {
            throw new SQLException("Error closing connection pool", exception);
        }
    }

    private void validateLifetime(PooledObject<PooledConnectionAndInfo> pooledObject) throws Exception {
        long l;
        if (this.maxConnLifetimeMillis > 0L && (l = System.currentTimeMillis() - pooledObject.getCreateTime()) > this.maxConnLifetimeMillis) {
            throw new Exception(Utils.getMessage("connectionFactory.lifetimeExceeded", l, this.maxConnLifetimeMillis));
        }
    }
}

