/*
 * Decompiled with CFR 0.152.
 */
package org.apache.el.lang;

import java.io.StringReader;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.FunctionMapper;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.apache.el.MethodExpressionImpl;
import org.apache.el.MethodExpressionLiteral;
import org.apache.el.ValueExpressionImpl;
import org.apache.el.lang.FunctionMapperFactory;
import org.apache.el.lang.VariableMapperFactory;
import org.apache.el.parser.AstDeferredExpression;
import org.apache.el.parser.AstDynamicExpression;
import org.apache.el.parser.AstFunction;
import org.apache.el.parser.AstIdentifier;
import org.apache.el.parser.AstLiteralExpression;
import org.apache.el.parser.AstValue;
import org.apache.el.parser.ELParser;
import org.apache.el.parser.Node;
import org.apache.el.parser.NodeVisitor;
import org.apache.el.util.ConcurrentCache;
import org.apache.el.util.MessageFactory;

public final class ExpressionBuilder
implements NodeVisitor {
    private static final SynchronizedStack<ELParser> parserCache = new SynchronizedStack();
    private static final int CACHE_SIZE;
    private static final String CACHE_SIZE_PROP = "org.apache.el.ExpressionBuilder.CACHE_SIZE";
    private static final ConcurrentCache<String, Node> expressionCache;
    private FunctionMapper fnMapper;
    private VariableMapper varMapper;
    private final String expression;

    public ExpressionBuilder(String string, ELContext eLContext) throws ELException {
        this.expression = string;
        FunctionMapper functionMapper = eLContext.getFunctionMapper();
        VariableMapper variableMapper = eLContext.getVariableMapper();
        if (functionMapper != null) {
            this.fnMapper = new FunctionMapperFactory(functionMapper);
        }
        if (variableMapper != null) {
            this.varMapper = new VariableMapperFactory(variableMapper);
        }
    }

    public static final Node createNode(String string) throws ELException {
        Node node = ExpressionBuilder.createNodeInternal(string);
        return node;
    }

    private static final Node createNodeInternal(String string) throws ELException {
        if (string == null) {
            throw new ELException(MessageFactory.get("error.null"));
        }
        Node node = expressionCache.get(string);
        if (node == null) {
            ELParser eLParser = parserCache.pop();
            try {
                if (eLParser == null) {
                    eLParser = new ELParser(new StringReader(string));
                } else {
                    eLParser.ReInit(new StringReader(string));
                }
                node = eLParser.CompositeExpression();
                int n = node.jjtGetNumChildren();
                if (n == 1) {
                    node = node.jjtGetChild(0);
                } else {
                    Class<?> clazz = null;
                    Node node2 = null;
                    for (int i = 0; i < n; ++i) {
                        node2 = node.jjtGetChild(i);
                        if (node2 instanceof AstLiteralExpression) continue;
                        if (clazz == null) {
                            clazz = node2.getClass();
                            continue;
                        }
                        if (clazz.equals(node2.getClass())) continue;
                        throw new ELException(MessageFactory.get("error.mixed", string));
                    }
                }
                if (node instanceof AstDeferredExpression || node instanceof AstDynamicExpression) {
                    node = node.jjtGetChild(0);
                }
                expressionCache.put(string, node);
            }
            catch (Exception exception) {
                throw new ELException(MessageFactory.get("error.parseFail", string), (Throwable)exception);
            }
            finally {
                if (eLParser != null) {
                    parserCache.push(eLParser);
                }
            }
        }
        return node;
    }

    private void prepare(Node node) throws ELException {
        try {
            node.accept(this);
        }
        catch (Exception exception) {
            if (exception instanceof ELException) {
                throw (ELException)((Object)exception);
            }
            throw new ELException((Throwable)exception);
        }
        if (this.fnMapper instanceof FunctionMapperFactory) {
            this.fnMapper = ((FunctionMapperFactory)this.fnMapper).create();
        }
        if (this.varMapper instanceof VariableMapperFactory) {
            this.varMapper = ((VariableMapperFactory)this.varMapper).create();
        }
    }

    private Node build() throws ELException {
        Node node = ExpressionBuilder.createNodeInternal(this.expression);
        this.prepare(node);
        if (node instanceof AstDeferredExpression || node instanceof AstDynamicExpression) {
            node = node.jjtGetChild(0);
        }
        return node;
    }

    @Override
    public void visit(Node node) throws ELException {
        if (node instanceof AstFunction) {
            AstFunction astFunction = (AstFunction)node;
            Method method = null;
            if (this.fnMapper != null) {
                method = this.fnMapper.resolveFunction(astFunction.getPrefix(), astFunction.getLocalName());
            }
            if (method == null && this.varMapper != null && astFunction.getPrefix().length() == 0) {
                this.varMapper.resolveVariable(astFunction.getLocalName());
                return;
            }
            if (this.fnMapper == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.null"));
            }
            if (method == null) {
                throw new ELException(MessageFactory.get("error.fnMapper.method", astFunction.getOutputName()));
            }
            int n = method.getParameterTypes().length;
            int n2 = node.jjtGetChild(0).jjtGetNumChildren();
            if (method.isVarArgs() && n2 < n - 1 || !method.isVarArgs() && n2 != n) {
                throw new ELException(MessageFactory.get("error.fnMapper.paramcount", astFunction.getOutputName(), "" + n, "" + node.jjtGetChild(0).jjtGetNumChildren()));
            }
        } else if (node instanceof AstIdentifier && this.varMapper != null) {
            String string = ((AstIdentifier)node).getImage();
            this.varMapper.resolveVariable(string);
        }
    }

    public ValueExpression createValueExpression(Class<?> clazz) throws ELException {
        Node node = this.build();
        return new ValueExpressionImpl(this.expression, node, this.fnMapper, this.varMapper, clazz);
    }

    public MethodExpression createMethodExpression(Class<?> clazz, Class<?>[] classArray) throws ELException {
        Node node = this.build();
        if (!node.isParametersProvided() && classArray == null) {
            throw new NullPointerException(MessageFactory.get("error.method.nullParms"));
        }
        if (node instanceof AstValue || node instanceof AstIdentifier) {
            return new MethodExpressionImpl(this.expression, node, this.fnMapper, this.varMapper, clazz, classArray);
        }
        if (node instanceof AstLiteralExpression) {
            return new MethodExpressionLiteral(this.expression, clazz, classArray);
        }
        throw new ELException("Not a Valid Method Expression: " + this.expression);
    }

    static {
        String string = System.getSecurityManager() == null ? System.getProperty(CACHE_SIZE_PROP, "5000") : AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(ExpressionBuilder.CACHE_SIZE_PROP, "5000");
            }
        });
        CACHE_SIZE = Integer.parseInt(string);
        expressionCache = new ConcurrentCache(CACHE_SIZE);
    }

    private static class SynchronizedStack<T> {
        public static final int DEFAULT_SIZE = 128;
        private static final int DEFAULT_LIMIT = -1;
        private int size;
        private final int limit;
        private int index = -1;
        private Object[] stack;

        public SynchronizedStack() {
            this(128, -1);
        }

        public SynchronizedStack(int n, int n2) {
            this.size = n;
            this.limit = n2;
            this.stack = new Object[n];
        }

        public synchronized boolean push(T t) {
            ++this.index;
            if (this.index == this.size) {
                if (this.limit == -1 || this.size < this.limit) {
                    this.expand();
                } else {
                    --this.index;
                    return false;
                }
            }
            this.stack[this.index] = t;
            return true;
        }

        public synchronized T pop() {
            if (this.index == -1) {
                return null;
            }
            Object object = this.stack[this.index];
            this.stack[this.index--] = null;
            return (T)object;
        }

        private void expand() {
            int n = this.size * 2;
            if (this.limit != -1 && n > this.limit) {
                n = this.limit;
            }
            Object[] objectArray = new Object[n];
            System.arraycopy(this.stack, 0, objectArray, 0, this.size);
            this.stack = objectArray;
            this.size = n;
        }
    }
}

