/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.webresources;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import java.util.jar.Manifest;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.AbstractFileResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.apache.catalina.webresources.FileResource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class DirResourceSet
extends AbstractFileResourceSet {
    private static final Log log = LogFactory.getLog(DirResourceSet.class);

    public DirResourceSet() {
        super("/");
    }

    public DirResourceSet(WebResourceRoot webResourceRoot, String string, String string2, String string3) {
        super(string3);
        this.setRoot(webResourceRoot);
        this.setWebAppMount(string);
        this.setBase(string2);
        if (webResourceRoot.getContext().getAddWebinfClassesResources()) {
            File file = new File(string2, string3);
            if ((file = new File(file, "/WEB-INF/classes/META-INF/resources")).isDirectory()) {
                webResourceRoot.createWebResourceSet(WebResourceRoot.ResourceSetType.RESOURCE_JAR, "/", file.getAbsolutePath(), null, "/");
            }
        }
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException lifecycleException) {
                throw new IllegalStateException(lifecycleException);
            }
        }
    }

    @Override
    public WebResource getResource(String string) {
        this.checkPath(string);
        String string2 = this.getWebAppMount();
        WebResourceRoot webResourceRoot = this.getRoot();
        if (string.startsWith(string2)) {
            File file = this.file(string.substring(string2.length()), false);
            if (file == null) {
                return new EmptyResource(webResourceRoot, string);
            }
            if (!file.exists()) {
                return new EmptyResource(webResourceRoot, string, file);
            }
            if (file.isDirectory() && string.charAt(string.length() - 1) != '/') {
                string = string + '/';
            }
            return new FileResource(webResourceRoot, string, file, this.isReadOnly(), this.getManifest());
        }
        return new EmptyResource(webResourceRoot, string);
    }

    @Override
    public String[] list(String string) {
        this.checkPath(string);
        String string2 = this.getWebAppMount();
        if (string.startsWith(string2)) {
            File file = this.file(string.substring(string2.length()), true);
            if (file == null) {
                return EMPTY_STRING_ARRAY;
            }
            String[] stringArray = file.list();
            if (stringArray == null) {
                return EMPTY_STRING_ARRAY;
            }
            return stringArray;
        }
        if (!string.endsWith("/")) {
            string = string + "/";
        }
        if (string2.startsWith(string)) {
            int n = string2.indexOf(47, string.length());
            if (n == -1) {
                return new String[]{string2.substring(string.length())};
            }
            return new String[]{string2.substring(string.length(), n)};
        }
        return EMPTY_STRING_ARRAY;
    }

    @Override
    public Set<String> listWebAppPaths(String string) {
        this.checkPath(string);
        String string2 = this.getWebAppMount();
        ResourceSet<String> resourceSet = new ResourceSet<String>();
        if (string.startsWith(string2)) {
            File[] fileArray;
            File file = this.file(string.substring(string2.length()), true);
            if (file != null && (fileArray = file.listFiles()) != null) {
                for (File file2 : fileArray) {
                    StringBuilder stringBuilder = new StringBuilder(string);
                    if (string.charAt(string.length() - 1) != '/') {
                        stringBuilder.append('/');
                    }
                    stringBuilder.append(file2.getName());
                    if (file2.isDirectory()) {
                        stringBuilder.append('/');
                    }
                    resourceSet.add(stringBuilder.toString());
                }
            }
        } else {
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if (string2.startsWith(string)) {
                int n = string2.indexOf(47, string.length());
                if (n == -1) {
                    resourceSet.add(string2 + "/");
                } else {
                    resourceSet.add(string2.substring(0, n + 1));
                }
            }
        }
        resourceSet.setLocked(true);
        return resourceSet;
    }

    @Override
    public boolean mkdir(String string) {
        this.checkPath(string);
        if (this.isReadOnly()) {
            return false;
        }
        String string2 = this.getWebAppMount();
        if (string.startsWith(string2)) {
            File file = this.file(string.substring(string2.length()), false);
            if (file == null) {
                return false;
            }
            return file.mkdir();
        }
        return false;
    }

    @Override
    public boolean write(String string, InputStream inputStream, boolean bl) {
        this.checkPath(string);
        if (inputStream == null) {
            throw new NullPointerException(sm.getString("dirResourceSet.writeNpe"));
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (string.endsWith("/")) {
            return false;
        }
        File file = null;
        String string2 = this.getWebAppMount();
        if (string.startsWith(string2)) {
            file = this.file(string.substring(string2.length()), false);
            if (file == null) {
                return false;
            }
        } else {
            return false;
        }
        if (file.exists() && !bl) {
            return false;
        }
        try {
            if (bl) {
                Files.copy(inputStream, file.toPath(), StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.copy(inputStream, file.toPath(), new CopyOption[0]);
            }
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    @Override
    protected void checkType(File file) {
        if (!file.isDirectory()) {
            throw new IllegalArgumentException(sm.getString("dirResourceSet.notDirectory", new Object[]{this.getBase(), File.separator, this.getInternalPath()}));
        }
    }

    @Override
    protected void initInternal() throws LifecycleException {
        File file;
        super.initInternal();
        if (this.getWebAppMount().equals("") && (file = this.file("META-INF/MANIFEST.MF", true)) != null && file.isFile()) {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                this.setManifest(new Manifest(fileInputStream));
            }
            catch (IOException iOException) {
                log.warn((Object)sm.getString("dirResourceSet.manifestFail", new Object[]{file.getAbsolutePath()}), (Throwable)iOException);
            }
        }
    }
}

