/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.OopHandle;
import sun.jvm.hotspot.memory.SystemDictionary;
import sun.jvm.hotspot.oops.CIntField;
import sun.jvm.hotspot.oops.InstanceKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.ObjectHeap;
import sun.jvm.hotspot.oops.Oop;
import sun.jvm.hotspot.oops.OopField;
import sun.jvm.hotspot.oops.OopVisitor;
import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Bits;

public class ArrayKlass
extends Klass {
    private static CIntField dimension;
    private static OopField higherDimension;
    private static OopField lowerDimension;
    private static CIntField vtableLen;
    private static CIntField allocSize;
    private static OopField componentMirror;
    private static Symbol javaLangCloneableName;
    private static Symbol javaLangObjectName;
    private static Symbol javaIoSerializableName;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("arrayKlass");
        dimension = new CIntField(type.getCIntegerField("_dimension"), Oop.getHeaderSize());
        higherDimension = new OopField(type.getOopField("_higher_dimension"), Oop.getHeaderSize());
        lowerDimension = new OopField(type.getOopField("_lower_dimension"), Oop.getHeaderSize());
        vtableLen = new CIntField(type.getCIntegerField("_vtable_len"), Oop.getHeaderSize());
        allocSize = new CIntField(type.getCIntegerField("_alloc_size"), Oop.getHeaderSize());
        componentMirror = new OopField(type.getOopField("_component_mirror"), Oop.getHeaderSize());
        javaLangCloneableName = null;
        javaLangObjectName = null;
        javaIoSerializableName = null;
    }

    ArrayKlass(OopHandle handle, ObjectHeap heap) {
        super(handle, heap);
    }

    @Override
    public Klass getJavaSuper() {
        SystemDictionary sysDict = VM.getVM().getSystemDictionary();
        return sysDict.getObjectKlass();
    }

    public long getDimension() {
        return dimension.getValue(this);
    }

    public Klass getHigherDimension() {
        return (Klass)higherDimension.getValue(this);
    }

    public Klass getLowerDimension() {
        return (Klass)lowerDimension.getValue(this);
    }

    public long getVtableLen() {
        return vtableLen.getValue(this);
    }

    public long getAllocSize() {
        return allocSize.getValue(this);
    }

    public Oop getComponentMirror() {
        return componentMirror.getValue(this);
    }

    private static Symbol javaLangCloneableName() {
        if (javaLangCloneableName == null) {
            javaLangCloneableName = VM.getVM().getSymbolTable().probe("java/lang/Cloneable");
        }
        return javaLangCloneableName;
    }

    private static Symbol javaLangObjectName() {
        if (javaLangObjectName == null) {
            javaLangObjectName = VM.getVM().getSymbolTable().probe("java/lang/Object");
        }
        return javaLangObjectName;
    }

    private static Symbol javaIoSerializableName() {
        if (javaIoSerializableName == null) {
            javaIoSerializableName = VM.getVM().getSymbolTable().probe("java/io/Serializable");
        }
        return javaIoSerializableName;
    }

    @Override
    public int getClassStatus() {
        return 7;
    }

    @Override
    public long computeModifierFlags() {
        return 1041L;
    }

    public long getArrayHeaderInBytes() {
        return Bits.maskBits(this.getLayoutHelper() >> LH_HEADER_SIZE_SHIFT, 255);
    }

    public int getLog2ElementSize() {
        return Bits.maskBits(this.getLayoutHelper() >> LH_LOG2_ELEMENT_SIZE_SHIFT, 255);
    }

    public int getElementType() {
        return Bits.maskBits(this.getLayoutHelper() >> LH_ELEMENT_TYPE_SHIFT, 255);
    }

    @Override
    boolean computeSubtypeOf(Klass k) {
        Symbol name = k.getName();
        return name != null && (name.equals(ArrayKlass.javaIoSerializableName()) || name.equals(ArrayKlass.javaLangCloneableName()) || name.equals(ArrayKlass.javaLangObjectName()));
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("ArrayKlass");
    }

    @Override
    public long getObjectSize() {
        return ArrayKlass.alignObjectSize(InstanceKlass.getHeaderSize() + this.getVtableLen() * this.getHeap().getOopSize());
    }

    @Override
    public void iterateFields(OopVisitor visitor, boolean doVMFields) {
        super.iterateFields(visitor, doVMFields);
        if (doVMFields) {
            visitor.doCInt(dimension, true);
            visitor.doOop(higherDimension, true);
            visitor.doOop(lowerDimension, true);
            visitor.doCInt(vtableLen, true);
            visitor.doCInt(allocSize, true);
            visitor.doOop(componentMirror, true);
        }
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ArrayKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

