/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.compat;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.concurrent.Executor;
import java.util.zip.GZIPOutputStream;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.compat.JreCompat;
import org.apache.tomcat.util.res.StringManager;

class Jre7Compat
extends JreCompat {
    private static final Log log = LogFactory.getLog(Jre7Compat.class);
    private static final StringManager sm = StringManager.getManager(Jre7Compat.class);
    private static final int RUNTIME_MAJOR_VERSION = 7;
    private static final Method forLanguageTagMethod;
    private static final Constructor<GZIPOutputStream> gzipOutputStreamConstructor;
    private static final Method callableStatementGetObjectIndex;
    private static final Method callableStatementGetObjectName;
    private static final Method connectionSetSchema;
    private static final Method connectionGetSchema;
    private static final Method connectionAbort;
    private static final Method connectionSetNetworkTimeout;
    private static final Method connectionGetNetworkTimeout;
    private static final Method databaseMetaDataGetPseudoColumns;
    private static final Method databaseMetaDataGeneratedKeyAlwaysReturned;
    private static final Method resultSetGetObjectIndex;
    private static final Method resultSetGetObjectName;
    private static final Method statementCloseOnCompletion;
    private static final Method statementIsCloseOnCompletion;
    private static final Method getLoopbackAddress;

    Jre7Compat() {
    }

    static boolean isSupported() {
        return forLanguageTagMethod != null;
    }

    @Override
    public Locale forLanguageTag(String string) {
        try {
            return (Locale)forLanguageTagMethod.invoke(null, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
            return null;
        }
        catch (InvocationTargetException invocationTargetException) {
            return null;
        }
    }

    @Override
    public GZIPOutputStream getFlushableGZipOutputStream(OutputStream outputStream) {
        try {
            return gzipOutputStreamConstructor.newInstance(outputStream, Boolean.TRUE);
        }
        catch (InstantiationException instantiationException) {
            throw new UnsupportedOperationException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException(illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException(illegalArgumentException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException(invocationTargetException);
        }
    }

    @Override
    public <T> T getObject(CallableStatement callableStatement, int n, Class<T> clazz) throws SQLException {
        try {
            return (T)callableStatementGetObjectIndex.invoke((Object)callableStatement, n, clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public <T> T getObject(CallableStatement callableStatement, String string, Class<T> clazz) throws SQLException {
        try {
            return (T)callableStatementGetObjectName.invoke((Object)callableStatement, string, clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public void setSchema(Connection connection, String string) throws SQLException {
        try {
            connectionSetSchema.invoke((Object)connection, string);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public String getSchema(Connection connection) throws SQLException {
        try {
            return (String)connectionGetSchema.invoke((Object)connection, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public void abort(Connection connection, Executor executor) throws SQLException {
        try {
            connectionAbort.invoke((Object)connection, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public void setNetworkTimeout(Connection connection, Executor executor, int n) throws SQLException {
        try {
            connectionSetNetworkTimeout.invoke((Object)connection, executor, n);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public int getNetworkTimeout(Connection connection) throws SQLException {
        try {
            return (Integer)connectionGetNetworkTimeout.invoke((Object)connection, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public ResultSet getPseudoColumns(DatabaseMetaData databaseMetaData, String string, String string2, String string3, String string4) throws SQLException {
        try {
            return (ResultSet)databaseMetaDataGetPseudoColumns.invoke((Object)databaseMetaData, string, string2, string3, string4);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public boolean generatedKeyAlwaysReturned(DatabaseMetaData databaseMetaData) throws SQLException {
        try {
            return (Boolean)databaseMetaDataGeneratedKeyAlwaysReturned.invoke((Object)databaseMetaData, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public <T> T getObject(ResultSet resultSet, int n, Class<T> clazz) throws SQLException {
        try {
            return (T)resultSetGetObjectIndex.invoke((Object)resultSet, n, clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public <T> T getObject(ResultSet resultSet, String string, Class<T> clazz) throws SQLException {
        try {
            return (T)resultSetGetObjectName.invoke((Object)resultSet, string, clazz);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public void closeOnCompletion(Statement statement) throws SQLException {
        try {
            statementCloseOnCompletion.invoke((Object)statement, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public boolean isCloseOnCompletion(Statement statement) throws SQLException {
        try {
            return (Boolean)statementIsCloseOnCompletion.invoke((Object)statement, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SQLException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SQLException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new SQLException(invocationTargetException);
        }
    }

    @Override
    public InetAddress getLoopbackAddress() {
        try {
            return (InetAddress)getLoopbackAddress.invoke(null, new Object[0]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new UnsupportedOperationException(illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new UnsupportedOperationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new UnsupportedOperationException(invocationTargetException);
        }
    }

    @Override
    public int jarFileRuntimeMajorVersion() {
        return 7;
    }

    @Override
    public boolean isCommonsAnnotations1_1Available() {
        return true;
    }

    static {
        Method method = null;
        Method method2 = null;
        Method method3 = null;
        Method method4 = null;
        Method method5 = null;
        Method method6 = null;
        Method method7 = null;
        Method method8 = null;
        Method method9 = null;
        Method method10 = null;
        Method method11 = null;
        Method method12 = null;
        Method method13 = null;
        Method method14 = null;
        Method method15 = null;
        Constructor constructor = null;
        try {
            method = Locale.class.getMethod("forLanguageTag", String.class);
            constructor = GZIPOutputStream.class.getConstructor(OutputStream.class, Boolean.TYPE);
            method2 = CallableStatement.class.getMethod("getObject", Integer.TYPE, Class.class);
            method3 = CallableStatement.class.getMethod("getObject", String.class, Class.class);
            method4 = Connection.class.getMethod("setSchema", String.class);
            method5 = Connection.class.getMethod("getSchema", new Class[0]);
            method6 = Connection.class.getMethod("abort", Executor.class);
            method7 = Connection.class.getMethod("setNetworkTimeout", Executor.class, Integer.TYPE);
            method8 = Connection.class.getMethod("getNetworkTimeout", new Class[0]);
            method9 = DatabaseMetaData.class.getMethod("getPseudoColumns", String.class, String.class, String.class, String.class);
            method10 = DatabaseMetaData.class.getMethod("generatedKeyAlwaysReturned", new Class[0]);
            method11 = ResultSet.class.getMethod("getObject", Integer.TYPE, Class.class);
            method12 = ResultSet.class.getMethod("getObject", String.class, Class.class);
            method13 = Statement.class.getMethod("closeOnCompletion", new Class[0]);
            method14 = Statement.class.getMethod("isCloseOnCompletion", new Class[0]);
            method15 = InetAddress.class.getMethod("getLoopbackAddress", new Class[0]);
        }
        catch (SecurityException securityException) {
            log.error((Object)sm.getString("jre7Compat.unexpected"), (Throwable)securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            if (method == null) {
                log.debug((Object)sm.getString("jre7Compat.javaPre7"), (Throwable)noSuchMethodException);
            }
            log.error((Object)sm.getString("jre7Compat.unexpected"), (Throwable)noSuchMethodException);
        }
        forLanguageTagMethod = method;
        gzipOutputStreamConstructor = constructor;
        callableStatementGetObjectIndex = method2;
        callableStatementGetObjectName = method3;
        connectionSetSchema = method4;
        connectionGetSchema = method5;
        connectionAbort = method6;
        connectionSetNetworkTimeout = method7;
        connectionGetNetworkTimeout = method8;
        databaseMetaDataGetPseudoColumns = method9;
        databaseMetaDataGeneratedKeyAlwaysReturned = method10;
        resultSetGetObjectIndex = method11;
        resultSetGetObjectName = method12;
        statementCloseOnCompletion = method13;
        statementIsCloseOnCompletion = method14;
        getLoopbackAddress = method15;
    }
}

