/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.naming.NameParserImpl;
import org.apache.naming.NamingContextBindingsEnumeration;
import org.apache.naming.NamingContextEnumeration;
import org.apache.naming.NamingEntry;
import org.apache.naming.StringManager;
import org.apache.naming.resources.FileDirContext;
import org.apache.naming.resources.WARDirContext;

public abstract class BaseDirContext
implements DirContext {
    private static final Log log = LogFactory.getLog(BaseDirContext.class);
    protected String docBase = null;
    protected Hashtable<String, Object> env;
    protected static final StringManager sm = StringManager.getManager("org.apache.naming.resources");
    protected final NameParser nameParser = new NameParserImpl();
    protected boolean cached = true;
    protected int cacheTTL = 5000;
    protected int cacheMaxSize = 10240;
    protected int cacheObjectMaxSize = 512;
    protected Map<String, BaseDirContext> aliases = new HashMap<String, BaseDirContext>();
    protected List<DirContext> altDirContexts = new ArrayList<DirContext>();

    public BaseDirContext() {
        this.env = new Hashtable();
    }

    public BaseDirContext(Hashtable<String, Object> hashtable) {
        this.env = hashtable;
    }

    public void addResourcesJar(URL uRL) {
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            ZipEntry zipEntry = jarFile.getEntry("/");
            WARDirContext wARDirContext = new WARDirContext(jarFile, new WARDirContext.Entry("/", zipEntry));
            wARDirContext.loadEntries();
            this.altDirContexts.add(wARDirContext);
        }
        catch (IOException iOException) {
            log.warn((Object)sm.getString("resources.addResourcesJarFail", uRL), (Throwable)iOException);
        }
    }

    public void addAltDirContext(DirContext dirContext) {
        this.altDirContexts.add(dirContext);
    }

    public void addAlias(String string, BaseDirContext baseDirContext) {
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("resources.invalidAliasPath", string));
        }
        this.aliases.put(string, baseDirContext);
    }

    public void removeAlias(String string) {
        if (!string.startsWith("/")) {
            throw new IllegalArgumentException(sm.getString("resources.invalidAliasPath", string));
        }
        this.aliases.remove(string);
    }

    public String getAliases() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, BaseDirContext>> iterator = this.aliases.entrySet().iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            Map.Entry<String, BaseDirContext> entry = iterator.next();
            stringBuilder.append(entry.getKey());
            stringBuilder.append('=');
            stringBuilder.append(entry.getValue().getDocBase());
        }
        return stringBuilder.toString();
    }

    public void setAliases(String string) {
        String[] stringArray;
        this.aliases.clear();
        if (string == null || string.length() == 0) {
            return;
        }
        for (String string2 : stringArray = string.split(",")) {
            BaseDirContext baseDirContext;
            if (0 == (string2 = string2.trim()).length()) continue;
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length != 2) {
                throw new IllegalArgumentException(sm.getString("resources.invalidAliasMapping", string2));
            }
            stringArray2[0] = stringArray2[0].trim();
            stringArray2[1] = stringArray2[1].trim();
            if (stringArray2[0].length() == 0 || stringArray2[1].length() == 0) {
                throw new IllegalArgumentException(sm.getString("resources.invalidAliasMapping", string2));
            }
            if (stringArray2[0].equals("/")) {
                throw new IllegalArgumentException(sm.getString("resources.invalidAliasNotAllowed", stringArray2[0]));
            }
            File file = new File(stringArray2[1]);
            if (!file.exists()) {
                throw new IllegalArgumentException(sm.getString("resources.invalidAliasNotExist", stringArray2[1]));
            }
            if (stringArray2[1].endsWith(".war") && !file.isDirectory()) {
                baseDirContext = new WARDirContext();
            } else if (file.isDirectory()) {
                baseDirContext = new FileDirContext();
            } else {
                throw new IllegalArgumentException(sm.getString("resources.invalidAliasFile", stringArray2[1]));
            }
            baseDirContext.setDocBase(stringArray2[1]);
            this.addAlias(stringArray2[0], baseDirContext);
        }
    }

    public String getDocBase() {
        return this.docBase;
    }

    public void setDocBase(String string) {
        if (string == null) {
            throw new IllegalArgumentException(sm.getString("resources.null"));
        }
        this.docBase = string;
    }

    public void setCached(boolean bl) {
        this.cached = bl;
    }

    public boolean isCached() {
        return this.cached;
    }

    public void setCacheTTL(int n) {
        this.cacheTTL = n;
    }

    public int getCacheTTL() {
        return this.cacheTTL;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize;
    }

    public void setCacheMaxSize(int n) {
        this.cacheMaxSize = n;
    }

    public int getCacheObjectMaxSize() {
        return this.cacheObjectMaxSize;
    }

    public void setCacheObjectMaxSize(int n) {
        this.cacheObjectMaxSize = n;
    }

    public void allocate() {
    }

    public void release() {
        for (BaseDirContext dirContext : this.aliases.values()) {
            dirContext.release();
        }
        this.aliases.clear();
        for (DirContext dirContext : this.altDirContexts) {
            if (!(dirContext instanceof BaseDirContext)) continue;
            ((BaseDirContext)dirContext).release();
        }
        this.altDirContexts.clear();
    }

    public String getRealPath(String string) {
        Object object;
        if (!this.aliases.isEmpty()) {
            object = this.findAlias(string);
            if (((AliasResult)object).dirContext != null) {
                return ((AliasResult)object).dirContext.doGetRealPath(((AliasResult)object).aliasName);
            }
        }
        if ((object = this.doGetRealPath(string)) != null) {
            return object;
        }
        String string2 = "/META-INF/resources" + string;
        for (DirContext dirContext : this.altDirContexts) {
            if (!(dirContext instanceof BaseDirContext) || (object = ((BaseDirContext)dirContext).getRealPath(string2)) == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public final Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public final Object lookup(String string) throws NamingException {
        Object object = this.doLookupWithoutNNFE(string);
        if (object != null) {
            return object;
        }
        throw new NameNotFoundException(sm.getString("resources.notFound", string));
    }

    private Object doLookupWithoutNNFE(String string) throws NamingException {
        Object object;
        if (!this.aliases.isEmpty()) {
            object = this.findAlias(string);
            if (((AliasResult)object).dirContext != null) {
                return ((AliasResult)object).dirContext.lookup(((AliasResult)object).aliasName);
            }
        }
        if ((object = this.doLookup(string)) != null) {
            return object;
        }
        if (string.endsWith(".class")) {
            return null;
        }
        String string2 = "/META-INF/resources" + string;
        for (DirContext dirContext : this.altDirContexts) {
            if (dirContext instanceof BaseDirContext) {
                object = ((BaseDirContext)dirContext).doLookupWithoutNNFE(string2);
            } else {
                try {
                    object = dirContext.lookup(string2);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            if (object == null) continue;
            return object;
        }
        return null;
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        this.bind(name.toString(), object);
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        this.bind(string, object, null);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        this.rebind(name.toString(), object);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        this.rebind(string, object, null);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public abstract void unbind(String var1) throws NamingException;

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        this.rename(name.toString(), name2.toString());
    }

    @Override
    public abstract void rename(String var1, String var2) throws NamingException;

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String string) throws NamingException {
        List<NamingEntry> list;
        if (!this.aliases.isEmpty()) {
            list = this.findAlias(string);
            if (((AliasResult)((Object)list)).dirContext != null) {
                return ((AliasResult)((Object)list)).dirContext.list(((AliasResult)((Object)list)).aliasName);
            }
        }
        list = this.doListBindings(string);
        List<NamingEntry> list2 = null;
        String string2 = "/META-INF/resources" + string;
        for (DirContext dirContext : this.altDirContexts) {
            if (dirContext instanceof BaseDirContext) {
                list2 = ((BaseDirContext)dirContext).doListBindings(string2);
            }
            if (list2 == null) continue;
            if (list == null) {
                list = list2;
                continue;
            }
            list.addAll(list2);
        }
        if (list != null) {
            return new NamingContextEnumeration(list.iterator());
        }
        throw new NameNotFoundException(sm.getString("resources.notFound", string));
    }

    @Override
    public final NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public final NamingEnumeration<Binding> listBindings(String string) throws NamingException {
        List<NamingEntry> list;
        if (!this.aliases.isEmpty()) {
            list = this.findAlias(string);
            if (((AliasResult)((Object)list)).dirContext != null) {
                return ((AliasResult)((Object)list)).dirContext.listBindings(((AliasResult)((Object)list)).aliasName);
            }
        }
        list = this.doListBindings(string);
        List<NamingEntry> list2 = null;
        String string2 = "/META-INF/resources" + string;
        for (DirContext dirContext : this.altDirContexts) {
            if (dirContext instanceof BaseDirContext) {
                list2 = ((BaseDirContext)dirContext).doListBindings(string2);
            }
            if (list2 == null) continue;
            if (list == null) {
                list = list2;
                continue;
            }
            list.addAll(list2);
        }
        if (list != null) {
            return new NamingContextBindingsEnumeration(list.iterator(), this);
        }
        throw new NameNotFoundException(sm.getString("resources.notFound", string));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public abstract void destroySubcontext(String var1) throws NamingException;

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        return this.createSubcontext(string, null);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public abstract Object lookupLink(String var1) throws NamingException;

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return new NameParserImpl();
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        return new NameParserImpl();
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        Name name3 = (Name)name2.clone();
        return name3.addAll(name);
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        return string2 + "/" + string;
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        return this.env.put(string, object);
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        return this.env.remove(string);
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        return this.env;
    }

    @Override
    public void close() throws NamingException {
        this.env.clear();
    }

    @Override
    public abstract String getNameInNamespace() throws NamingException;

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    @Override
    public Attributes getAttributes(String string) throws NamingException {
        return this.getAttributes(string, null);
    }

    @Override
    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        return this.getAttributes(name.toString(), stringArray);
    }

    @Override
    public final Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        Object object;
        if (!this.aliases.isEmpty()) {
            object = this.findAlias(string);
            if (((AliasResult)object).dirContext != null) {
                return ((AliasResult)object).dirContext.getAttributes(((AliasResult)object).aliasName, stringArray);
            }
        }
        if ((object = this.doGetAttributes(string, stringArray)) != null) {
            return object;
        }
        String string2 = "/META-INF/resources" + string;
        for (DirContext dirContext : this.altDirContexts) {
            if (dirContext instanceof BaseDirContext) {
                object = ((BaseDirContext)dirContext).doGetAttributes(string2, stringArray);
            } else {
                try {
                    object = dirContext.getAttributes(string, stringArray);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
            }
            if (object == null) continue;
            return object;
        }
        throw new NameNotFoundException(sm.getString("resources.notFound", string));
    }

    @Override
    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        this.modifyAttributes(name.toString(), n, attributes);
    }

    @Override
    public abstract void modifyAttributes(String var1, int var2, Attributes var3) throws NamingException;

    @Override
    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        this.modifyAttributes(name.toString(), modificationItemArray);
    }

    @Override
    public abstract void modifyAttributes(String var1, ModificationItem[] var2) throws NamingException;

    @Override
    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        this.bind(name.toString(), object, attributes);
    }

    @Override
    public abstract void bind(String var1, Object var2, Attributes var3) throws NamingException;

    @Override
    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        this.rebind(name.toString(), object, attributes);
    }

    @Override
    public abstract void rebind(String var1, Object var2, Attributes var3) throws NamingException;

    @Override
    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        return this.createSubcontext(name.toString(), attributes);
    }

    @Override
    public abstract DirContext createSubcontext(String var1, Attributes var2) throws NamingException;

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        return this.getSchema(name.toString());
    }

    @Override
    public abstract DirContext getSchema(String var1) throws NamingException;

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        return this.getSchemaClassDefinition(name.toString());
    }

    @Override
    public abstract DirContext getSchemaClassDefinition(String var1) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        return this.search(name.toString(), attributes, stringArray);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, Attributes var2, String[] var3) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes attributes) throws NamingException {
        return this.search(name.toString(), attributes);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, Attributes var2) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String string, SearchControls searchControls) throws NamingException {
        return this.search(name.toString(), string, searchControls);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, String var2, SearchControls var3) throws NamingException;

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        return this.search(name.toString(), string, objectArray, searchControls);
    }

    @Override
    public abstract NamingEnumeration<SearchResult> search(String var1, String var2, Object[] var3, SearchControls var4) throws NamingException;

    protected abstract Attributes doGetAttributes(String var1, String[] var2) throws NamingException;

    protected abstract Object doLookup(String var1);

    protected abstract List<NamingEntry> doListBindings(String var1) throws NamingException;

    protected abstract String doGetRealPath(String var1);

    private AliasResult findAlias(String string) {
        int n;
        boolean bl;
        String string2;
        AliasResult aliasResult = new AliasResult();
        if (string.length() == 0) {
            string2 = "/";
            bl = true;
        } else if (string.charAt(0) == '/') {
            string2 = string;
            bl = false;
        } else {
            string2 = "/" + string;
            bl = true;
        }
        aliasResult.dirContext = this.aliases.get(string2);
        while (aliasResult.dirContext == null && (n = string2.lastIndexOf(47)) >= 0) {
            string2 = string2.substring(0, n);
            aliasResult.dirContext = this.aliases.get(string2);
        }
        if (aliasResult.dirContext != null) {
            aliasResult.aliasName = bl ? string.substring(string2.length() - 1) : string.substring(string2.length());
        }
        return aliasResult;
    }

    private static class AliasResult {
        BaseDirContext dirContext;
        String aliasName;

        private AliasResult() {
        }
    }
}

