/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.util.regex.Pattern;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.ajp.AbstractAjpProcessor;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.servlet31.HttpUpgradeHandler;
import org.apache.tomcat.util.net.SocketWrapper;
import org.apache.tomcat.util.res.StringManager;

public abstract class AbstractAjpProtocol<S>
extends AbstractProtocol<S> {
    protected static final StringManager sm = StringManager.getManager(AbstractAjpProtocol.class);
    protected boolean ajpFlush = true;
    protected boolean tomcatAuthentication = true;
    private boolean tomcatAuthorization = false;
    protected String requiredSecret = null;
    private String secret = null;
    private boolean secretRequired = true;
    private Pattern allowedRequestAttributesPatternPattern;
    protected int packetSize = 8192;

    @Override
    protected String getProtocolName() {
        return "Ajp";
    }

    public boolean getAjpFlush() {
        return this.ajpFlush;
    }

    public void setAjpFlush(boolean bl) {
        this.ajpFlush = bl;
    }

    public boolean getTomcatAuthentication() {
        return this.tomcatAuthentication;
    }

    public void setTomcatAuthentication(boolean bl) {
        this.tomcatAuthentication = bl;
    }

    public boolean getTomcatAuthorization() {
        return this.tomcatAuthorization;
    }

    public void setTomcatAuthorization(boolean bl) {
        this.tomcatAuthorization = bl;
    }

    public void setSecret(String string) {
        this.secret = string;
        this.requiredSecret = string;
    }

    protected String getSecret() {
        return this.secret;
    }

    @Deprecated
    public void setRequiredSecret(String string) {
        this.setSecret(string);
    }

    @Deprecated
    protected String getRequiredSecret() {
        return this.getSecret();
    }

    public void setSecretRequired(boolean bl) {
        this.secretRequired = bl;
    }

    public boolean getSecretRequired() {
        return this.secretRequired;
    }

    public void setAllowedRequestAttributesPattern(String string) {
        this.allowedRequestAttributesPatternPattern = Pattern.compile(string);
    }

    public String getAllowedRequestAttributesPattern() {
        return this.allowedRequestAttributesPatternPattern.pattern();
    }

    protected Pattern getAllowedRequestAttributesPatternPattern() {
        return this.allowedRequestAttributesPatternPattern;
    }

    public int getPacketSize() {
        return this.packetSize;
    }

    public void setPacketSize(int n) {
        this.packetSize = n < 8192 ? 8192 : n;
    }

    @Override
    public void start() throws Exception {
        String string;
        if (this.getSecretRequired() && ((string = this.getSecret()) == null || string.length() == 0)) {
            throw new IllegalArgumentException(sm.getString("ajpprotocol.noSecret"));
        }
        super.start();
    }

    protected static abstract class AbstractAjpConnectionHandler<S, P extends AbstractAjpProcessor<S>>
    extends AbstractProtocol.AbstractConnectionHandler<S, P> {
        protected AbstractAjpConnectionHandler() {
        }

        @Override
        protected void initSsl(SocketWrapper<S> socketWrapper, Processor<S> processor) {
        }

        @Override
        protected void longPoll(SocketWrapper<S> socketWrapper, Processor<S> processor) {
            socketWrapper.setAsync(true);
        }

        @Deprecated
        protected P createUpgradeProcessor(SocketWrapper<S> socketWrapper, UpgradeInbound upgradeInbound) {
            return null;
        }

        protected P createUpgradeProcessor(SocketWrapper<S> socketWrapper, HttpUpgradeHandler httpUpgradeHandler) {
            return null;
        }
    }
}

