/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.modeler.modules;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.loading.MLet;
import javax.xml.transform.TransformerException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.DomUtil;
import org.apache.tomcat.util.modeler.AttributeInfo;
import org.apache.tomcat.util.modeler.BaseModelMBean;
import org.apache.tomcat.util.modeler.ManagedBean;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.modeler.modules.MbeansSourceMBean;
import org.apache.tomcat.util.modeler.modules.ModelerSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Deprecated
public class MbeansSource
extends ModelerSource
implements MbeansSourceMBean {
    private static final Log log = LogFactory.getLog(MbeansSource.class);
    Registry registry;
    String type;
    boolean loading = true;
    List<ObjectName> mbeans = new ArrayList<ObjectName>();
    static boolean loaderLoaded = false;
    private Document document;
    private HashMap<ObjectName, Node> object2Node = new HashMap();
    long lastUpdate;
    long updateInterval = 10000L;

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setType(String string) {
        this.type = string;
    }

    @Override
    public void setSource(Object object) {
        this.source = object;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public List<ObjectName> getMBeans() {
        return this.mbeans;
    }

    @Override
    public List<ObjectName> loadDescriptors(Registry registry, String string, Object object) throws Exception {
        this.setRegistry(registry);
        this.setType(string);
        this.setSource(object);
        this.execute();
        return this.mbeans;
    }

    public void start() throws Exception {
        this.registry.invoke(this.mbeans, "start", false);
    }

    public void stop() throws Exception {
        this.registry.invoke(this.mbeans, "stop", false);
    }

    @Override
    public void init() throws Exception {
        if (this.mbeans == null) {
            this.execute();
        }
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        this.registry.invoke(this.mbeans, "init", false);
    }

    public void destroy() throws Exception {
        this.registry.invoke(this.mbeans, "destroy", false);
    }

    @Override
    public void load() throws Exception {
        this.execute();
    }

    public void execute() throws Exception {
        if (this.registry == null) {
            this.registry = Registry.getRegistry(null, null);
        }
        try {
            Object object;
            Object object2;
            InputStream inputStream = this.getInputStream();
            long l = System.currentTimeMillis();
            this.document = DomUtil.readXml(inputStream);
            Element element = this.document.getDocumentElement();
            if (element == null) {
                log.error((Object)"No descriptors found");
                return;
            }
            Node node = DomUtil.getChild((Node)element, null);
            if (node == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("No child " + element));
                }
                node = element;
            }
            MBeanServer mBeanServer = Registry.getRegistry(null, null).getMBeanServer();
            if (!loaderLoaded) {
                object2 = new ObjectName("modeler", "loader", "modeler");
                object = new MLet(new URL[0], this.getClass().getClassLoader());
                mBeanServer.registerMBean(object, (ObjectName)object2);
                loaderLoaded = true;
            }
            object2 = node;
            while (object2 != null) {
                Object object3;
                Object object4;
                Object object5;
                Object object6;
                object = object2.getNodeName();
                if ("mbean".equals(object) || "MLET".equals(object)) {
                    Object object7;
                    object6 = DomUtil.getAttribute((Node)object2, "code");
                    object5 = DomUtil.getAttribute((Node)object2, "objectName");
                    if (object5 == null) {
                        object5 = DomUtil.getAttribute((Node)object2, "name");
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processing mbean objectName=" + (String)object5 + " code=" + (String)object6));
                    }
                    if ((object4 = DomUtil.getChild((Node)object2, "constructor")) == null) {
                        object4 = object2;
                    }
                    this.processArg((Node)object4);
                    try {
                        object3 = new ObjectName((String)object5);
                        if (!mBeanServer.isRegistered((ObjectName)object3)) {
                            object7 = BaseModelMBean.class.getName();
                            mBeanServer.createMBean((String)object7, (ObjectName)object3, new Object[]{object6, this}, new String[]{String.class.getName(), ModelerSource.class.getName()});
                            this.mbeans.add((ObjectName)object3);
                        }
                        this.object2Node.put((ObjectName)object3, (Node)object2);
                    }
                    catch (Exception exception) {
                        log.error((Object)("Error creating mbean " + (String)object5), (Throwable)exception);
                    }
                    object7 = object3 = DomUtil.getChild((Node)object2, "attribute");
                    while (object7 != null) {
                        this.processAttribute(mBeanServer, (Node)object7, (String)object5);
                        object7 = DomUtil.getNext((Node)object7);
                    }
                } else if ("jmx-operation".equals(object)) {
                    object6 = DomUtil.getAttribute((Node)object2, "objectName");
                    if (object6 == null) {
                        object6 = DomUtil.getAttribute((Node)object2, "name");
                    }
                    object5 = DomUtil.getAttribute((Node)object2, "operation");
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Processing invoke objectName=" + (String)object6 + " code=" + (String)object5));
                    }
                    try {
                        object4 = new ObjectName((String)object6);
                        this.processArg((Node)object2);
                        mBeanServer.invoke((ObjectName)object4, (String)object5, null, null);
                    }
                    catch (Exception exception) {
                        log.error((Object)("Error in invoke " + (String)object6 + " " + (String)object5));
                    }
                }
                object6 = new ManagedBean();
                DomUtil.setAttributes(object6, (Node)object2);
                object4 = object5 = DomUtil.getChild((Node)object2, "attribute");
                while (object4 != null) {
                    object3 = new AttributeInfo();
                    DomUtil.setAttributes(object3, (Node)object4);
                    ((ManagedBean)object6).addAttribute((AttributeInfo)object3);
                    object4 = DomUtil.getNext((Node)object4);
                }
                object2 = DomUtil.getNext((Node)object2, null, 1);
            }
            long l2 = System.currentTimeMillis();
            log.info((Object)("Reading mbeans  " + (l2 - l)));
            this.loading = false;
        }
        catch (Exception exception) {
            log.error((Object)"Error reading mbeans ", (Throwable)exception);
        }
    }

    @Override
    public void updateField(ObjectName objectName, String string, Object object) {
        String string2;
        if (this.loading) {
            return;
        }
        Node node = this.object2Node.get(objectName);
        if (node == null) {
            log.info((Object)("Node not found " + objectName));
            return;
        }
        Node node2 = DomUtil.findChildWithAtt(node, "attribute", "name", string);
        if (node2 == null) {
            node2 = node.getOwnerDocument().createElement("attribute");
            DomUtil.setAttribute(node2, "name", string);
            node.appendChild(node2);
        }
        if ((string2 = DomUtil.getAttribute(node2, "value")) != null) {
            DomUtil.removeAttribute(node2, "value");
        }
        DomUtil.setText(node2, object.toString());
    }

    @Override
    public void save() {
        long l = System.currentTimeMillis();
        if (this.location != null && l - this.lastUpdate > this.updateInterval) {
            this.lastUpdate = l;
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(this.location);
                DomUtil.writeXml(this.document, fileOutputStream);
            }
            catch (TransformerException transformerException) {
                log.error((Object)"Error writing");
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.error((Object)"Error writing", (Throwable)fileNotFoundException);
            }
        }
    }

    private void processAttribute(MBeanServer mBeanServer, Node node, String string) {
        String string2 = DomUtil.getAttribute(node, "name");
        String string3 = DomUtil.getAttribute(node, "value");
        String string4 = null;
        if (string3 == null) {
            string3 = DomUtil.getContent(node);
        }
        try {
            ObjectName objectName;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Set attribute " + string + " " + string2 + " " + string3));
            }
            if ((string4 = this.registry.getType(objectName = new ObjectName(string), string2)) == null) {
                log.info((Object)("Can't find attribute " + string + " " + string2));
            } else {
                Object object = this.registry.convertValue(string4, string3);
                mBeanServer.setAttribute(objectName, new Attribute(string2, object));
            }
        }
        catch (Exception exception) {
            log.error((Object)("Error processing attribute " + string + " " + string2 + " " + string3), (Throwable)exception);
        }
    }

    private void processArg(Node node) {
        Node node2;
        Node node3 = node2 = DomUtil.getChild(node, "arg");
        while (node3 != null) {
            DomUtil.getAttribute(node3, "type");
            String string = DomUtil.getAttribute(node3, "value");
            if (string == null) {
                string = DomUtil.getContent(node3);
            }
            node3 = DomUtil.getNext(node3);
        }
    }
}

