/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.security;

public final class SecurityClassLoad {
    public static void securityClassLoad(ClassLoader classLoader) throws Exception {
        if (System.getSecurityManager() == null) {
            return;
        }
        SecurityClassLoad.loadCorePackage(classLoader);
        SecurityClassLoad.loadCoyotePackage(classLoader);
        SecurityClassLoad.loadLoaderPackage(classLoader);
        SecurityClassLoad.loadRealmPackage(classLoader);
        SecurityClassLoad.loadServletsPackage(classLoader);
        SecurityClassLoad.loadSessionPackage(classLoader);
        SecurityClassLoad.loadUtilPackage(classLoader);
        SecurityClassLoad.loadValvesPackage(classLoader);
        SecurityClassLoad.loadJavaxPackage(classLoader);
        SecurityClassLoad.loadConnectorPackage(classLoader);
        SecurityClassLoad.loadTomcatPackage(classLoader);
    }

    private static final void loadCorePackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.core.AccessLogAdapter");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.catalina.core.ApplicationContextFacade");
        classLoader.loadClass("org.apache.catalina.core.ApplicationDispatcher$PrivilegedForward");
        classLoader.loadClass("org.apache.catalina.core.ApplicationDispatcher$PrivilegedInclude");
        classLoader.loadClass("org.apache.catalina.core.AsyncContextImpl");
        classLoader.loadClass("org.apache.catalina.core.AsyncContextImpl$AsyncRunnable");
        classLoader.loadClass("org.apache.catalina.core.AsyncContextImpl$DebugException");
        classLoader.loadClass("org.apache.catalina.core.AsyncListenerWrapper");
        classLoader.loadClass("org.apache.catalina.core.ContainerBase$PrivilegedAddChild");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.catalina.core.DefaultInstanceManager");
        classLoader.loadClass("org.apache.catalina.core.DefaultInstanceManager$AnnotationCacheEntry");
        classLoader.loadClass("org.apache.catalina.core.DefaultInstanceManager$AnnotationCacheEntryType");
        classLoader.loadClass("org.apache.catalina.core.ApplicationHttpRequest$AttributeNamesEnumerator");
    }

    private static final void loadLoaderPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.loader.ResourceEntry");
        classLoader.loadClass("org.apache.catalina.loader.WebappClassLoaderBase$PrivilegedFindResourceByName");
    }

    private static final void loadRealmPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.realm.LockOutRealm$LockRecord");
    }

    private static final void loadServletsPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.servlets.DefaultServlet");
    }

    private static final void loadSessionPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.session.StandardSession");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.catalina.session.StandardSession");
        classLoader.loadClass("org.apache.catalina.session.StandardManager$PrivilegedDoUnload");
    }

    private static final void loadUtilPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.util.Enumerator");
        classLoader.loadClass("org.apache.catalina.util.ParameterMap");
        classLoader.loadClass("org.apache.catalina.util.RequestUtil");
    }

    private static final void loadValvesPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.valves.AccessLogValve$3");
    }

    private static final void loadCoyotePackage(ClassLoader classLoader) throws Exception {
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.coyote.http11.AbstractHttp11Processor");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.coyote.http11.Http11Processor");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.coyote.http11.Http11NioProcessor");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.coyote.http11.Http11AprProcessor");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.coyote.http11.AbstractOutputBuffer");
        classLoader.loadClass("org.apache.coyote.http11.Constants");
        Class<?> clazz = classLoader.loadClass("org.apache.coyote.Constants");
        clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private static final void loadJavaxPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("javax.servlet.http.Cookie");
    }

    private static final void loadConnectorPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.catalina.connector.CoyoteOutputStream");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetAttributePrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterMapPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetRequestDispatcherPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterNamesPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetParameterValuePrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetCharacterEncodingPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetHeadersPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetHeaderNamesPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetCookiesPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetLocalePrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetLocalesPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.ResponseFacade$SetContentTypePrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.ResponseFacade$DateHeaderPrivilegedAction");
        classLoader.loadClass("org.apache.catalina.connector.RequestFacade$GetSessionPrivilegedAction");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.catalina.connector.ResponseFacade");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.catalina.connector.OutputBuffer");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.catalina.connector.CoyoteInputStream");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.catalina.connector.InputBuffer");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.catalina.connector.Response");
    }

    private static final void loadTomcatPackage(ClassLoader classLoader) throws Exception {
        classLoader.loadClass("org.apache.tomcat.util.buf.B2CConverter");
        classLoader.loadClass("org.apache.tomcat.util.buf.C2BConverter");
        classLoader.loadClass("org.apache.tomcat.util.buf.HexUtils");
        classLoader.loadClass("org.apache.tomcat.util.buf.StringCache");
        classLoader.loadClass("org.apache.tomcat.util.buf.StringCache$ByteEntry");
        classLoader.loadClass("org.apache.tomcat.util.buf.StringCache$CharEntry");
        classLoader.loadClass("org.apache.tomcat.util.buf.UriUtil");
        classLoader.loadClass("org.apache.tomcat.util.http.HttpMessages");
        Class<?> clazz = classLoader.loadClass("org.apache.tomcat.util.http.FastHttpDateFormat");
        clazz.newInstance();
        classLoader.loadClass("org.apache.tomcat.util.http.HttpMessages");
        classLoader.loadClass("org.apache.tomcat.util.http.parser.HttpParser");
        classLoader.loadClass("org.apache.tomcat.util.http.parser.HttpParser$DomainParseState");
        classLoader.loadClass("org.apache.tomcat.util.http.parser.HttpParser$SkipResult");
        classLoader.loadClass("org.apache.tomcat.util.http.parser.MediaType");
        classLoader.loadClass("org.apache.tomcat.util.http.parser.MediaTypeCache");
        classLoader.loadClass("org.apache.tomcat.jni.Status");
        classLoader.loadClass("org.apache.tomcat.util.net.Constants");
        SecurityClassLoad.loadAnonymousInnerClasses(classLoader, "org.apache.tomcat.util.net.NioBlockingSelector$BlockPoller");
        classLoader.loadClass("org.apache.tomcat.util.net.SendfileState");
        classLoader.loadClass("org.apache.tomcat.util.net.SSLSupport$CipherData");
        classLoader.loadClass("org.apache.tomcat.util.security.PrivilegedGetTccl");
        classLoader.loadClass("org.apache.tomcat.util.security.PrivilegedSetTccl");
    }

    private static final void loadAnonymousInnerClasses(ClassLoader classLoader, String string) {
        try {
            int n = 1;
            while (true) {
                classLoader.loadClass(string + '$' + n);
                ++n;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
    }
}

