/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.transport.bio.util;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.transport.bio.util.LinkObject;
import org.apache.catalina.tribes.transport.bio.util.SingleRemoveSynchronizedAddLock;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class FastQueue {
    private static final Log log = LogFactory.getLog(FastQueue.class);
    private SingleRemoveSynchronizedAddLock lock = null;
    private LinkObject first = null;
    private LinkObject last = null;
    private AtomicInteger size = new AtomicInteger(0);
    private volatile boolean checkLock = false;
    private volatile boolean inAdd = false;
    private volatile boolean inRemove = false;
    private volatile boolean inMutex = false;
    private int maxQueueLength = 0;
    private long addWaitTimeout = 10000L;
    private long removeWaitTimeout = 30000L;
    private volatile boolean enabled = true;
    private int maxSize = 0;

    public FastQueue() {
        this.lock = new SingleRemoveSynchronizedAddLock();
        this.lock.setAddWaitTimeout(this.addWaitTimeout);
        this.lock.setRemoveWaitTimeout(this.removeWaitTimeout);
    }

    public long getAddWaitTimeout() {
        this.addWaitTimeout = this.lock.getAddWaitTimeout();
        return this.addWaitTimeout;
    }

    public void setAddWaitTimeout(long l) {
        this.addWaitTimeout = l;
        this.lock.setAddWaitTimeout(this.addWaitTimeout);
    }

    public long getRemoveWaitTimeout() {
        this.removeWaitTimeout = this.lock.getRemoveWaitTimeout();
        return this.removeWaitTimeout;
    }

    public void setRemoveWaitTimeout(long l) {
        this.removeWaitTimeout = l;
        this.lock.setRemoveWaitTimeout(this.removeWaitTimeout);
    }

    public int getMaxQueueLength() {
        return this.maxQueueLength;
    }

    public void setMaxQueueLength(int n) {
        this.maxQueueLength = n;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
        if (!bl) {
            this.lock.abortRemove();
            this.first = null;
            this.last = null;
        }
    }

    public boolean isCheckLock() {
        return this.checkLock;
    }

    public void setCheckLock(boolean bl) {
        this.checkLock = bl;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int n) {
        this.maxSize = n;
    }

    public void unlockAdd() {
        this.lock.unlockAdd(this.size.get() > 0);
    }

    public void unlockRemove() {
        this.lock.unlockRemove();
    }

    public void start() {
        this.setEnabled(true);
    }

    public void stop() {
        this.setEnabled(false);
    }

    public int getSize() {
        return this.size.get();
    }

    public SingleRemoveSynchronizedAddLock getLock() {
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(ChannelMessage channelMessage, Member[] memberArray, InterceptorPayload interceptorPayload) {
        boolean bl = true;
        if (!this.enabled) {
            if (log.isInfoEnabled()) {
                log.info((Object)"FastQueue.add: queue disabled, add aborted");
            }
            return false;
        }
        this.lock.lockAdd();
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.add: starting with size " + this.size.get()));
            }
            if (this.checkLock) {
                if (this.inAdd) {
                    log.warn((Object)"FastQueue.add: Detected other add");
                }
                this.inAdd = true;
                if (this.inMutex) {
                    log.warn((Object)"FastQueue.add: Detected other mutex in add");
                }
                this.inMutex = true;
            }
            if (this.maxQueueLength > 0 && this.size.get() >= this.maxQueueLength) {
                bl = false;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("FastQueue.add: Could not add, since queue is full (" + this.size.get() + ">=" + this.maxQueueLength + ")"));
                }
            } else {
                LinkObject linkObject = new LinkObject(channelMessage, memberArray, interceptorPayload);
                if (this.size.get() == 0) {
                    this.first = this.last = linkObject;
                    this.size.set(1);
                } else if (this.last == null) {
                    bl = false;
                    log.error((Object)("FastQueue.add: Could not add, since last is null although size is " + this.size.get() + " (>0)"));
                } else {
                    this.last.append(linkObject);
                    this.last = linkObject;
                    this.size.incrementAndGet();
                }
            }
            if (this.first == null) {
                log.error((Object)("FastQueue.add: first is null, size is " + this.size.get() + " at end of add"));
            }
            if (this.last == null) {
                log.error((Object)("FastQueue.add: last is null, size is " + this.size.get() + " at end of add"));
            }
            if (this.checkLock) {
                if (!this.inMutex) {
                    log.warn((Object)"FastQueue.add: Cancelled by other mutex in add");
                }
                this.inMutex = false;
                if (!this.inAdd) {
                    log.warn((Object)"FastQueue.add: Cancelled by other add");
                }
                this.inAdd = false;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.add: add ending with size " + this.size.get()));
            }
        }
        finally {
            this.lock.unlockAdd(true);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkObject remove() {
        LinkObject linkObject;
        if (!this.enabled) {
            if (log.isInfoEnabled()) {
                log.info((Object)"FastQueue.remove: queue disabled, remove aborted");
            }
            return null;
        }
        boolean bl = this.lock.lockRemove();
        try {
            if (!bl) {
                if (this.enabled) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)"FastQueue.remove: Remove aborted although queue enabled");
                    }
                } else if (log.isInfoEnabled()) {
                    log.info((Object)"FastQueue.remove: queue disabled, remove aborted");
                }
                LinkObject linkObject2 = null;
                return linkObject2;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.remove: remove starting with size " + this.size.get()));
            }
            if (this.checkLock) {
                if (this.inRemove) {
                    log.warn((Object)"FastQueue.remove: Detected other remove");
                }
                this.inRemove = true;
                if (this.inMutex) {
                    log.warn((Object)"FastQueue.remove: Detected other mutex in remove");
                }
                this.inMutex = true;
            }
            linkObject = this.first;
            this.last = null;
            this.first = null;
            this.size.set(0);
            if (this.checkLock) {
                if (!this.inMutex) {
                    log.warn((Object)"FastQueue.remove: Cancelled by other mutex in remove");
                }
                this.inMutex = false;
                if (!this.inRemove) {
                    log.warn((Object)"FastQueue.remove: Cancelled by other remove");
                }
                this.inRemove = false;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("FastQueue.remove: remove ending with size " + this.size.get()));
            }
        }
        finally {
            this.lock.unlockRemove();
        }
        return linkObject;
    }
}

