/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import org.apache.tomcat.dbcp.dbcp.AbandonedConfig;
import org.apache.tomcat.dbcp.dbcp.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp.DelegatingPreparedStatement;
import org.apache.tomcat.dbcp.dbcp.PStmtKey;
import org.apache.tomcat.dbcp.dbcp.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp.PoolingConnection;
import org.apache.tomcat.dbcp.pool.KeyedObjectPool;
import org.apache.tomcat.dbcp.pool.KeyedObjectPoolFactory;
import org.apache.tomcat.dbcp.pool.ObjectPool;
import org.apache.tomcat.dbcp.pool.PoolableObjectFactory;

public class PoolableConnectionFactory
implements PoolableObjectFactory<PoolableConnection> {
    protected volatile ConnectionFactory _connFactory = null;
    protected volatile String _validationQuery = null;
    protected volatile int _validationQueryTimeout = -1;
    protected Collection<String> _connectionInitSqls = null;
    protected volatile ObjectPool<PoolableConnection> _pool = null;
    protected volatile KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> _stmtPoolFactory = null;
    protected Boolean _defaultReadOnly = null;
    protected boolean _defaultAutoCommit = true;
    protected int _defaultTransactionIsolation = -1;
    protected String _defaultCatalog;
    protected AbandonedConfig _config = null;
    static final int UNKNOWN_TRANSACTIONISOLATION = -1;

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, boolean bl, boolean bl2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, Collection<String> collection, boolean bl, boolean bl2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, int n, boolean bl, boolean bl2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, int n, Collection<String> collection, boolean bl, boolean bl2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, boolean bl, boolean bl2, int n) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, Collection<String> collection, boolean bl, boolean bl2, int n) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, int n, boolean bl, boolean bl2, int n2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, int n, Collection<String> collection, boolean bl, boolean bl2, int n2) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, boolean bl, boolean bl2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, boolean bl, boolean bl2, int n, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, boolean bl, boolean bl2, int n, String string2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
        this._defaultCatalog = string2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, Boolean bl, boolean bl2, int n, String string2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._defaultReadOnly = bl;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
        this._defaultCatalog = string2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, Collection<String> collection, Boolean bl, boolean bl2, int n, String string2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n;
        this._defaultCatalog = string2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, int n, Boolean bl, boolean bl2, int n2, String string2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._defaultReadOnly = bl;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n2;
        this._defaultCatalog = string2;
    }

    public PoolableConnectionFactory(ConnectionFactory connectionFactory, ObjectPool<PoolableConnection> objectPool, KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory, String string, int n, Collection<String> collection, Boolean bl, boolean bl2, int n2, String string2, AbandonedConfig abandonedConfig) {
        this._connFactory = connectionFactory;
        this._pool = objectPool;
        this._config = abandonedConfig;
        this._pool.setFactory(this);
        this._stmtPoolFactory = keyedObjectPoolFactory;
        this._validationQuery = string;
        this._validationQueryTimeout = n;
        this._connectionInitSqls = collection;
        this._defaultReadOnly = bl;
        this._defaultAutoCommit = bl2;
        this._defaultTransactionIsolation = n2;
        this._defaultCatalog = string2;
    }

    public void setConnectionFactory(ConnectionFactory connectionFactory) {
        this._connFactory = connectionFactory;
    }

    public void setValidationQuery(String string) {
        this._validationQuery = string;
    }

    public void setValidationQueryTimeout(int n) {
        this._validationQueryTimeout = n;
    }

    public synchronized void setConnectionInitSql(Collection<String> collection) {
        this._connectionInitSqls = collection;
    }

    public synchronized void setPool(ObjectPool<PoolableConnection> objectPool) {
        if (null != this._pool && objectPool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._pool = objectPool;
    }

    public synchronized ObjectPool<PoolableConnection> getPool() {
        return this._pool;
    }

    public void setStatementPoolFactory(KeyedObjectPoolFactory<PStmtKey, DelegatingPreparedStatement> keyedObjectPoolFactory) {
        this._stmtPoolFactory = keyedObjectPoolFactory;
    }

    public void setDefaultReadOnly(boolean bl) {
        this._defaultReadOnly = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setDefaultAutoCommit(boolean bl) {
        this._defaultAutoCommit = bl;
    }

    public void setDefaultTransactionIsolation(int n) {
        this._defaultTransactionIsolation = n;
    }

    public void setDefaultCatalog(String string) {
        this._defaultCatalog = string;
    }

    @Override
    public PoolableConnection makeObject() throws Exception {
        Connection connection = this._connFactory.createConnection();
        if (connection == null) {
            throw new IllegalStateException("Connection factory returned null from createConnection");
        }
        this.initializeConnection(connection);
        if (null != this._stmtPoolFactory) {
            KeyedObjectPool<PStmtKey, DelegatingPreparedStatement> keyedObjectPool = this._stmtPoolFactory.createPool();
            connection = new PoolingConnection(connection, keyedObjectPool);
            keyedObjectPool.setFactory((PoolingConnection)connection);
        }
        return new PoolableConnection(connection, this._pool, this._config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeConnection(Connection connection) throws SQLException {
        Collection<String> collection = this._connectionInitSqls;
        if (connection.isClosed()) {
            throw new SQLException("initializeConnection: connection closed");
        }
        if (null != collection) {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                for (String string : collection) {
                    if (string == null) {
                        throw new NullPointerException("null connectionInitSqls element");
                    }
                    statement.execute(string);
                }
            }
            finally {
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Override
    public void destroyObject(PoolableConnection poolableConnection) throws Exception {
        if (poolableConnection != null) {
            poolableConnection.reallyClose();
        }
    }

    @Override
    public boolean validateObject(PoolableConnection poolableConnection) {
        try {
            this.validateConnection(poolableConnection);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnection(Connection connection) throws SQLException {
        String string = this._validationQuery;
        if (connection.isClosed()) {
            throw new SQLException("validateConnection: connection closed");
        }
        if (null != string) {
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = connection.createStatement();
                if (this._validationQueryTimeout > 0) {
                    statement.setQueryTimeout(this._validationQueryTimeout);
                }
                if (!(resultSet = statement.executeQuery(string)).next()) {
                    throw new SQLException("validationQuery didn't return a row");
                }
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (Exception exception) {}
                }
                if (statement != null) {
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Override
    public void passivateObject(PoolableConnection poolableConnection) throws Exception {
        if (!poolableConnection.getAutoCommit() && !poolableConnection.isReadOnly()) {
            poolableConnection.rollback();
        }
        poolableConnection.clearWarnings();
        if (!poolableConnection.getAutoCommit()) {
            poolableConnection.setAutoCommit(true);
        }
        poolableConnection.passivate();
    }

    @Override
    public void activateObject(PoolableConnection poolableConnection) throws Exception {
        poolableConnection.activate();
        if (poolableConnection.getAutoCommit() != this._defaultAutoCommit) {
            poolableConnection.setAutoCommit(this._defaultAutoCommit);
        }
        if (this._defaultTransactionIsolation != -1 && poolableConnection.getTransactionIsolation() != this._defaultTransactionIsolation) {
            poolableConnection.setTransactionIsolation(this._defaultTransactionIsolation);
        }
        if (this._defaultReadOnly != null && poolableConnection.isReadOnly() != this._defaultReadOnly.booleanValue()) {
            poolableConnection.setReadOnly(this._defaultReadOnly);
        }
        if (this._defaultCatalog != null && !this._defaultCatalog.equals(poolableConnection.getCatalog())) {
            poolableConnection.setCatalog(this._defaultCatalog);
        }
    }
}

