/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.buf;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.CharsetCache;
import org.apache.tomcat.util.buf.Utf8Decoder;
import org.apache.tomcat.util.res.StringManager;

public class B2CConverter {
    private static final StringManager sm = StringManager.getManager("org.apache.tomcat.util.buf");
    private static final CharsetCache charsetCache = new CharsetCache();
    protected static final int LEFTOVER_SIZE = 9;
    private final CharsetDecoder decoder;
    private ByteBuffer bb = null;
    private CharBuffer cb = null;
    private final ByteBuffer leftovers;

    public static Charset getCharset(String string) throws UnsupportedEncodingException {
        String string2 = string.toLowerCase(Locale.ENGLISH);
        return B2CConverter.getCharsetLower(string2);
    }

    @Deprecated
    public static Charset getCharsetLower(String string) throws UnsupportedEncodingException {
        Charset charset = charsetCache.getCharset(string);
        if (charset == null) {
            throw new UnsupportedEncodingException(sm.getString("b2cConverter.unknownEncoding", string));
        }
        return charset;
    }

    public B2CConverter(Charset charset) {
        this(charset, false);
    }

    public B2CConverter(Charset charset, boolean bl) {
        byte[] byArray = new byte[9];
        this.leftovers = ByteBuffer.wrap(byArray);
        CodingErrorAction codingErrorAction = bl ? CodingErrorAction.REPLACE : CodingErrorAction.REPORT;
        this.decoder = charset.equals(StandardCharsets.UTF_8) ? new Utf8Decoder() : charset.newDecoder();
        this.decoder.onMalformedInput(codingErrorAction);
        this.decoder.onUnmappableCharacter(codingErrorAction);
    }

    public void recycle() {
        this.decoder.reset();
        this.leftovers.position(0);
    }

    public void convert(ByteChunk byteChunk, CharChunk charChunk, boolean bl) throws IOException {
        if (this.bb == null || this.bb.array() != byteChunk.getBuffer()) {
            this.bb = ByteBuffer.wrap(byteChunk.getBuffer(), byteChunk.getStart(), byteChunk.getLength());
        } else {
            this.bb.limit(byteChunk.getEnd());
            this.bb.position(byteChunk.getStart());
        }
        if (this.cb == null || this.cb.array() != charChunk.getBuffer()) {
            this.cb = CharBuffer.wrap(charChunk.getBuffer(), charChunk.getEnd(), charChunk.getBuffer().length - charChunk.getEnd());
        } else {
            this.cb.limit(charChunk.getBuffer().length);
            this.cb.position(charChunk.getEnd());
        }
        CoderResult coderResult = null;
        if (this.leftovers.position() > 0) {
            int n = this.cb.position();
            do {
                this.leftovers.put(byteChunk.substractB());
                this.leftovers.flip();
                coderResult = this.decoder.decode(this.leftovers, this.cb, bl);
                this.leftovers.position(this.leftovers.limit());
                this.leftovers.limit(this.leftovers.array().length);
            } while (coderResult.isUnderflow() && this.cb.position() == n);
            if (coderResult.isError() || coderResult.isMalformed()) {
                coderResult.throwException();
            }
            this.bb.position(byteChunk.getStart());
            this.leftovers.position(0);
        }
        if ((coderResult = this.decoder.decode(this.bb, this.cb, bl)).isError() || coderResult.isMalformed()) {
            coderResult.throwException();
        } else if (coderResult.isOverflow()) {
            byteChunk.setOffset(this.bb.position());
            charChunk.setEnd(this.cb.position());
        } else if (coderResult.isUnderflow()) {
            byteChunk.setOffset(this.bb.position());
            charChunk.setEnd(this.cb.position());
            if (byteChunk.getLength() > 0) {
                this.leftovers.limit(this.leftovers.array().length);
                this.leftovers.position(byteChunk.getLength());
                byteChunk.substract(this.leftovers.array(), 0, byteChunk.getLength());
            }
        }
    }

    public void convert(ByteBuffer byteBuffer, CharBuffer charBuffer, ByteChunk.ByteInputChannel byteInputChannel, boolean bl) throws IOException {
        if (this.bb == null || this.bb.array() != byteBuffer.array()) {
            this.bb = ByteBuffer.wrap(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        } else {
            this.bb.limit(byteBuffer.limit());
            this.bb.position(byteBuffer.position());
        }
        if (this.cb == null || this.cb.array() != charBuffer.array()) {
            this.cb = CharBuffer.wrap(charBuffer.array(), charBuffer.limit(), charBuffer.capacity() - charBuffer.limit());
        } else {
            this.cb.limit(charBuffer.capacity());
            this.cb.position(charBuffer.limit());
        }
        CoderResult coderResult = null;
        if (this.leftovers.position() > 0) {
            int n = this.cb.position();
            do {
                int n2;
                int n3 = byteBuffer.remaining() == 0 ? ((n2 = byteInputChannel.realReadBytes()) < 0 ? -1 : (int)byteBuffer.get()) : byteBuffer.get();
                this.leftovers.put((byte)n3);
                this.leftovers.flip();
                coderResult = this.decoder.decode(this.leftovers, this.cb, bl);
                this.leftovers.position(this.leftovers.limit());
                this.leftovers.limit(this.leftovers.array().length);
            } while (coderResult.isUnderflow() && this.cb.position() == n);
            if (coderResult.isError() || coderResult.isMalformed()) {
                coderResult.throwException();
            }
            this.bb.position(byteBuffer.position());
            this.leftovers.position(0);
        }
        if ((coderResult = this.decoder.decode(this.bb, this.cb, bl)).isError() || coderResult.isMalformed()) {
            coderResult.throwException();
        } else if (coderResult.isOverflow()) {
            byteBuffer.position(this.bb.position());
            charBuffer.limit(this.cb.position());
        } else if (coderResult.isUnderflow()) {
            byteBuffer.position(this.bb.position());
            charBuffer.limit(this.cb.position());
            if (byteBuffer.remaining() > 0) {
                this.leftovers.limit(this.leftovers.array().length);
                this.leftovers.position(byteBuffer.remaining());
                byteBuffer.get(this.leftovers.array(), 0, byteBuffer.remaining());
            }
        }
    }

    public Charset getCharset() {
        return this.decoder.charset();
    }
}

