/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.authenticator.jaspic;

import java.io.IOException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.callback.CallerPrincipalCallback;
import javax.security.auth.message.callback.GroupPrincipalCallback;
import javax.security.auth.message.callback.PasswordValidationCallback;
import org.apache.catalina.Contained;
import org.apache.catalina.Container;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.res.StringManager;

public class CallbackHandlerImpl
implements CallbackHandler,
Contained {
    private static final StringManager sm = StringManager.getManager(CallbackHandlerImpl.class);
    private final Log log = LogFactory.getLog(CallbackHandlerImpl.class);
    private Container container;

    @Override
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        String string = null;
        Principal principal = null;
        Subject subject = null;
        String[] stringArray = null;
        if (callbackArray != null) {
            for (Callback callback : callbackArray) {
                CallerPrincipalCallback callerPrincipalCallback;
                if (callback instanceof CallerPrincipalCallback) {
                    callerPrincipalCallback = (CallerPrincipalCallback)callback;
                    string = callerPrincipalCallback.getName();
                    principal = callerPrincipalCallback.getPrincipal();
                    subject = callerPrincipalCallback.getSubject();
                    continue;
                }
                if (callback instanceof GroupPrincipalCallback) {
                    callerPrincipalCallback = (GroupPrincipalCallback)callback;
                    stringArray = callerPrincipalCallback.getGroups();
                    continue;
                }
                if (callback instanceof PasswordValidationCallback) {
                    if (this.container == null) {
                        this.log.warn((Object)sm.getString("callbackHandlerImpl.containerMissing", new Object[]{callback.getClass().getName()}));
                        continue;
                    }
                    if (this.container.getRealm() == null) {
                        this.log.warn((Object)sm.getString("callbackHandlerImpl.realmMissing", new Object[]{callback.getClass().getName(), this.container.getName()}));
                        continue;
                    }
                    callerPrincipalCallback = (PasswordValidationCallback)callback;
                    principal = this.container.getRealm().authenticate(callerPrincipalCallback.getUsername(), String.valueOf(callerPrincipalCallback.getPassword()));
                    subject = callerPrincipalCallback.getSubject();
                    continue;
                }
                this.log.error((Object)sm.getString("callbackHandlerImpl.jaspicCallbackMissing", new Object[]{callback.getClass().getName()}));
            }
            Principal principal2 = this.getPrincipal(principal, string, stringArray);
            if (subject != null && principal2 != null) {
                subject.getPrivateCredentials().add(principal2);
            }
        }
    }

    private Principal getPrincipal(Principal principal, String string, String[] stringArray) {
        if (principal instanceof GenericPrincipal) {
            return principal;
        }
        if (string == null && principal != null) {
            string = principal.getName();
        }
        if (string == null) {
            return null;
        }
        List<Object> list = stringArray == null || stringArray.length == 0 ? Collections.emptyList() : Arrays.asList(stringArray);
        return new GenericPrincipal(string, null, list, principal);
    }

    @Override
    public Container getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(Container container) {
        this.container = container;
    }
}

