/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.quicksearch.web;

import java.awt.Toolkit;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.quicksearch.web.Item;
import org.netbeans.modules.quicksearch.web.Query;
import org.netbeans.modules.quicksearch.web.Result;
import org.netbeans.spi.quicksearch.SearchProvider;
import org.netbeans.spi.quicksearch.SearchRequest;
import org.netbeans.spi.quicksearch.SearchResponse;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;

public class WebQuickSearchProviderImpl
implements SearchProvider {
    private Query query;

    @Override
    public void evaluate(SearchRequest searchRequest, SearchResponse searchResponse) {
        if (null == this.query) {
            this.query = Query.getDefault();
        }
        Result result = this.query.search(searchRequest.getText());
        do {
            for (Item item : result.getItems()) {
                if (searchResponse.addResult(WebQuickSearchProviderImpl.createAction(item.getUrl()), item.getTitle())) continue;
                return;
            }
        } while (!(result = this.query.searchMore(searchRequest.getText())).isSearchFinished());
    }

    private static Runnable createAction(final String string) {
        return new Runnable(){

            @Override
            public void run() {
                String string2 = WebQuickSearchProviderImpl.appendId(string);
                try {
                    HtmlBrowser.URLDisplayer uRLDisplayer = HtmlBrowser.URLDisplayer.getDefault();
                    if (uRLDisplayer != null) {
                        uRLDisplayer.showURL(new URL(string2));
                    }
                }
                catch (Exception exception) {
                    StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(WebQuickSearchProviderImpl.class, (String)"Err_CannotDisplayURL", (Object)string2));
                    Toolkit.getDefaultToolkit().beep();
                    Logger.getLogger(WebQuickSearchProviderImpl.class.getName()).log(Level.FINE, null, exception);
                }
            }
        };
    }

    private static String appendId(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        if (string.contains("?")) {
            stringBuffer.append('&');
        } else {
            stringBuffer.append('?');
        }
        stringBuffer.append("cid=925878");
        return stringBuffer.toString();
    }
}

