/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.charts.xy;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.List;
import java.util.Locale;
import org.netbeans.lib.profiler.charts.ChartContext;
import org.netbeans.lib.profiler.charts.ChartItem;
import org.netbeans.lib.profiler.charts.ItemSelection;
import org.netbeans.lib.profiler.charts.swing.LongRect;
import org.netbeans.lib.profiler.charts.swing.Utils;
import org.netbeans.lib.profiler.charts.xy.XYItem;
import org.netbeans.lib.profiler.charts.xy.XYItemSelection;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYChartContext;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItem;
import org.netbeans.lib.profiler.charts.xy.synchronous.SynchronousXYItemPainter;

public class XYPainter
extends SynchronousXYItemPainter {
    private final int mode;
    private final Color fillColor2;
    private boolean painting;

    public static XYPainter absolutePainter(float lineWidth, Color lineColor, Color fillColor1, Color fillColor2) {
        return new XYPainter(lineWidth, lineColor, fillColor1, fillColor2, 0, 0);
    }

    public static XYPainter relativePainter(float lineWidth, Color lineColor, Color fillColor1, Color fillColor2, int maxOffset) {
        return new XYPainter(lineWidth, lineColor, fillColor1, fillColor2, 1, maxOffset);
    }

    public XYPainter(float lineWidth, Color lineColor, Color fillColor1, Color fillColor2, int type, int maxValueOffset) {
        super(lineWidth, lineColor, fillColor1, type, maxValueOffset);
        String _mode = System.getProperty("visualvm.charts.defaultMode", "minmax").toLowerCase(Locale.ENGLISH);
        this.mode = "fast".equals(_mode) ? 0 : 1;
        this.fillColor2 = Utils.checkedColor((Color)fillColor2);
        this.painting = true;
    }

    public void setPainting(boolean painting) {
        this.painting = painting;
    }

    public boolean isPainting() {
        return this.painting;
    }

    public LongRect getSelectionBounds(ItemSelection selection, ChartContext context) {
        XYItemSelection sel = (XYItemSelection)selection;
        XYItem item = sel.getItem();
        int selectedValueIndex = sel.getValueIndex();
        if (selectedValueIndex == -1 || selectedValueIndex >= item.getValuesCount()) {
            return new LongRect(0L, 0L, (long)context.getViewportWidth(), (long)context.getViewportHeight());
        }
        return this.getViewBounds(item, new int[]{sel.getValueIndex()}, context);
    }

    public XYItemSelection getClosestSelection(ChartItem item, int viewX, int viewY, ChartContext context) {
        if (this.mode == 1) {
            return this.getMinMaxClosestSelection(item, viewX, viewY, context);
        }
        if (this.mode == 0) {
            return this.getFastClosestSelection(item, viewX, viewY, context);
        }
        return null;
    }

    private int[][] getPoints(XYItem item, Rectangle dirtyArea, SynchronousXYChartContext context, int type, int maxValueOffset) {
        if (this.mode == 1) {
            return this.getMinMaxPoints(item, dirtyArea, context, type, maxValueOffset);
        }
        if (this.mode == 0) {
            return this.getFastPoints(item, dirtyArea, context, type, maxValueOffset);
        }
        return null;
    }

    protected void paint(XYItem item, List<ItemSelection> highlighted, List<ItemSelection> selected, Graphics2D g, Rectangle dirtyArea, SynchronousXYChartContext context) {
        if (!this.isPainting()) {
            return;
        }
        if (item.getValuesCount() < 2) {
            return;
        }
        if (context.getViewWidth() == 0L || context.getViewHeight() == 0L) {
            return;
        }
        int[][] points = this.getPoints(item, dirtyArea, context, this.type, this.maxValueOffset);
        if (points == null) {
            return;
        }
        int[] xPoints = points[0];
        int[] yPoints = points[1];
        int npoints = points[2][0];
        if (this.fillColor != null) {
            int zeroY = Utils.checkedInt((double)context.getViewY((double)context.getDataOffsetY()));
            zeroY = Math.max(Utils.checkedInt((double)context.getViewportOffsetY()), zeroY);
            zeroY = Math.min(Utils.checkedInt((double)(context.getViewportOffsetY() + (long)context.getViewportHeight())), zeroY);
            Polygon polygon = new Polygon();
            polygon.xpoints = xPoints;
            polygon.ypoints = yPoints;
            polygon.npoints = npoints + 2;
            polygon.xpoints[npoints] = xPoints[npoints - 1];
            polygon.ypoints[npoints] = zeroY;
            polygon.xpoints[npoints + 1] = xPoints[0];
            polygon.ypoints[npoints + 1] = zeroY;
            if (this.fillColor2 == null || Utils.forceSpeed()) {
                g.setPaint(this.fillColor);
            } else {
                g.setPaint(new GradientPaint(0.0f, context.getViewportOffsetY(), this.fillColor, 0.0f, context.getViewportOffsetY() + (long)context.getViewportHeight(), this.fillColor2));
            }
            g.fill(polygon);
        }
        if (this.lineColor != null) {
            g.setPaint(this.lineColor);
            g.setStroke(this.lineStroke);
            g.drawPolyline(xPoints, yPoints, npoints);
        }
    }

    private XYItemSelection getFastClosestSelection(ChartItem item, int viewX, int viewY, ChartContext context) {
        SynchronousXYChartContext contx = (SynchronousXYChartContext)context;
        int nearestTimestampIndex = contx.getNearestTimestampIndex(viewX, viewY);
        if (nearestTimestampIndex == -1) {
            return null;
        }
        SynchronousXYItem xyItem = (SynchronousXYItem)item;
        return new XYItemSelection.Default((XYItem)xyItem, nearestTimestampIndex, Integer.MAX_VALUE);
    }

    private XYItemSelection getMinMaxClosestSelection(ChartItem item, int viewX, int viewY, ChartContext context) {
        int lastVisible;
        SynchronousXYItem xyItem = (SynchronousXYItem)item;
        if (xyItem.getValuesCount() == 0) {
            return null;
        }
        SynchronousXYChartContext contx = (SynchronousXYChartContext)context;
        Rectangle bounds = new Rectangle(0, 0, contx.getViewportWidth(), contx.getViewportHeight());
        if (bounds.isEmpty()) {
            return null;
        }
        int[][] visibleBounds = contx.getVisibleBounds(bounds);
        if (visibleBounds[0][0] == -1 && visibleBounds[0][1] == -1) {
            return null;
        }
        if (visibleBounds[1][0] == -1 && visibleBounds[1][1] == -1) {
            return null;
        }
        int firstVisible = visibleBounds[0][0];
        if (firstVisible == -1) {
            firstVisible = visibleBounds[0][1];
        }
        if ((lastVisible = visibleBounds[1][0]) == -1) {
            lastVisible = visibleBounds[1][1];
        }
        int idx = firstVisible;
        int x = XYPainter.getViewX(contx, (XYItem)xyItem, idx);
        int dist = Math.abs(viewX - x);
        while (++idx <= lastVisible) {
            int newX = XYPainter.getViewX(contx, (XYItem)xyItem, idx);
            int newDist = Math.abs(viewX - newX);
            if (newDist > dist) {
                --idx;
                break;
            }
            x = newX;
            dist = newDist;
        }
        if (idx > lastVisible) {
            idx = lastVisible;
        }
        long maxVal = xyItem.getYValue(idx);
        int maxIdx = idx;
        while (--idx >= firstVisible && XYPainter.getViewX(contx, (XYItem)xyItem, idx) == x) {
            long y = xyItem.getYValue(idx);
            if (y <= maxVal) continue;
            maxVal = y;
            maxIdx = idx;
        }
        return new XYItemSelection.Default((XYItem)xyItem, maxIdx, dist);
    }

    private int[][] getFastPoints(XYItem item, Rectangle dirtyArea, SynchronousXYChartContext context, int type, int maxValueOffset) {
        int itemsStep;
        int lastFirst;
        int lastIndex;
        int valuesCount = item.getValuesCount();
        int[][] visibleBounds = context.getVisibleBounds(dirtyArea);
        int firstFirst = visibleBounds[0][0];
        int firstIndex = firstFirst;
        if (firstIndex == -1) {
            firstIndex = visibleBounds[0][1];
        }
        if (firstIndex == -1) {
            return null;
        }
        if (firstFirst != -1 && firstIndex > 0) {
            --firstIndex;
        }
        if ((lastIndex = (lastFirst = visibleBounds[1][0])) == -1) {
            lastIndex = visibleBounds[1][1];
        }
        if (lastIndex == -1) {
            lastIndex = valuesCount - 1;
        }
        if (lastFirst != -1 && lastIndex < valuesCount - 1) {
            ++lastIndex;
        }
        if ((itemsStep = (int)((long)valuesCount / context.getViewWidth())) == 0) {
            itemsStep = 1;
        }
        int visibleCount = lastIndex - firstIndex + 1;
        if (itemsStep > 1) {
            int firstMod = firstIndex % itemsStep;
            int lastMod = lastIndex % itemsStep;
            lastIndex = lastIndex - lastMod + itemsStep;
            visibleCount = (lastIndex - (firstIndex -= firstMod)) / itemsStep + 1;
            lastIndex = Math.min(lastIndex, valuesCount - 1);
        }
        int[] xPoints = new int[visibleCount + 2];
        int[] yPoints = new int[visibleCount + 2];
        double itemValueFactor = type == 1 ? XYPainter.getItemValueFactor((ChartContext)context, maxValueOffset, item.getBounds().height) : 0.0;
        for (int i = 0; i < visibleCount; ++i) {
            int dataIndex = i == visibleCount - 1 ? lastIndex : firstIndex + i * itemsStep;
            xPoints[i] = Utils.checkedInt((double)Math.ceil(context.getViewX((double)item.getXValue(dataIndex))));
            yPoints[i] = Utils.checkedInt((double)Math.ceil(XYPainter.getYValue(item, dataIndex, type, (ChartContext)context, itemValueFactor)));
        }
        return new int[][]{xPoints, yPoints, {xPoints.length - 2}};
    }

    private int[][] getMinMaxPoints(XYItem item, Rectangle dirtyArea, SynchronousXYChartContext context, int type, int maxValueOffset) {
        if (dirtyArea.isEmpty()) {
            return null;
        }
        dirtyArea.grow(this.lineWidth, 0);
        int[][] visibleBounds = context.getVisibleBounds(dirtyArea);
        if (visibleBounds[0][0] == -1 && visibleBounds[0][1] == -1) {
            return null;
        }
        if (visibleBounds[1][0] == -1 && visibleBounds[1][1] == -1) {
            return null;
        }
        int valuesCount = item.getValuesCount();
        int firstIndex = visibleBounds[0][0];
        if (firstIndex == -1) {
            firstIndex = visibleBounds[0][1];
        } else if (firstIndex > 0) {
            --firstIndex;
        }
        int lastIndex = visibleBounds[1][0];
        if (lastIndex == -1) {
            lastIndex = visibleBounds[1][1];
        } else if (lastIndex < valuesCount - 1) {
            ++lastIndex;
        }
        double itemValueFactor = type == 1 ? XYPainter.getItemValueFactor((ChartContext)context, maxValueOffset, item.getBounds().height) : 0.0;
        int maxPoints = Math.min(dirtyArea.width * 4 + 2, lastIndex - firstIndex + 1);
        int[] xPoints = new int[maxPoints + 2];
        int[] yPoints = new int[maxPoints + 2];
        int nPoints = 0;
        block7: for (int index = firstIndex; index <= lastIndex; ++index) {
            int x = XYPainter.getViewX(context, item, index);
            int y = Utils.checkedInt((double)Math.ceil(XYPainter.getYValue(item, index, type, (ChartContext)context, itemValueFactor)));
            int nValues = 0;
            if (nPoints > 0) {
                if (xPoints[nPoints - 1] == x) {
                    nValues = 1;
                }
                if (nPoints > 1) {
                    if (xPoints[nPoints - 2] == x) {
                        nValues = 2;
                    }
                    if (nPoints > 2) {
                        if (xPoints[nPoints - 3] == x) {
                            nValues = 3;
                        }
                        if (nPoints > 3 && xPoints[nPoints - 4] == x) {
                            nValues = 4;
                        }
                    }
                }
            }
            switch (nValues) {
                case 0: {
                    if (nPoints < 2 || yPoints[nPoints - 1] != y || yPoints[nPoints - 2] != y) {
                        xPoints[nPoints] = x;
                        yPoints[nPoints] = y;
                        ++nPoints;
                        continue block7;
                    }
                    xPoints[nPoints - 1] = x;
                    continue block7;
                }
                case 1: {
                    if (yPoints[nPoints - 1] == y) continue block7;
                    xPoints[nPoints] = x;
                    yPoints[nPoints] = y;
                    ++nPoints;
                    continue block7;
                }
                case 2: {
                    int y_1_2 = yPoints[nPoints - 1];
                    if (y_1_2 == y) continue block7;
                    if (yPoints[nPoints - 2] < y_1_2 && y_1_2 < y) {
                        yPoints[nPoints - 1] = y;
                        continue block7;
                    }
                    if (yPoints[nPoints - 2] > y_1_2 && y_1_2 > y) {
                        yPoints[nPoints - 1] = y;
                        continue block7;
                    }
                    xPoints[nPoints] = x;
                    yPoints[nPoints] = y;
                    ++nPoints;
                    continue block7;
                }
                case 3: {
                    int y_1_3 = yPoints[nPoints - 1];
                    if (y_1_3 == y) continue block7;
                    int y_2_3 = yPoints[nPoints - 2];
                    int y_3_3 = yPoints[nPoints - 3];
                    int min = y;
                    int max = y;
                    if (y_1_3 < min) {
                        min = y_1_3;
                    } else if (y_1_3 > max) {
                        max = y_1_3;
                    }
                    if (y_2_3 < min) {
                        min = y_2_3;
                    } else if (y_2_3 > max) {
                        max = y_2_3;
                    }
                    if (y_3_3 < min) {
                        min = y_3_3;
                    } else if (y_3_3 > max) {
                        max = y_3_3;
                    }
                    if (y == min) {
                        if (y_3_3 == max) {
                            yPoints[nPoints - 2] = y;
                            --nPoints;
                            continue block7;
                        }
                        yPoints[nPoints - 2] = max;
                        yPoints[nPoints - 1] = y;
                        continue block7;
                    }
                    if (y == max) {
                        if (y_3_3 == min) {
                            yPoints[nPoints - 2] = y;
                            --nPoints;
                            continue block7;
                        }
                        yPoints[nPoints - 2] = min;
                        yPoints[nPoints - 1] = y;
                        continue block7;
                    }
                    if (y_3_3 == min) {
                        yPoints[nPoints - 2] = max;
                        yPoints[nPoints - 1] = y;
                        continue block7;
                    }
                    if (y_3_3 == max) {
                        yPoints[nPoints - 2] = min;
                        yPoints[nPoints - 1] = y;
                        continue block7;
                    }
                    xPoints[nPoints] = x;
                    yPoints[nPoints] = y;
                    ++nPoints;
                    continue block7;
                }
                case 4: {
                    int y_1_4 = yPoints[nPoints - 1];
                    if (y_1_4 == y) continue block7;
                    int y_2_4 = yPoints[nPoints - 2];
                    int y_3_4 = yPoints[nPoints - 3];
                    int y_4_4 = yPoints[nPoints - 4];
                    int min = y;
                    int max = y;
                    if (y_1_4 < min) {
                        min = y_1_4;
                    } else if (y_1_4 > max) {
                        max = y_1_4;
                    }
                    if (y_2_4 < min) {
                        min = y_2_4;
                    } else if (y_2_4 > max) {
                        max = y_2_4;
                    }
                    if (y_3_4 < min) {
                        min = y_3_4;
                    } else if (y_3_4 > max) {
                        max = y_3_4;
                    }
                    if (y_4_4 < min) {
                        min = y_4_4;
                    } else if (y_4_4 > max) {
                        max = y_4_4;
                    }
                    if (y == min) {
                        yPoints[nPoints - 3] = max;
                        yPoints[nPoints - 2] = y;
                        --nPoints;
                        continue block7;
                    }
                    if (y == max) {
                        yPoints[nPoints - 3] = min;
                        yPoints[nPoints - 2] = y;
                        --nPoints;
                        continue block7;
                    }
                    yPoints[nPoints - 1] = y;
                }
            }
        }
        return new int[][]{xPoints, yPoints, {nPoints}};
    }

    private static int getViewX(SynchronousXYChartContext context, XYItem item, int index) {
        return Utils.checkedInt((double)Math.ceil(context.getViewX((double)item.getXValue(index))));
    }

    private LongRect getViewBoundsRelative(LongRect dataBounds, XYItem item, ChartContext context) {
        long viewHeight;
        LongRect itemBounds = item.getBounds();
        double itemValueFactor = XYPainter.getItemValueFactor(context, this.maxValueOffset, itemBounds.height);
        double value1 = (double)context.getDataOffsetY() + itemValueFactor * (double)(dataBounds.y - itemBounds.y);
        double value2 = (double)context.getDataOffsetY() + itemValueFactor * (double)(dataBounds.y + dataBounds.height - itemBounds.y);
        long viewX = (long)Math.ceil(context.getViewX((double)dataBounds.x));
        long viewWidth = (long)Math.ceil(context.getViewWidth((double)dataBounds.width));
        if (context.isRightBased()) {
            viewX -= viewWidth;
        }
        long viewY1 = (long)Math.ceil(context.getViewY(value1));
        long viewY2 = (long)Math.ceil(context.getViewY(value2));
        long l = viewHeight = context.isBottomBased() ? viewY1 - viewY2 : viewY2 - viewY1;
        if (!context.isBottomBased()) {
            viewY2 -= viewHeight;
        }
        LongRect viewBounds = new LongRect(viewX, viewY2, viewWidth, viewHeight);
        LongRect.addBorder((LongRect)viewBounds, (long)this.lineWidth);
        return viewBounds;
    }

    private LongRect getViewBounds(XYItem item, int[] valuesIndexes, ChartContext context) {
        LongRect dataBounds = new LongRect();
        if (valuesIndexes == null) {
            LongRect.set((LongRect)dataBounds, (LongRect)item.getBounds());
        } else {
            boolean firstPoint = true;
            for (int valueIndex : valuesIndexes) {
                if (valueIndex == -1) continue;
                long xValue = item.getXValue(valueIndex);
                long yValue = item.getYValue(valueIndex);
                if (firstPoint) {
                    LongRect.set((LongRect)dataBounds, (long)xValue, (long)yValue, (long)0L, (long)0L);
                    firstPoint = false;
                    continue;
                }
                LongRect.add((LongRect)dataBounds, (long)xValue, (long)yValue);
            }
        }
        if (this.type == 1) {
            return this.getViewBoundsRelative(dataBounds, item, context);
        }
        LongRect viewBounds = context.getViewRect(dataBounds);
        LongRect.addBorder((LongRect)viewBounds, (long)this.lineWidth);
        return viewBounds;
    }

    private static double getItemValueFactor(ChartContext context, double maxValueOffset, double itemHeight) {
        return ((double)context.getDataHeight() - context.getDataHeight(maxValueOffset)) / itemHeight;
    }

    private static double getYValue(XYItem item, int valueIndex, int type, ChartContext context, double itemValueFactor) {
        if (type == 0) {
            return context.getViewY((double)item.getYValue(valueIndex));
        }
        return context.getViewY((double)context.getDataOffsetY() + itemValueFactor * (double)(item.getYValue(valueIndex) - item.getBounds().y));
    }
}

