/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.smali;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.jf.smali.Smali;
import org.jf.smali.SmaliOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmaliConvert
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SmaliConvert.class);
    @Nullable
    private Path tmpDex;

    public boolean execute(List<Path> input) {
        List<Path> smaliFiles = this.filterSmaliFiles(input);
        if (smaliFiles.isEmpty()) {
            return false;
        }
        try {
            this.tmpDex = Files.createTempFile("jadx-", ".dex", new FileAttribute[0]);
            boolean result = SmaliConvert.compileSmali(this.tmpDex, smaliFiles);
            if (result) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Smali process error", (Throwable)e);
        }
        this.close();
        return false;
    }

    private static boolean compileSmali(Path output, List<Path> inputFiles) throws IOException {
        SmaliOptions options = new SmaliOptions();
        options.outputDexFile = output.toAbsolutePath().toString();
        options.verboseErrors = true;
        List inputFileNames = inputFiles.stream().map(p -> p.toAbsolutePath().toString()).distinct().collect(Collectors.toList());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            boolean result = SmaliConvert.collectSystemErrors(out, () -> Smali.assemble((SmaliOptions)options, (List)inputFileNames));
            if (!result) {
                LOG.error("Smali compilation error:\n{}", (Object)out);
            }
            boolean bl = result;
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean collectSystemErrors(OutputStream out, Callable<Boolean> exec) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<Path> filterSmaliFiles(List<Path> input) {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**.smali");
        return input.stream().filter(p -> Files.isRegularFile(p, LinkOption.NOFOLLOW_LINKS)).filter(matcher::matches).collect(Collectors.toList());
    }

    public List<Path> getDexFiles() {
        if (this.tmpDex == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.tmpDex);
    }

    @Override
    public void close() {
        try {
            if (this.tmpDex != null) {
                Files.deleteIfExists(this.tmpDex);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to remove tmp dex file: {}", (Object)this.tmpDex, (Object)e);
        }
    }
}

