/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.std;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import org.jsampler.CC;
import org.jsampler.JSPrefs;
import org.jsampler.task.Global;
import org.jsampler.view.std.StdI18n;
import org.jsampler.view.std.StdUtils;

public class JSGeneralProps {
    private JSGeneralProps() {
    }

    private static JSPrefs preferences() {
        return CC.getViewConfig().preferences();
    }

    public static class RecentScriptsPane
    extends JPanel {
        private final JLabel lRecentScriptsSize = new JLabel(StdI18n.i18n.getLabel("JSGeneralProps.lRecentScriptsSize"));
        private final JSpinner spRecentScriptsSize;
        private final JButton btnClearRecentScriptList = new JButton(StdI18n.i18n.getButtonLabel("JSGeneralProps.btnClearRecentScriptList"));

        public RecentScriptsPane() {
            this.setLayout(new BoxLayout(this, 1));
            int n = JSGeneralProps.preferences().getIntProperty("recentLscpScripts.maxNumber");
            this.spRecentScriptsSize = new JSpinner(new SpinnerNumberModel(n, 0, 100, 1));
            this.spRecentScriptsSize.setMaximumSize(this.spRecentScriptsSize.getPreferredSize());
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.add(this.lRecentScriptsSize);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel.add(this.spRecentScriptsSize);
            jPanel.setAlignmentX(0.5f);
            this.add(jPanel);
            this.add(Box.createRigidArea(new Dimension(0, 6)));
            this.btnClearRecentScriptList.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    JSGeneralProps.preferences().setStringProperty("recentLscpScripts", null);
                    this.clearRecentScripts();
                }
            });
            this.btnClearRecentScriptList.setAlignmentX(0.5f);
            this.add(this.btnClearRecentScriptList);
            this.add(Box.createRigidArea(new Dimension(0, 6)));
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, this.getPreferredSize().height));
            this.setAlignmentX(0.0f);
            String string = StdI18n.i18n.getLabel("JSGeneralProps.recentScripts");
            this.setBorder(BorderFactory.createTitledBorder(string));
        }

        protected void clearRecentScripts() {
        }

        public int getRecentScriptsSize() {
            return Integer.parseInt(this.spRecentScriptsSize.getValue().toString());
        }
    }

    public static class JSamplerHomePane
    extends JPanel {
        private final JTextField tfJSamplerHome = new JTextField();
        private final JButton btnChange = new JButton(StdI18n.i18n.getButtonLabel("JSGeneralProps.btnChange"));

        public JSamplerHomePane() {
            this.setLayout(new BoxLayout(this, 1));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            if (CC.getJSamplerHome() != null) {
                this.tfJSamplerHome.setText(CC.getJSamplerHome());
            }
            Dimension dimension = new Dimension(Short.MAX_VALUE, this.tfJSamplerHome.getPreferredSize().height);
            this.tfJSamplerHome.setMaximumSize(dimension);
            jPanel.add(this.tfJSamplerHome);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
            jPanel.add(this.btnChange);
            jPanel.setBorder(BorderFactory.createEmptyBorder(2, 6, 6, 6));
            jPanel.setAlignmentX(0.5f);
            this.add(jPanel);
            String string = StdI18n.i18n.getLabel("JSGeneralProps.jSamplerHome");
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, this.getPreferredSize().height));
            this.setAlignmentX(0.0f);
            this.btnChange.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    this.onChange();
                }
            });
        }

        private void onChange() {
            File file = StdUtils.showOpenDirectoryChooser(CC.getMainFrame(), null);
            if (file == null) {
                return;
            }
            String string = CC.getJSamplerHome();
            String string2 = File.separator + ".jsampler";
            if (string != null) {
                string2 = File.separator + new File(string).getName();
            }
            this.tfJSamplerHome.setText(file.getPath() + string2);
        }

        public String getJSamplerHome() {
            return this.tfJSamplerHome.getText();
        }
    }

    public static class MaxVolumePane
    extends JPanel {
        private final JLabel lMaxMasterVol = new JLabel(StdI18n.i18n.getLabel("JSGeneralProps.lMaxMasterVol"));
        private final JLabel lMaxChannelVol = new JLabel(StdI18n.i18n.getLabel("JSGeneralProps.lMaxChannelVol"));
        private final JSpinner spMaxMasterVol;
        private final JSpinner spMaxChannelVol;

        public MaxVolumePane() {
            int n = JSGeneralProps.preferences().getIntProperty("maximumMasterVolume");
            this.spMaxMasterVol = new JSpinner(new SpinnerNumberModel(n, 10, 1000, 10));
            n = JSGeneralProps.preferences().getIntProperty("maximumChannelVolume");
            this.spMaxChannelVol = new JSpinner(new SpinnerNumberModel(n, 10, 1000, 10));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagLayout.setConstraints(this.lMaxMasterVol, gridBagConstraints);
            this.add(this.lMaxMasterVol);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.lMaxChannelVol, gridBagConstraints);
            this.add(this.lMaxChannelVol);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.spMaxMasterVol, gridBagConstraints);
            this.add(this.spMaxMasterVol);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.spMaxChannelVol, gridBagConstraints);
            this.add(this.spMaxChannelVol);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.weightx = 1.0;
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            this.setAlignmentX(0.0f);
            this.setOpaque(false);
        }

        public void apply() {
            int n = Integer.parseInt(this.spMaxMasterVol.getValue().toString());
            JSGeneralProps.preferences().setIntProperty("maximumMasterVolume", n);
            n = Integer.parseInt(this.spMaxChannelVol.getValue().toString());
            JSGeneralProps.preferences().setIntProperty("maximumChannelVolume", n);
        }
    }

    public static class PolyphonyPane
    extends JPanel {
        private final JLabel lVoiceLimit = new JLabel(StdI18n.i18n.getLabel("JSGeneralProps.lVoiceLimit"));
        private final JLabel lStreamLimit = new JLabel(StdI18n.i18n.getLabel("JSGeneralProps.lStreamLimit"));
        private final JSpinner spVoiceLimit;
        private final JSpinner spStreamLimit;

        public PolyphonyPane() {
            int n = JSGeneralProps.preferences().getIntProperty("globalVoiceLimit");
            this.spVoiceLimit = new JSpinner(new SpinnerNumberModel(n, 1, 32000, 1));
            n = JSGeneralProps.preferences().getIntProperty("globalStreamLimit");
            this.spStreamLimit = new JSpinner(new SpinnerNumberModel(n, 10, 32000, 1));
            GridBagLayout gridBagLayout = new GridBagLayout();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            this.setLayout(gridBagLayout);
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagLayout.setConstraints(this.lVoiceLimit, gridBagConstraints);
            this.add(this.lVoiceLimit);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.lStreamLimit, gridBagConstraints);
            this.add(this.lStreamLimit);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.spVoiceLimit, gridBagConstraints);
            this.add(this.spVoiceLimit);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagLayout.setConstraints(this.spStreamLimit, gridBagConstraints);
            this.add(this.spStreamLimit);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.weightx = 1.0;
            JPanel jPanel = new JPanel();
            jPanel.setOpaque(false);
            gridBagLayout.setConstraints(jPanel, gridBagConstraints);
            this.add(jPanel);
            this.setAlignmentX(0.0f);
            this.setOpaque(false);
            String string = StdI18n.i18n.getLabel("JSGeneralProps.PolyphonyPane");
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.setMaximumSize(new Dimension(Short.MAX_VALUE, this.getPreferredSize().height));
            this.setAlignmentX(0.0f);
        }

        public void apply() {
            int n = Integer.parseInt(this.spVoiceLimit.getValue().toString());
            JSGeneralProps.preferences().setIntProperty("globalVoiceLimit", n);
            int n2 = Integer.parseInt(this.spStreamLimit.getValue().toString());
            JSGeneralProps.preferences().setIntProperty("globalStreamLimit", n2);
            CC.getTaskQueue().add(new Global.SetPolyphony(n, n2));
        }
    }
}

