/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.javaconvert;

import jadx.api.plugins.utils.ZipSecurity;
import jadx.plugins.input.javaconvert.ConvertResult;
import jadx.plugins.input.javaconvert.DxConverter;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.ClassReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaConvertLoader {
    private static final Logger LOG = LoggerFactory.getLogger(JavaConvertLoader.class);

    public static ConvertResult process(List<Path> input) {
        ConvertResult result = new ConvertResult();
        JavaConvertLoader.processJars(input, result);
        JavaConvertLoader.processClassFiles(input, result);
        return result;
    }

    private static void processJars(List<Path> input, ConvertResult result) {
        PathMatcher jarMatcher = FileSystems.getDefault().getPathMatcher("glob:**.jar");
        input.stream().filter(path -> Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)).filter(jarMatcher::matches).forEach(path -> {
            try {
                JavaConvertLoader.convertJar(result, path);
            }
            catch (Exception e) {
                LOG.error("Failed to convert file: " + path.toAbsolutePath(), (Throwable)e);
            }
        });
    }

    private static void processClassFiles(List<Path> input, ConvertResult result) {
        PathMatcher jarMatcher = FileSystems.getDefault().getPathMatcher("glob:**.class");
        List clsFiles = input.stream().filter(path -> Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)).filter(jarMatcher::matches).collect(Collectors.toList());
        if (clsFiles.isEmpty()) {
            return;
        }
        try {
            Path jarFile = Files.createTempFile("jadx-", ".jar", new FileAttribute[0]);
            try (JarOutputStream jo = new JarOutputStream(Files.newOutputStream(jarFile, new OpenOption[0]));){
                for (Path file : clsFiles) {
                    String clsName = JavaConvertLoader.getNameFromClassFile(file);
                    if (clsName == null || !ZipSecurity.isValidZipEntryName((String)clsName)) {
                        throw new IOException("Can't read class name from file: " + file);
                    }
                    JavaConvertLoader.addFileToJar(jo, file, clsName + ".class");
                }
            }
            result.addTempPath(jarFile);
            LOG.debug("Packed class files {} into jar {}", clsFiles, (Object)jarFile);
            JavaConvertLoader.convertJar(result, jarFile);
        }
        catch (Exception e) {
            LOG.error("Error process class files", (Throwable)e);
        }
    }

    public static String getNameFromClassFile(Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);){
            ClassReader classReader = new ClassReader(in);
            String string = classReader.getClassName();
            return string;
        }
    }

    private static void convertJar(ConvertResult result, Path path) throws Exception {
        Path tempDirectory = Files.createTempDirectory("jadx-", new FileAttribute[0]);
        result.addTempPath(tempDirectory);
        DxConverter.run(path, tempDirectory);
        LOG.debug("Converted to dex: {}", (Object)path.toAbsolutePath());
        result.addConvertedFiles(JavaConvertLoader.collectFilesInDir(tempDirectory));
    }

    private static List<Path> collectFilesInDir(Path tempDirectory) throws IOException {
        PathMatcher dexMatcher = FileSystems.getDefault().getPathMatcher("glob:**.dex");
        try (Stream<Path> pathStream = Files.walk(tempDirectory, 1, new FileVisitOption[0]);){
            List<Path> list = pathStream.filter(p -> Files.isRegularFile(p, LinkOption.NOFOLLOW_LINKS)).filter(dexMatcher::matches).collect(Collectors.toList());
            return list;
        }
    }

    public static void addFileToJar(JarOutputStream jar, Path source, String entryName) throws IOException {
        try (BufferedInputStream in = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));){
            JarEntry entry = new JarEntry(entryName);
            entry.setTime(Files.getLastModifiedTime(source, LinkOption.NOFOLLOW_LINKS).toMillis());
            jar.putNextEntry(entry);
            JavaConvertLoader.copyStream(in, jar);
            jar.closeEntry();
        }
    }

    public static void copyStream(InputStream input, OutputStream output) throws IOException {
        int count;
        byte[] buffer = new byte[8192];
        while ((count = input.read(buffer)) != -1) {
            output.write(buffer, 0, count);
        }
    }
}

