/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.manager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.concurrent.GuardedBy;
import org.gjt.sp.jedit.Buffer;
import org.gjt.sp.jedit.BufferHistory;
import org.gjt.sp.jedit.EditBus;
import org.gjt.sp.jedit.MiscUtilities;
import org.gjt.sp.jedit.OperatingSystem;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.buffer.JEditBuffer;
import org.gjt.sp.jedit.gui.FilesChangedDialog;
import org.gjt.sp.jedit.io.VFSManager;
import org.gjt.sp.jedit.jEdit;
import org.gjt.sp.jedit.manager.BufferManager;
import org.gjt.sp.jedit.msg.BufferUpdate;
import org.gjt.sp.jedit.textarea.DisplayManager;
import org.gjt.sp.jedit.textarea.Selection;
import org.gjt.sp.util.AwtRunnableQueue;
import org.gjt.sp.util.StandardUtilities;

public class BufferManagerImpl
implements BufferManager {
    public static final Buffer[] EMPTY_BUFFER_ARRAY = new Buffer[0];
    private final Object bufferListLock = new Object();
    private final Map<String, Buffer> bufferHash = new HashMap<String, Buffer>();
    private boolean sortBuffers;
    private boolean sortByName;
    private int bufferCount;
    private Buffer buffersFirst;
    private Buffer buffersLast;

    public Object getBufferListLock() {
        return this.bufferListLock;
    }

    @Override
    @GuardedBy(value="bufferListLock")
    public List<Buffer> getBuffers() {
        ArrayList<Buffer> arrayList = new ArrayList<Buffer>(this.bufferCount);
        this.forEach(arrayList::add);
        return arrayList;
    }

    @GuardedBy(value="bufferListLock")
    public List<Buffer> getBuffers(Predicate<Buffer> predicate) {
        ArrayList<Buffer> arrayList = new ArrayList<Buffer>(this.bufferCount);
        this.forEach(buffer -> {
            if (predicate.test((Buffer)buffer)) {
                arrayList.add((Buffer)buffer);
            }
        });
        return arrayList;
    }

    @Override
    public List<Buffer> getTitledBuffers() {
        return this.getBuffers(Buffer::isTitled);
    }

    @Override
    public List<Buffer> getUntitledBuffers() {
        return this.getBuffers(Buffer::isUntitled);
    }

    @Override
    public List<Buffer> getNonUntitledDirtyBuffers() {
        Predicate<Buffer> predicate = Buffer::isTitled;
        Predicate<Buffer> predicate2 = JEditBuffer::isDirty;
        return this.getBuffers(predicate.and(predicate2));
    }

    @Override
    public List<Buffer> getDirtyBuffers() {
        return this.getBuffers(JEditBuffer::isDirty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @GuardedBy(value="bufferListLock")
    public void forEach(Consumer<? super Buffer> consumer) {
        Object object = this.bufferListLock;
        synchronized (object) {
            Buffer buffer = this.buffersFirst;
            for (int i = 0; i < this.bufferCount; ++i) {
                consumer.accept(buffer);
                buffer = buffer.getNext();
            }
        }
    }

    @Override
    public int size() {
        return this.bufferCount;
    }

    @Override
    public Buffer getFirst() {
        return this.buffersFirst;
    }

    public Buffer getLast() {
        return this.buffersLast;
    }

    public void checkBufferStatus(View view, boolean bl, boolean bl2) {
        Buffer buffer = this.buffersFirst;
        int[] nArray = new int[this.bufferCount];
        int n = 0;
        boolean bl3 = false;
        while (buffer != null) {
            if (bl && buffer != view.getBuffer()) {
                buffer = buffer.getNext();
                ++n;
                continue;
            }
            nArray[n] = buffer.checkFileStatus(view);
            switch (nArray[n]) {
                case 1: {
                    if (buffer.getAutoReload()) {
                        if (buffer.isDirty()) {
                            bl3 = true;
                        } else {
                            buffer.load(view, true);
                            Buffer buffer2 = buffer;
                            AwtRunnableQueue.INSTANCE.runAfterIoTasks(() -> this.updateBufferHash(buffer2));
                        }
                    } else {
                        bl2 = false;
                    }
                    if (!buffer.getAutoReloadDialog()) break;
                    bl3 = true;
                    break;
                }
                case 2: {
                    bl3 = true;
                }
            }
            buffer = buffer.getNext();
            ++n;
        }
        if (bl3) {
            new FilesChangedDialog(view, nArray, bl2);
        }
    }

    public void setSortBuffers(boolean bl) {
        this.sortBuffers = bl;
    }

    public void setSortByName(boolean bl) {
        this.sortByName = bl;
    }

    @Override
    public Optional<Buffer> getBuffer(String string) {
        return this._getBuffer(MiscUtilities.resolveSymlinks(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<Buffer> _getBuffer(String string) {
        if ((VFSManager.getVFSForPath(string).getCapabilities() & 0x80) != 0) {
            string = string.toLowerCase();
        }
        Object object = this.bufferListLock;
        synchronized (object) {
            return Optional.ofNullable(this.bufferHash.get(string));
        }
    }

    @Override
    public int getNextUntitledBufferId() {
        int n = 0;
        for (Buffer buffer = this.buffersFirst; buffer != null; buffer = buffer.getNext()) {
            if (!buffer.getName().startsWith("Untitled-")) continue;
            try {
                n = Math.max(n, Integer.parseInt(buffer.getName().substring(9)));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n + 1;
    }

    public void updateBufferHash(Buffer buffer) {
        this.bufferHash.values().removeIf(buffer2 -> buffer == buffer2);
        String string = BufferManagerImpl.getPathForBufferHash(buffer);
        this.bufferHash.put(string, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBufferFromList(Buffer buffer) {
        Object object = this.bufferListLock;
        synchronized (object) {
            --this.bufferCount;
            String string = buffer.getPath();
            if (OperatingSystem.isCaseInsensitiveFS()) {
                string = string.toLowerCase();
            }
            this.bufferHash.remove(string);
            if (buffer == this.buffersFirst && buffer == this.buffersLast) {
                this.buffersLast = null;
                this.buffersFirst = null;
                return;
            }
            if (buffer == this.buffersFirst) {
                this.buffersFirst = buffer.getNext();
                buffer.getNext().setPrev(null);
            } else if (buffer.getPrev() != null) {
                buffer.getPrev().setNext(buffer.getNext());
            }
            if (buffer == this.buffersLast) {
                this.buffersLast = this.buffersLast.getPrev();
                buffer.getPrev().setNext(null);
            } else if (buffer.getNext() != null) {
                buffer.getNext().setPrev(buffer.getPrev());
            }
            buffer.setNext(null);
            buffer.setPrev(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBufferToList(Buffer buffer) {
        Object object = this.bufferListLock;
        synchronized (object) {
            String string = BufferManagerImpl.getPathForBufferHash(buffer);
            ++this.bufferCount;
            this.bufferHash.put(string, buffer);
            if (this.buffersFirst == null) {
                this.buffersFirst = this.buffersLast = buffer;
                return;
            }
            if (this.sortBuffers) {
                String string2;
                String string3;
                if (this.sortByName) {
                    string3 = buffer.getName();
                    string2 = buffer.getDirectory();
                } else {
                    string3 = buffer.getDirectory();
                    string2 = buffer.getName();
                }
                for (Buffer buffer2 = this.buffersFirst; buffer2 != null; buffer2 = buffer2.getNext()) {
                    String string4;
                    String string5;
                    if (this.sortByName) {
                        string5 = buffer2.getName();
                        string4 = buffer2.getDirectory();
                    } else {
                        string5 = buffer2.getDirectory();
                        string4 = buffer2.getName();
                    }
                    int n = StandardUtilities.compareStrings(string3, string5, true);
                    if (n >= 0 && (n != 0 || StandardUtilities.compareStrings(string2, string4, true) >= 0)) continue;
                    buffer.setNext(buffer2);
                    buffer.setPrev(buffer2.getPrev());
                    buffer2.setPrev(buffer);
                    if (buffer2 != this.buffersFirst) {
                        buffer.getPrev().setNext(buffer);
                    } else {
                        this.buffersFirst = buffer;
                    }
                    return;
                }
            }
            buffer.setPrev(this.buffersLast);
            buffer.setNext(null);
            this.buffersLast.setNext(buffer);
            this.buffersLast = buffer;
        }
    }

    public void updatePosition(String string, Buffer buffer) {
        if ((VFSManager.getVFSForPath(string).getCapabilities() & 0x80) != 0) {
            string = string.toLowerCase();
        }
        this.bufferHash.remove(string);
        String string2 = BufferManagerImpl.getPathForBufferHash(buffer);
        this.bufferHash.put(string2, buffer);
        if (this.sortBuffers) {
            this.removeBufferFromList(buffer);
            this.addBufferToList(buffer);
        }
    }

    public void removeBuffer(Buffer buffer) {
        String string = BufferManagerImpl.getPathForBufferHash(buffer);
        this.bufferHash.remove(string);
        this.removeBufferFromList(buffer);
    }

    private static String getPathForBufferHash(Buffer buffer) {
        String string = buffer.getSymlinkPath();
        if ((VFSManager.getVFSForPath(string).getCapabilities() & 0x80) != 0) {
            string = string.toLowerCase();
        }
        return string;
    }

    public void closeAllBuffers(View view, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.buffersLast = null;
        this.buffersFirst = null;
        this.bufferHash.clear();
        this.bufferCount = 0;
        for (Buffer buffer = this.buffersFirst; buffer != null; buffer = buffer.getNext()) {
            if ((!buffer.isNewFile() || buffer.isUntitled() && bl2) && bl3) {
                Integer n = (Integer)buffer.getProperty("Buffer__caret");
                int n2 = n == null ? 0 : n;
                BufferHistory.setEntry(buffer.getPath(), n2, (Selection[])buffer.getProperty("Buffer__selection"), buffer.getStringProperty("encoding"), buffer.getMode().getName());
            }
            if (!(bl || buffer.isUntitled() && bl2)) {
                EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSING));
            }
            buffer.close();
            DisplayManager.bufferClosed(buffer);
            if (!(bl || buffer.isUntitled() && bl2)) {
                jEdit.getBufferSetManager().removeBuffer(buffer);
                EditBus.send(new BufferUpdate(buffer, view, BufferUpdate.CLOSED));
            }
            if (!jEdit.getBooleanProperty("persistentMarkers")) continue;
            buffer.updateMarkersFile(view);
        }
    }
}

