/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view.fantasia;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.juife.event.TaskEvent;
import net.sf.juife.event.TaskListener;
import org.jsampler.CC;
import org.jsampler.SamplerChannelModel;
import org.jsampler.event.SamplerChannelAdapter;
import org.jsampler.event.SamplerChannelEvent;
import org.jsampler.event.SamplerChannelListEvent;
import org.jsampler.event.SamplerChannelListListener;
import org.jsampler.task.Global;
import org.jsampler.view.JSChannel;
import org.jsampler.view.fantasia.FantasiaI18n;
import org.jsampler.view.fantasia.MainFrame;
import org.jsampler.view.fantasia.Res;
import org.jsampler.view.fantasia.basic.FantasiaLabel;
import org.jsampler.view.fantasia.basic.FantasiaPainter;
import org.jsampler.view.fantasia.basic.FantasiaPanel;
import org.jsampler.view.fantasia.basic.PixmapButton;
import org.jsampler.view.fantasia.basic.PixmapPane;
import org.jsampler.view.fantasia.basic.PixmapToggleButton;
import org.jsampler.view.std.JSPianoRoll;
import org.linuxsampler.lscp.Instrument;
import org.linuxsampler.lscp.SamplerChannel;
import org.linuxsampler.lscp.event.MidiDataEvent;
import org.linuxsampler.lscp.event.MidiDataListener;

public class PianoKeyboardPane
extends FantasiaPanel
implements ListSelectionListener,
SamplerChannelListListener {
    protected final JToggleButton btnPower = new PowerButton();
    private final FantasiaLabel lDisplay = new FantasiaLabel(" ", true);
    private final JSPianoRoll pianoRoll = new JSPianoRoll();
    private SamplerChannelModel channel = null;
    private String file = null;
    private int index = -1;
    private Color color1 = new Color(0x7A7A7A);
    private Color color2 = new Color(0x5E5E5E);
    private Color color3 = new Color(0x2E2E2E);
    private final Handler handler = new Handler();

    public PianoKeyboardPane() {
        this.pianoRoll.actionDecreaseKeyNumber.putValue("SmallIcon", Res.gfxBtnDecrease);
        this.pianoRoll.actionIncreaseKeyNumber.putValue("SmallIcon", Res.gfxBtnIncrease);
        this.pianoRoll.actionScrollLeft.putValue("SmallIcon", Res.gfxBtnScrollLeft);
        this.pianoRoll.actionScrollRight.putValue("SmallIcon", Res.gfxBtnScrollRight);
        this.setOpaque(false);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBorder(BorderFactory.createEmptyBorder(0, 3, 5, 3));
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        gridBagLayout.setConstraints(this.btnPower, gridBagConstraints);
        this.add(this.btnPower);
        JPanel jPanel = this.createVSeparator();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(3, 0, 5, 3);
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        jPanel = new KeyRangePropsPane();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        jPanel = new KeyRangePropsPane();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(0, 0, 0, 10);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        this.lDisplay.setPreferredSize(new Dimension(300, this.lDisplay.getPreferredSize().height));
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 12);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.lDisplay, gridBagConstraints);
        this.add(this.lDisplay);
        jPanel = new JPanel();
        jPanel.setOpaque(false);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        jPanel = new JPanel();
        jPanel.setOpaque(false);
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        this.pianoRoll.setFocusable(false);
        this.pianoRoll.setBackground(new Color(0x2E2E2E));
        this.disablePianoRoll();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.insets = new Insets(0, 3, 0, 12);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(this.pianoRoll, gridBagConstraints);
        this.add(this.pianoRoll);
        CC.getSamplerModel().addSamplerChannelListListener(this);
        this.pianoRoll.addMidiDataListener(this.getHandler());
        this.updateKeyRange();
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                PianoKeyboardPane.this.updateKeyRange();
            }
        };
        CC.preferences().addPropertyChangeListener("midiKeyboard.firstKey", propertyChangeListener);
        CC.preferences().addPropertyChangeListener("midiKeyboard.lastKey", propertyChangeListener);
        this.addFocusListener(this.getHandler());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                PianoKeyboardPane.this.requestFocusInWindow();
            }
        };
        this.addKeyListener(this.pianoRoll.getKeyListener());
        this.pianoRoll.registerKeys(this);
        this.addMouseListener(mouseAdapter);
        this.pianoRoll.addMouseListener(mouseAdapter);
        this.lDisplay.addMouseListener(mouseAdapter);
    }

    public JSPianoRoll getPianoRoll() {
        return this.pianoRoll;
    }

    private void updateKeyRange() {
        int n = CC.preferences().getIntProperty("midiKeyboard.firstKey");
        int n2 = CC.preferences().getIntProperty("midiKeyboard.lastKey");
        this.pianoRoll.setKeyRange(n, n2);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        JSChannel[] jSChannelArray = CC.getMainFrame().getSelectedChannelsPane().getSelectedChannels();
        if (jSChannelArray == null || jSChannelArray.length == 0) {
            this.disconnectChannel();
            return;
        }
        if (jSChannelArray[0].getModel() == this.channel) {
            return;
        }
        this.disconnectChannel();
        this.connectChannel(jSChannelArray[0].getModel());
    }

    private void updateInstrumentInfo() {
        final Global.GetFileInstrument getFileInstrument = new Global.GetFileInstrument(this.file, this.index);
        getFileInstrument.addTaskListener(new TaskListener(){

            @Override
            public void taskPerformed(TaskEvent taskEvent) {
                if (getFileInstrument.doneWithErrors()) {
                    return;
                }
                PianoKeyboardPane.this.updatePianoKeyboard((Instrument)getFileInstrument.getResult());
            }
        });
        CC.getTaskQueue().add(getFileInstrument);
    }

    private void disablePianoRoll() {
        this.pianoRoll.reset(true);
        this.pianoRoll.setPlayingEnabled(false);
    }

    private void updatePianoKeyboard(Instrument instrument) {
        if (instrument == null || this.file == null) {
            this.disablePianoRoll();
            return;
        }
        this.pianoRoll.setPlayingEnabled(true);
        this.pianoRoll.setShouldRepaint(false);
        this.pianoRoll.reset(true);
        this.pianoRoll.setDisabled(instrument.getKeyMapping(), false);
        this.pianoRoll.setKeyswitches(instrument.getKeyswitchMapping(), true);
        this.pianoRoll.setShouldRepaint(true);
        this.pianoRoll.repaint();
    }

    private void connectChannel(SamplerChannelModel samplerChannelModel) {
        this.channel = samplerChannelModel;
        this.channel.addMidiDataListener(this.pianoRoll);
        this.channel.addSamplerChannelListener(this.getHandler());
        this.updateDisplay();
        this.file = this.channel.getChannelInfo().getInstrumentFile();
        if (this.file == null) {
            this.disablePianoRoll();
            return;
        }
        this.index = this.channel.getChannelInfo().getInstrumentIndex();
        this.updateInstrumentInfo();
    }

    private void disconnectChannel() {
        if (this.channel != null) {
            this.channel.removeMidiDataListener(this.pianoRoll);
            this.channel.removeSamplerChannelListener(this.getHandler());
            this.channel = null;
            this.file = null;
            this.index = -1;
            this.disablePianoRoll();
        }
        this.updateDisplay();
    }

    @Override
    public void channelAdded(SamplerChannelListEvent samplerChannelListEvent) {
        if (CC.getSamplerModel().getChannelListIsAdjusting()) {
            return;
        }
        this.updateDisplay();
    }

    @Override
    public void channelRemoved(SamplerChannelListEvent samplerChannelListEvent) {
        if (samplerChannelListEvent.getChannelModel() == this.channel) {
            this.disconnectChannel();
        }
        this.updateDisplay();
    }

    private JPanel createVSeparator() {
        PixmapPane pixmapPane = new PixmapPane(Res.gfxVLine);
        pixmapPane.setAlignmentY(0.0f);
        pixmapPane.setMinimumSize(new Dimension(2, 30));
        pixmapPane.setPreferredSize(new Dimension(2, 60));
        pixmapPane.setMaximumSize(new Dimension(2, Short.MAX_VALUE));
        return pixmapPane;
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Paint paint = graphics2D.getPaint();
        Composite composite = graphics2D.getComposite();
        Insets insets = this.getInsets();
        double d = insets.left;
        double d2 = insets.top;
        double d3 = this.getSize().getWidth();
        double d4 = d3 - (double)insets.right - 1.0;
        double d5 = this.getSize().getHeight();
        double d6 = d5 - (double)insets.bottom - 1.0;
        FantasiaPainter.paintGradient(graphics2D, d, d2, d4, d6 - 10.0, this.color1, this.color2);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        double d7 = d6 - 10.0;
        if (d7 < 0.0) {
            d7 = 0.0;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(d, d7, d4 - d + 1.0, 11.0);
        GradientPaint gradientPaint = new GradientPaint(0.0f, (float)d7, this.color2, 0.0f, (float)d5, this.color3);
        graphics2D.setPaint(gradientPaint);
        graphics2D.fill(double_);
        this.drawOutBorder(graphics2D, d, d2, d4, d6);
        double d8 = this.pianoRoll.getLocation().getX();
        double d9 = this.pianoRoll.getLocation().getY();
        this.drawInBorder(graphics2D, d8 - 2.0, d9 - 2.0, d8 + this.pianoRoll.getSize().getWidth() + 1.0, d9 + this.pianoRoll.getSize().getHeight() - 3.0);
        graphics2D.setPaint(paint);
        graphics2D.setComposite(composite);
    }

    private void drawOutBorder(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setPaint(Color.WHITE);
        Line2D.Double double_ = new Line2D.Double(d, d2, d3, d2);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.2f));
        double_ = new Line2D.Double(d, d2 + 1.0, d3, d2 + 1.0);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.255f));
        double_ = new Line2D.Double(d, d2, d, d4);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.4f));
        graphics2D.setPaint(Color.BLACK);
        graphics2D.setComposite(alphaComposite.derive(0.2f));
        double_ = new Line2D.Double(d3, d2, d3, d4);
        graphics2D.draw(double_);
    }

    private void drawInBorder(Graphics2D graphics2D, double d, double d2, double d3, double d4) {
        AlphaComposite alphaComposite = AlphaComposite.getInstance(3, 0.4f);
        graphics2D.setComposite(alphaComposite);
        graphics2D.setPaint(Color.WHITE);
        Line2D.Double double_ = new Line2D.Double(d, d4, d3, d4);
        graphics2D.setComposite(alphaComposite.derive(0.255f));
        double_ = new Line2D.Double(d3 - 1.0, d2 + 1.0, d3 - 1.0, d4 + 1.0);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.13f));
        double_ = new Line2D.Double(d3, d2, d3, d4);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.2f));
        graphics2D.setPaint(Color.BLACK);
        double_ = new Line2D.Double(d, d2, d3, d2);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.4f));
        graphics2D.setPaint(Color.BLACK);
        double_ = new Line2D.Double(d + 1.0, d2 + 1.0, d3 - 1.0, d2 + 1.0);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.2f));
        double_ = new Line2D.Double(d, d2, d, d4);
        graphics2D.draw(double_);
        graphics2D.setComposite(alphaComposite.derive(0.4f));
        double_ = new Line2D.Double(d + 1.0, d2 + 1.0, d + 1.0, d4 + 1.0);
        graphics2D.draw(double_);
    }

    private void updateDisplay() {
        if (this.channel == null) {
            this.lDisplay.setText(FantasiaI18n.i18n.getLabel("PianoKeyboardPane.noChannel"));
            return;
        }
        SamplerChannel samplerChannel = this.channel.getChannelInfo();
        String string = CC.getMainFrame().getChannelPath(this.channel);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(FantasiaI18n.i18n.getLabel("PianoKeyboardPane.channel", string)).append(" - ");
        int n = samplerChannel.getInstrumentStatus();
        if (n >= 0 && n < 100) {
            stringBuffer.append(FantasiaI18n.i18n.getLabel("ChannelScreen.loadingInstrument", n));
        } else if (n == -1) {
            stringBuffer.append(FantasiaI18n.i18n.getLabel("PianoKeyboardPane.noInstrument"));
        } else if (n < -1) {
            stringBuffer.append(FantasiaI18n.i18n.getLabel("ChannelScreen.errorLoadingInstrument"));
        } else if (samplerChannel.getInstrumentName() != null) {
            stringBuffer.append(samplerChannel.getInstrumentName());
        }
        this.lDisplay.setText(stringBuffer.toString());
    }

    private Handler getHandler() {
        return this.handler;
    }

    private class Handler
    extends SamplerChannelAdapter
    implements FocusListener,
    MidiDataListener {
        private Handler() {
        }

        @Override
        public void midiDataArrived(MidiDataEvent midiDataEvent) {
            if (PianoKeyboardPane.this.channel == null) {
                return;
            }
            PianoKeyboardPane.this.channel.sendBackendMidiData(midiDataEvent);
        }

        @Override
        public void channelChanged(SamplerChannelEvent samplerChannelEvent) {
            PianoKeyboardPane.this.updateDisplay();
            String string = PianoKeyboardPane.this.channel.getChannelInfo().getInstrumentFile();
            int n = PianoKeyboardPane.this.channel.getChannelInfo().getInstrumentIndex();
            if (PianoKeyboardPane.this.channel.getChannelInfo().getInstrumentStatus() != 100) {
                PianoKeyboardPane.this.pianoRoll.setAllKeysPressed(false);
                PianoKeyboardPane.this.pianoRoll.removeAllKeyswitches();
                PianoKeyboardPane.this.pianoRoll.setAllKeysDisabled(true);
                PianoKeyboardPane.this.pianoRoll.setPlayingEnabled(false);
                return;
            }
            if (string == null) {
                if (PianoKeyboardPane.this.file != null) {
                    PianoKeyboardPane.this.disablePianoRoll();
                }
                PianoKeyboardPane.this.file = null;
                PianoKeyboardPane.this.index = -1;
                return;
            }
            if (string.equals(PianoKeyboardPane.this.file) && n == PianoKeyboardPane.this.index) {
                return;
            }
            PianoKeyboardPane.this.file = string;
            PianoKeyboardPane.this.index = n;
            PianoKeyboardPane.this.updateInstrumentInfo();
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }
    }

    public static class PowerButton
    extends PixmapToggleButton
    implements ActionListener {
        PowerButton() {
            this(Res.gfxPowerOff, Res.gfxPowerOn);
        }

        PowerButton(ImageIcon imageIcon, ImageIcon imageIcon2) {
            super(imageIcon, imageIcon2);
            this.setSelected(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.isSelected();
            MainFrame mainFrame = (MainFrame)CC.getMainFrame();
            if (mainFrame == null) {
                return;
            }
            mainFrame.setMidiKeyboardVisible(bl);
        }

        @Override
        public boolean contains(int n, int n2) {
            return (n - 11) * (n - 11) + (n2 - 11) * (n2 - 11) < 71;
        }
    }

    class KeyRangePropsPane
    extends JPanel {
        private final JButton btnIncrease;
        private final JButton btnDecrease;
        private final JButton btnScrollLeft;
        private final JButton btnScrollRight;

        KeyRangePropsPane() {
            this.btnIncrease = new PixmapButton(((PianoKeyboardPane)PianoKeyboardPane.this).pianoRoll.actionIncreaseKeyNumber, Res.gfxBtnIncrease);
            this.btnDecrease = new PixmapButton(((PianoKeyboardPane)PianoKeyboardPane.this).pianoRoll.actionDecreaseKeyNumber, Res.gfxBtnDecrease);
            this.btnScrollLeft = new PixmapButton(((PianoKeyboardPane)PianoKeyboardPane.this).pianoRoll.actionScrollLeft, Res.gfxBtnScrollLeft);
            this.btnScrollRight = new PixmapButton(((PianoKeyboardPane)PianoKeyboardPane.this).pianoRoll.actionScrollRight, Res.gfxBtnScrollRight);
            this.setOpaque(false);
            this.setLayout(new BoxLayout(this, 0));
            this.btnIncrease.setFocusable(false);
            this.btnDecrease.setFocusable(false);
            this.btnScrollLeft.setFocusable(false);
            this.btnScrollRight.setFocusable(false);
            this.btnDecrease.setPressedIcon(Res.gfxBtnDecreaseRO);
            this.add(this.btnDecrease);
            this.btnIncrease.setPressedIcon(Res.gfxBtnIncreaseRO);
            this.add(this.btnIncrease);
            this.add(Box.createRigidArea(new Dimension(6, 0)));
            this.btnScrollLeft.setPressedIcon(Res.gfxBtnScrollLeftRO);
            this.add(this.btnScrollLeft);
            this.btnScrollRight.setPressedIcon(Res.gfxBtnScrollRightRO);
            this.add(this.btnScrollRight);
        }
    }
}

